/*!
	========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
*/
package com.sap.dbtech.jdbc.translators;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.vsp00.StreamHandle;

/**
 * PUTVAL instance for ABAP Stream.
 */
public class BinaryABAPStreamPutval
	extends AbstractABAPStreamPutval 
{
	private InputStream stream;

	/**
	 * Constructor.
	 * @param translator The parameter info.
	 * @param bs The content to stream.
	 */
	public BinaryABAPStreamPutval(ABAPStreamTranslator translator, byte[] bs, boolean isUnicodeConnection) {
		this(translator, new ByteArrayInputStream(bs), -1);		
	}

	/**
	 * Constructor.
	 * @param translator The parameter info.
	 * @param stream The stream.
	 * @param length The stream length;
	 */
	public BinaryABAPStreamPutval(ABAPStreamTranslator translator, InputStream stream, int length) {
		super(translator);
		if(length >=0 ) {
			this.stream = new InputStreamFilter(stream, length);
		} else {
			this.stream = stream;
		}
		// make a descriptor for 1 column
		clearColumns();
		addColumn(StreamHandle.Stream_IN_C,
  	    	 	  StreamHandle.StreamType_Char_C,
            	  1,
		  	  	  0,
			  	  1,
			  	  0);
					  	 
	}
	
	public void transferStream(DataPart dataPart)
		throws SQLException {
		boolean streamExhausted = dataPart.fillWithOMSStream(stream, false);
		if(streamExhausted) {
			try {
				this.stream.close();
			} catch(IOException ioex) {
				throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_IOEXCEPTION,
																		ioex.getMessage()));	
			}
			this.stream = null;	
		}
	}
	
	public boolean atEnd() {
		return this.stream == null;
	}

}
