#!/usr/bin/ruby

require "ftools"

def copy_recursively( dir_name, dest )
	Dir.entries( dir_name ).each { |fname|
		real_dirloc = File.join( dir_name, fname )
		if File.stat(real_dirloc).directory?
			unless fname =~ /^\./
				dest_dir = File.join( dest, fname )
				File.makedirs( dest_dir )
				copy_recursively( real_dirloc, dest_dir )
			end
		else # file
			File.copy(real_dirloc, File.join( dest, fname ))
		end
	}
end

File.makedirs( "rexml_dist" )

copy_recursively "rexml", "rexml_dist"
File.copy( "LICENSE.txt", "rexml_dist" )
File.copy( "GPL.txt", "rexml_dist" )
File.copy( "README", "rexml_dist" )
