require './lib/needle/extras/version'

Gem::Specification.new do |s|

   s.name = 'needle-extras'
   s.version = Needle::Extras::Version::STRING
   s.platform = Gem::Platform::RUBY
   s.summary = %q{Needle-Extras is a collection of additional services that can be used with Needle. This is basically a test-bed of services that may eventually find their way into Needle itself.}
   s.files = Dir.glob("{doc,examples,lib,test}/**/*").delete_if { |item| item.include?( "CVS" ) }
   s.files.concat [ "LICENSE", "Rakefile", "NEWS" ]
   s.files << "ChangeLog" if File.exist?( "ChangeLog" )
   s.require_path = 'lib'
   s.autorequire = 'needle/extras'

   s.add_dependency 'needle', '>= 1.2.0'

   s.has_rdoc=true
   s.extra_rdoc_files = [ 'doc/README' ]
   s.rdoc_options << '--title' << 'Needle-Extras -- Services for Needle' << 
    '--main' << 'doc/README'

   s.test_suite_file = 'test/ALL-TESTS.rb'

   s.author = "Jamis Buck"
   s.email = "jgb3@email.byu.edu"
   s.homepage = "http://needle.rubyforge.org"

end
