/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.maven.hints.pom;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JCheckBox;
import javax.swing.LayoutStyle.ComponentPlacement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/**
 *
 * @author mkleint
 */
public class ReleaseVersionErrorCustomizer extends javax.swing.JPanel {
    private final Preferences preferences;
    private final Map<String, Object> id2Saved = new HashMap<String, Object>();

    /** Creates new form ReleaseVersionErrorCustomizer */
    public ReleaseVersionErrorCustomizer(Preferences prefs) {
        initComponents();
        this.preferences = prefs;
        cbRelease.setSelected(preferences.getBoolean(ReleaseVersionError.PROP_RELEASE, true));
        cbLatest.setSelected(preferences.getBoolean(ReleaseVersionError.PROP_LATEST, true));
        cbSnapshot.setSelected(preferences.getBoolean(ReleaseVersionError.PROP_SNAPSHOT, false));
    
        id2Saved.put(ReleaseVersionError.PROP_RELEASE, cbRelease.isSelected());
        id2Saved.put(ReleaseVersionError.PROP_LATEST, cbLatest.isSelected());
        id2Saved.put(ReleaseVersionError.PROP_SNAPSHOT, cbSnapshot.isSelected());
    }
    
    String getSavedValue(String key) {
        return id2Saved.get(key).toString();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        cbRelease = new JCheckBox();
        cbLatest = new JCheckBox();
        cbSnapshot = new JCheckBox();
        Mnemonics.setLocalizedText(cbRelease, NbBundle.getMessage(ReleaseVersionErrorCustomizer.class, "ReleaseVersionErrorCustomizer.cbRelease.text"));
        cbRelease.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                cbReleaseActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(cbLatest, NbBundle.getMessage(ReleaseVersionErrorCustomizer.class, "ReleaseVersionErrorCustomizer.cbLatest.text"));
        cbLatest.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                cbLatestActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(cbSnapshot, NbBundle.getMessage(ReleaseVersionErrorCustomizer.class, "ReleaseVersionErrorCustomizer.cbSnapshot.text"));
        cbSnapshot.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                cbSnapshotActionPerformed(evt);
            }
        });

        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(Alignment.LEADING)
                    .addComponent(cbRelease)
                    .addComponent(cbLatest)
                    .addComponent(cbSnapshot))
                .addContainerGap(118, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(cbRelease)
                .addPreferredGap(ComponentPlacement.UNRELATED)
                .addComponent(cbLatest)
                .addPreferredGap(ComponentPlacement.UNRELATED)
                .addComponent(cbSnapshot)
                .addContainerGap(215, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void cbReleaseActionPerformed(ActionEvent evt) {//GEN-FIRST:event_cbReleaseActionPerformed
        preferences.putBoolean(ReleaseVersionError.PROP_RELEASE, cbRelease.isSelected());
    }//GEN-LAST:event_cbReleaseActionPerformed

    private void cbLatestActionPerformed(ActionEvent evt) {//GEN-FIRST:event_cbLatestActionPerformed
        preferences.putBoolean(ReleaseVersionError.PROP_LATEST, cbLatest.isSelected());
    }//GEN-LAST:event_cbLatestActionPerformed

    private void cbSnapshotActionPerformed(ActionEvent evt) {//GEN-FIRST:event_cbSnapshotActionPerformed
        preferences.putBoolean(ReleaseVersionError.PROP_SNAPSHOT, cbSnapshot.isSelected());
    }//GEN-LAST:event_cbSnapshotActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JCheckBox cbLatest;
    private JCheckBox cbRelease;
    private JCheckBox cbSnapshot;
    // End of variables declaration//GEN-END:variables

}
