/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.FrontendDefaultHandler;
import org.jfree.xml.ParseException;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.jfree.xml.parser.coretypes.GenericReadHandler;
import org.jfree.xml.util.ManualMappingDefinition;
import org.jfree.xml.util.MultiplexMappingDefinition;
import org.jfree.xml.util.MultiplexMappingEntry;
import org.jfree.xml.util.ObjectFactory;
import org.jfree.xml.util.SimpleObjectFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class RootXmlReadHandler
extends FrontendDefaultHandler {
    private Stack currentHandlers;
    private Stack outerScopes;
    private XmlReadHandler rootHandler;
    private HashMap objectRegistry = new HashMap();
    private SimpleObjectFactory classToHandlerMapping = new SimpleObjectFactory();
    private boolean rootHandlerInitialized;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$awt$GradientPaint;
    static /* synthetic */ Class class$java$awt$Paint;
    static /* synthetic */ Class class$org$jfree$xml$parser$coretypes$ColorReadHandler;
    static /* synthetic */ Class class$org$jfree$xml$parser$coretypes$GradientPaintReadHandler;
    static /* synthetic */ Class class$java$awt$geom$Point2D$Float;
    static /* synthetic */ Class class$java$awt$geom$Point2D$Double;
    static /* synthetic */ Class class$java$awt$geom$Point2D;
    static /* synthetic */ Class class$org$jfree$xml$parser$coretypes$Point2DReadHandler;
    static /* synthetic */ Class class$java$awt$geom$Rectangle2D$Float;
    static /* synthetic */ Class class$java$awt$geom$Rectangle2D$Double;
    static /* synthetic */ Class class$java$awt$geom$Rectangle2D;
    static /* synthetic */ Class class$org$jfree$xml$parser$coretypes$Rectangle2DReadHandler;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Stack;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$org$jfree$xml$parser$coretypes$ListReadHandler;
    static /* synthetic */ Class class$java$awt$BasicStroke;
    static /* synthetic */ Class class$java$awt$Stroke;
    static /* synthetic */ Class class$org$jfree$xml$parser$coretypes$BasicStrokeReadHandler;
    static /* synthetic */ Class class$java$awt$Font;
    static /* synthetic */ Class class$org$jfree$xml$parser$coretypes$FontReadHandler;
    static /* synthetic */ Class class$java$awt$Insets;
    static /* synthetic */ Class class$org$jfree$xml$parser$coretypes$InsetsReadHandler;
    static /* synthetic */ Class class$java$awt$RenderingHints;
    static /* synthetic */ Class class$org$jfree$xml$parser$coretypes$RenderingHintsReadHandler;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jfree$xml$parser$coretypes$StringReadHandler;
    static /* synthetic */ Class class$org$jfree$xml$parser$XmlReadHandler;

    protected void addDefaultMappings() {
        MultiplexMappingEntry[] paintEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("color", (class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = RootXmlReadHandler.class$("java.awt.Color"))).getName()), new MultiplexMappingEntry("gradientPaint", (class$java$awt$GradientPaint != null ? class$java$awt$GradientPaint : (class$java$awt$GradientPaint = RootXmlReadHandler.class$("java.awt.GradientPaint"))).getName())};
        this.addMultiplexMapping(class$java$awt$Paint != null ? class$java$awt$Paint : (class$java$awt$Paint = RootXmlReadHandler.class$("java.awt.Paint")), "type", paintEntries);
        this.addManualMapping(class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = RootXmlReadHandler.class$("java.awt.Color")), class$org$jfree$xml$parser$coretypes$ColorReadHandler != null ? class$org$jfree$xml$parser$coretypes$ColorReadHandler : (class$org$jfree$xml$parser$coretypes$ColorReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.ColorReadHandler")));
        this.addManualMapping(class$java$awt$GradientPaint != null ? class$java$awt$GradientPaint : (class$java$awt$GradientPaint = RootXmlReadHandler.class$("java.awt.GradientPaint")), class$org$jfree$xml$parser$coretypes$GradientPaintReadHandler != null ? class$org$jfree$xml$parser$coretypes$GradientPaintReadHandler : (class$org$jfree$xml$parser$coretypes$GradientPaintReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.GradientPaintReadHandler")));
        MultiplexMappingEntry[] point2DEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("float", (class$java$awt$geom$Point2D$Float != null ? class$java$awt$geom$Point2D$Float : (class$java$awt$geom$Point2D$Float = RootXmlReadHandler.class$("java.awt.geom.Point2D$Float"))).getName()), new MultiplexMappingEntry("double", (class$java$awt$geom$Point2D$Double != null ? class$java$awt$geom$Point2D$Double : (class$java$awt$geom$Point2D$Double = RootXmlReadHandler.class$("java.awt.geom.Point2D$Double"))).getName())};
        this.addMultiplexMapping(class$java$awt$geom$Point2D != null ? class$java$awt$geom$Point2D : (class$java$awt$geom$Point2D = RootXmlReadHandler.class$("java.awt.geom.Point2D")), "type", point2DEntries);
        this.addManualMapping(class$java$awt$geom$Point2D$Float != null ? class$java$awt$geom$Point2D$Float : (class$java$awt$geom$Point2D$Float = RootXmlReadHandler.class$("java.awt.geom.Point2D$Float")), class$org$jfree$xml$parser$coretypes$Point2DReadHandler != null ? class$org$jfree$xml$parser$coretypes$Point2DReadHandler : (class$org$jfree$xml$parser$coretypes$Point2DReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.Point2DReadHandler")));
        this.addManualMapping(class$java$awt$geom$Point2D$Double != null ? class$java$awt$geom$Point2D$Double : (class$java$awt$geom$Point2D$Double = RootXmlReadHandler.class$("java.awt.geom.Point2D$Double")), class$org$jfree$xml$parser$coretypes$Point2DReadHandler != null ? class$org$jfree$xml$parser$coretypes$Point2DReadHandler : (class$org$jfree$xml$parser$coretypes$Point2DReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.Point2DReadHandler")));
        MultiplexMappingEntry[] rectangle2DEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("float", (class$java$awt$geom$Rectangle2D$Float != null ? class$java$awt$geom$Rectangle2D$Float : (class$java$awt$geom$Rectangle2D$Float = RootXmlReadHandler.class$("java.awt.geom.Rectangle2D$Float"))).getName()), new MultiplexMappingEntry("double", (class$java$awt$geom$Rectangle2D$Double != null ? class$java$awt$geom$Rectangle2D$Double : (class$java$awt$geom$Rectangle2D$Double = RootXmlReadHandler.class$("java.awt.geom.Rectangle2D$Double"))).getName())};
        this.addMultiplexMapping(class$java$awt$geom$Rectangle2D != null ? class$java$awt$geom$Rectangle2D : (class$java$awt$geom$Rectangle2D = RootXmlReadHandler.class$("java.awt.geom.Rectangle2D")), "type", rectangle2DEntries);
        this.addManualMapping(class$java$awt$geom$Rectangle2D$Float != null ? class$java$awt$geom$Rectangle2D$Float : (class$java$awt$geom$Rectangle2D$Float = RootXmlReadHandler.class$("java.awt.geom.Rectangle2D$Float")), class$org$jfree$xml$parser$coretypes$Rectangle2DReadHandler != null ? class$org$jfree$xml$parser$coretypes$Rectangle2DReadHandler : (class$org$jfree$xml$parser$coretypes$Rectangle2DReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.Rectangle2DReadHandler")));
        this.addManualMapping(class$java$awt$geom$Rectangle2D$Double != null ? class$java$awt$geom$Rectangle2D$Double : (class$java$awt$geom$Rectangle2D$Double = RootXmlReadHandler.class$("java.awt.geom.Rectangle2D$Double")), class$org$jfree$xml$parser$coretypes$Rectangle2DReadHandler != null ? class$org$jfree$xml$parser$coretypes$Rectangle2DReadHandler : (class$org$jfree$xml$parser$coretypes$Rectangle2DReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.Rectangle2DReadHandler")));
        MultiplexMappingEntry[] listEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("array-list", (class$java$util$ArrayList != null ? class$java$util$ArrayList : (class$java$util$ArrayList = RootXmlReadHandler.class$("java.util.ArrayList"))).getName()), new MultiplexMappingEntry("linked-list", (class$java$util$LinkedList != null ? class$java$util$LinkedList : (class$java$util$LinkedList = RootXmlReadHandler.class$("java.util.LinkedList"))).getName()), new MultiplexMappingEntry("vector", (class$java$util$Vector != null ? class$java$util$Vector : (class$java$util$Vector = RootXmlReadHandler.class$("java.util.Vector"))).getName()), new MultiplexMappingEntry("stack", (class$java$util$Stack != null ? class$java$util$Stack : (class$java$util$Stack = RootXmlReadHandler.class$("java.util.Stack"))).getName())};
        this.addMultiplexMapping(class$java$util$List != null ? class$java$util$List : (class$java$util$List = RootXmlReadHandler.class$("java.util.List")), "type", listEntries);
        this.addManualMapping(class$java$util$LinkedList != null ? class$java$util$LinkedList : (class$java$util$LinkedList = RootXmlReadHandler.class$("java.util.LinkedList")), class$org$jfree$xml$parser$coretypes$ListReadHandler != null ? class$org$jfree$xml$parser$coretypes$ListReadHandler : (class$org$jfree$xml$parser$coretypes$ListReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.ListReadHandler")));
        this.addManualMapping(class$java$util$Vector != null ? class$java$util$Vector : (class$java$util$Vector = RootXmlReadHandler.class$("java.util.Vector")), class$org$jfree$xml$parser$coretypes$ListReadHandler != null ? class$org$jfree$xml$parser$coretypes$ListReadHandler : (class$org$jfree$xml$parser$coretypes$ListReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.ListReadHandler")));
        this.addManualMapping(class$java$util$ArrayList != null ? class$java$util$ArrayList : (class$java$util$ArrayList = RootXmlReadHandler.class$("java.util.ArrayList")), class$org$jfree$xml$parser$coretypes$ListReadHandler != null ? class$org$jfree$xml$parser$coretypes$ListReadHandler : (class$org$jfree$xml$parser$coretypes$ListReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.ListReadHandler")));
        this.addManualMapping(class$java$util$Stack != null ? class$java$util$Stack : (class$java$util$Stack = RootXmlReadHandler.class$("java.util.Stack")), class$org$jfree$xml$parser$coretypes$ListReadHandler != null ? class$org$jfree$xml$parser$coretypes$ListReadHandler : (class$org$jfree$xml$parser$coretypes$ListReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.ListReadHandler")));
        MultiplexMappingEntry[] strokeEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("basic", (class$java$awt$BasicStroke != null ? class$java$awt$BasicStroke : (class$java$awt$BasicStroke = RootXmlReadHandler.class$("java.awt.BasicStroke"))).getName())};
        this.addMultiplexMapping(class$java$awt$Stroke != null ? class$java$awt$Stroke : (class$java$awt$Stroke = RootXmlReadHandler.class$("java.awt.Stroke")), "type", strokeEntries);
        this.addManualMapping(class$java$awt$BasicStroke != null ? class$java$awt$BasicStroke : (class$java$awt$BasicStroke = RootXmlReadHandler.class$("java.awt.BasicStroke")), class$org$jfree$xml$parser$coretypes$BasicStrokeReadHandler != null ? class$org$jfree$xml$parser$coretypes$BasicStrokeReadHandler : (class$org$jfree$xml$parser$coretypes$BasicStrokeReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.BasicStrokeReadHandler")));
        this.addManualMapping(class$java$awt$Font != null ? class$java$awt$Font : (class$java$awt$Font = RootXmlReadHandler.class$("java.awt.Font")), class$org$jfree$xml$parser$coretypes$FontReadHandler != null ? class$org$jfree$xml$parser$coretypes$FontReadHandler : (class$org$jfree$xml$parser$coretypes$FontReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.FontReadHandler")));
        this.addManualMapping(class$java$awt$Insets != null ? class$java$awt$Insets : (class$java$awt$Insets = RootXmlReadHandler.class$("java.awt.Insets")), class$org$jfree$xml$parser$coretypes$InsetsReadHandler != null ? class$org$jfree$xml$parser$coretypes$InsetsReadHandler : (class$org$jfree$xml$parser$coretypes$InsetsReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.InsetsReadHandler")));
        this.addManualMapping(class$java$awt$RenderingHints != null ? class$java$awt$RenderingHints : (class$java$awt$RenderingHints = RootXmlReadHandler.class$("java.awt.RenderingHints")), class$org$jfree$xml$parser$coretypes$RenderingHintsReadHandler != null ? class$org$jfree$xml$parser$coretypes$RenderingHintsReadHandler : (class$org$jfree$xml$parser$coretypes$RenderingHintsReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.RenderingHintsReadHandler")));
        this.addManualMapping(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RootXmlReadHandler.class$("java.lang.String")), class$org$jfree$xml$parser$coretypes$StringReadHandler != null ? class$org$jfree$xml$parser$coretypes$StringReadHandler : (class$org$jfree$xml$parser$coretypes$StringReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.coretypes.StringReadHandler")));
    }

    protected void addManualMapping(Class classToRead, Class handler) {
        if (handler == null) {
            throw new NullPointerException("handler must not be null.");
        }
        if (classToRead == null) {
            throw new NullPointerException("classToRead must not be null.");
        }
        if (!(class$org$jfree$xml$parser$XmlReadHandler != null ? class$org$jfree$xml$parser$XmlReadHandler : (class$org$jfree$xml$parser$XmlReadHandler = RootXmlReadHandler.class$("org.jfree.xml.parser.XmlReadHandler"))).isAssignableFrom(handler)) {
            throw new IllegalArgumentException("The given handler is no XmlReadHandler.");
        }
        this.classToHandlerMapping.addManualMapping(new ManualMappingDefinition(classToRead, handler.getName(), null));
    }

    protected void addMultiplexMapping(Class baseClass, String typeAttr, MultiplexMappingEntry[] mdef) {
        this.classToHandlerMapping.addMultiplexMapping(new MultiplexMappingDefinition(baseClass, typeAttr, mdef));
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.getCurrentHandler().characters(ch, start, length);
        }
        catch (SAXException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ParseException(e, this.getLocator());
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public XmlReadHandler createHandler(Class classToRead, String tagName, Attributes atts) throws XmlReaderException {
        XmlReadHandler retval = this.findHandlerForClass(classToRead, atts, new ArrayList());
        if (retval == null) {
            throw new NullPointerException("Unable to find handler for class: " + classToRead);
        }
        retval.init(this, tagName);
        return retval;
    }

    public void delegate(XmlReadHandler handler, String tagName, Attributes attrs) throws XmlReaderException, SAXException {
        this.currentHandlers.push(handler);
        handler.init(this, tagName);
        handler.startElement(tagName, attrs);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.getCurrentHandler().endElement(qName);
        }
        catch (XmlReaderException xre) {
            throw new ParseException((Exception)((Object)xre), this.getLocator());
        }
    }

    private XmlReadHandler findHandlerForClass(Class classToRead, Attributes atts, ArrayList history) throws XmlReaderException {
        ObjectFactory genericFactory = this.getFactoryLoader();
        if (history.contains(classToRead)) {
            throw new IllegalStateException("Circular reference detected: " + history);
        }
        history.add(classToRead);
        ManualMappingDefinition manualDefinition = this.classToHandlerMapping.getManualMappingDefinition(classToRead);
        if (manualDefinition == null) {
            manualDefinition = genericFactory.getManualMappingDefinition(classToRead);
        }
        if (manualDefinition != null) {
            return this.loadHandlerClass(manualDefinition.getReadHandler());
        }
        MultiplexMappingDefinition mplex = this.getFactoryLoader().getMultiplexDefinition(classToRead);
        if (mplex == null) {
            mplex = this.classToHandlerMapping.getMultiplexDefinition(classToRead);
        }
        if (mplex != null) {
            String attributeValue = atts.getValue(mplex.getAttributeName());
            if (attributeValue == null) {
                throw new XmlReaderException("Multiplexer type attribute is not defined: " + mplex.getAttributeName() + " for " + classToRead);
            }
            MultiplexMappingEntry entry = mplex.getEntryForType(attributeValue);
            if (entry == null) {
                throw new XmlReaderException("Invalid type attribute value: " + mplex.getAttributeName() + " = " + attributeValue);
            }
            Class c = this.loadClass(entry.getTargetClass());
            if (!c.equals(mplex.getBaseClass())) {
                return this.findHandlerForClass(c, atts, history);
            }
        }
        if (this.classToHandlerMapping.isGenericHandler(classToRead)) {
            return new GenericReadHandler(this.classToHandlerMapping.getFactoryForClass(classToRead));
        }
        if (this.getFactoryLoader().isGenericHandler(classToRead)) {
            return new GenericReadHandler(this.getFactoryLoader().getFactoryForClass(classToRead));
        }
        return null;
    }

    protected XmlReadHandler getCurrentHandler() {
        return (XmlReadHandler)this.currentHandlers.peek();
    }

    public abstract ObjectFactory getFactoryLoader();

    public Object getHelperObject(String key) {
        return this.objectRegistry.get(key);
    }

    public Object getResult() throws SAXException {
        if (this.rootHandler != null) {
            try {
                return this.rootHandler.getObject();
            }
            catch (XmlReaderException e) {
                throw new ElementDefinitionException((Exception)((Object)e));
            }
        }
        return null;
    }

    protected XmlReadHandler getRootHandler() {
        return this.rootHandler;
    }

    protected Class loadClass(String className) throws XmlReaderException {
        if (className == null) {
            throw new XmlReaderException("LoadHanderClass: Class name not defined");
        }
        try {
            Class<?> c = ObjectUtilities.getClassLoader(this.getClass()).loadClass(className);
            return c;
        }
        catch (Exception e) {
            throw new XmlReaderException("LoadHanderClass: Unable to load " + className, e);
        }
    }

    protected XmlReadHandler loadHandlerClass(String className) throws XmlReaderException {
        try {
            Class c = this.loadClass(className);
            return (XmlReadHandler)c.newInstance();
        }
        catch (Exception e) {
            throw new XmlReaderException("LoadHanderClass: Unable to instantiate " + className, e);
        }
    }

    public void recurse(XmlReadHandler handler, String tagName, Attributes attrs) throws XmlReaderException, SAXException {
        this.outerScopes.push(this.currentHandlers);
        this.currentHandlers = new Stack();
        this.currentHandlers.push(handler);
        handler.startElement(tagName, attrs);
    }

    public void setHelperObject(String key, Object value) {
        if (value == null) {
            this.objectRegistry.remove(key);
        } else {
            this.objectRegistry.put(key, value);
        }
    }

    protected void setRootHandler(XmlReadHandler handler) {
        this.rootHandler = handler;
        this.rootHandlerInitialized = false;
    }

    public void startDocument() throws SAXException {
        this.outerScopes = new Stack();
        this.currentHandlers = new Stack();
        this.currentHandlers.push(this.rootHandler);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.rootHandlerInitialized) {
            this.rootHandler.init(this, qName);
            this.rootHandlerInitialized = true;
        }
        try {
            this.getCurrentHandler().startElement(qName, attributes);
        }
        catch (XmlReaderException xre) {
            throw new ParseException((Exception)((Object)xre), this.getLocator());
        }
    }

    public void unwind(String tagName) throws SAXException, XmlReaderException {
        this.currentHandlers.pop();
        if (this.currentHandlers.isEmpty() && !this.outerScopes.isEmpty()) {
            this.currentHandlers = (Stack)this.outerScopes.pop();
        } else if (!this.currentHandlers.isEmpty()) {
            this.getCurrentHandler().endElement(tagName);
        }
    }
}

