/***************************************************************************
                          csearchsocket.cpp  -  description
                             -------------------
    begin                : Thu May 27 2004
    copyright            : (C) 2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include <dclib/dcos.h>
#include <dclib/dclib.h>
#include <dclib/core/cstring.h>
#include <dclib/cmessagehandler.h>

#include "csearchsocket.h"

/** */
CSearchSocket::CSearchSocket()
{
	m_pCallback = 0;
}

/** */
CSearchSocket::~CSearchSocket()
{
	SetCallBackFunction(0);
}

/** */
int CSearchSocket::HandleMessage( char * c, int )
{
	int p=0;
	eDCMessage type;
	CObject * Object;
	CMessageHandler MessageHandler;
	CString s;
	int err;
	s = c;

	while( (type=MessageHandler.Parse(&s,p,Object=0)) != DC_MESSAGE_PARSE_ERROR )
	{
		switch (type)
		{
			case DC_MESSAGE_SEARCHRESULT:
			{
				break;
			}

			default:
			{
				// remove message
				delete Object;
				Object = 0;
				break;
			}
		}

		if (Object)
		{
			err = -1;

			((CDCMessage*)Object)->m_eType = type;

			if ( m_pCallback != 0 )
			{
				err = m_pCallback->notify( this, Object );
			}

			if ( err == -1 )
			{
				printf("CallBack failed (state)...\n");
				delete Object;
			}
		}
	}

	return 0;
}

/** */
void CSearchSocket::DataAvailable( const char * buffer, int len )
{
	CString m_sBuffer;
	
	m_sBuffer = buffer;

	// add traffic control
	CSocket::m_Traffic.AddTraffic(ettCONTROLRX,len);

	// add '|' for parser
	m_sBuffer += '|';

	HandleMessage( (char*)m_sBuffer.Data(), m_sBuffer.Length() );
}

/** */
void CSearchSocket::ConnectionState( eConnectionState state )
{
	int err = -1;

	CMessageConnectionState *Object;

	Object = new CMessageConnectionState();

	Object->m_eState   = state;
	Object->m_sMessage = GetSocketError();

	if ( m_pCallback != 0 )
	{
		err = m_pCallback->notify( this, Object );
	}

	if ( err == -1 )
	{
		printf("CallBack failed (state)...\n");
		delete Object;
	}
}
