#include "bdb.h"

static void 
bdb_txn_free(txnst)
    bdb_TXN *txnst;
{
    if (txnst->txnid && txnst->parent == NULL) {
        bdb_test_error(txn_abort(txnst->txnid));
        txnst->txnid = NULL;
    }
    free(txnst);
}

static void 
bdb_txn_mark(txnst)
    bdb_TXN *txnst;
{
    if (txnst->marshal) rb_gc_mark(txnst->marshal);
    rb_gc_mark(txnst->db_ary);
}

#define GetTxnDB(obj, txnst)				\
{							\
    Data_Get_Struct(obj, bdb_TXN, txnst);		\
    if (txnst->txnid == 0)				\
        rb_raise(bdb_eFatal, "closed transaction");	\
}

static VALUE
bdb_txn_assoc(argc, argv, obj)
    int argc;
    VALUE *argv;
    VALUE obj;
{
    int i;
    VALUE ary, a;
    bdb_TXN *txnst;
    bdb_DB *dbp, *dbh;

    ary = rb_ary_new();
    GetTxnDB(obj, txnst);
    for (i = 0; i < argc; i++) {
        if (!rb_obj_is_kind_of(argv[i], bdb_cCommon))
            rb_raise(bdb_eFatal, "argument must be a database handle");
        a = Data_Make_Struct(CLASS_OF(argv[i]), bdb_DB, bdb_mark, bdb_free, dbh);
        GetDB(argv[i], dbp);
        MEMCPY(dbh, dbp, bdb_DB, 1);
        dbh->txn = txnst;
	dbh->orig = argv[i];
	dbh->options |= BDB_TXN;
	dbh->flags27 = txnst->flags27;
        rb_ary_push(ary, a);
    }
    switch (RARRAY(ary)->len) {
    case 0: return Qnil;
    case 1: return RARRAY(ary)->ptr[0];
    default: return ary;
    }
}

static VALUE
bdb_txn_commit(argc, argv, obj)
    int argc;
    VALUE *argv;
    VALUE obj;
{
    bdb_TXN *txnst;
    VALUE a, db;
    int flags;
    bdb_DB *dbst, *dbst1;

    rb_secure(4);
    flags = 0;
    if (rb_scan_args(argc, argv, "01", &a) == 1) {
        flags = NUM2INT(a);
    }
    GetTxnDB(obj, txnst);
#if DB_VERSION_MAJOR < 3
    bdb_test_error(txn_commit(txnst->txnid));
#else
#if DB_VERSION_MAJOR >= 4
    bdb_test_error(txnst->txnid->commit(txnst->txnid, flags));
#else
    bdb_test_error(txn_commit(txnst->txnid, flags));
#endif
#endif
    while ((db = rb_ary_pop(txnst->db_ary)) != Qnil) {
	if (TYPE(db) == T_DATA) {
	    Data_Get_Struct(db, bdb_DB, dbst);
	    Data_Get_Struct(dbst->orig, bdb_DB, dbst1);
	    dbst1->len = dbst->len;
	    bdb_close(0, 0, db);
	}
    }
    txnst->txnid = NULL;
    if (txnst->status == 1) {
	txnst->status = 0;
	rb_throw("__bdb__begin", Data_Wrap_Struct(bdb_cTxnCatch, 0, 0, txnst));
    }
    return Qtrue;
}

static VALUE
bdb_txn_abort(obj)
    VALUE obj;
{
    bdb_TXN *txnst;
    VALUE db;

    GetTxnDB(obj, txnst);
#if DB_VERSION_MAJOR >= 4
    bdb_test_error(txnst->txnid->abort(txnst->txnid));
#else
    bdb_test_error(txn_abort(txnst->txnid));
#endif
    while ((db = rb_ary_pop(txnst->db_ary)) != Qnil) {
	if (TYPE(db) == T_DATA) {
	    bdb_close(0, 0, db);
	}
    }
    txnst->txnid = NULL;
    if (txnst->status == 1) {
	txnst->status = 0;
	rb_throw("__bdb__begin", Data_Wrap_Struct(bdb_cTxnCatch, 0, 0, txnst));
    }
    return Qtrue;
}

static VALUE
bdb_catch(val, args, self)
    VALUE val, args, self;
{
    rb_yield(args);
    return Qtrue;
}

struct dbtxnopt {
    int flags;
    VALUE timeout, txn_timeout, lock_timeout;
};

static VALUE
bdb_txn_i_options(obj, dbstobj)
    VALUE obj, dbstobj;
{
    struct dbtxnopt *opt = (struct dbtxnopt *)dbstobj;
    VALUE key, value;
    char *options;

    key = rb_ary_entry(obj, 0);
    value = rb_ary_entry(obj, 1);
    key = rb_obj_as_string(key);
    options = RSTRING(key)->ptr;
    if (strcmp(options, "flags") == 0) {
	opt->flags = NUM2INT(value);
    }
#if DB_VERSION_MAJOR >= 4
    else if (strcmp(options, "timeout") == 0) {
	opt->timeout = value;
    }
    else if (strcmp(options, "txn_timeout") == 0) {
	opt->txn_timeout = value;
    }
    else if (strcmp(options, "lock_timeout") == 0) {
	opt->lock_timeout = value;
    }
#endif
    return Qnil;
}
	
#if DB_VERSION_MAJOR >= 4
static VALUE bdb_txn_set_timeout _((VALUE, VALUE));
static VALUE bdb_txn_set_txn_timeout _((VALUE, VALUE));
static VALUE bdb_txn_set_lock_timeout _((VALUE, VALUE));
#endif

static VALUE
bdb_env_begin(argc, argv, obj)
    int argc;
    VALUE *argv;
    VALUE obj;
{
    bdb_TXN *txnst, *txnstpar;
    DB_TXN *txn, *txnpar;
    DB_ENV *dbenvp;
    bdb_ENV *dbenvst;
    VALUE txnv, b, env;
    int flags, commit;
    VALUE marshal, options;
    struct dbtxnopt opt;

    txnpar = 0;
    flags = commit = 0;
    dbenvst = 0;
    env = 0;
    options = Qnil;
    if (argc > 0 && TYPE(argv[argc - 1]) == T_HASH) {
	options = argv[argc - 1];
	argc--;
	opt.flags = 0;
	opt.timeout = opt.txn_timeout = opt.lock_timeout = Qnil;
	rb_iterate(rb_each, options, bdb_txn_i_options, (VALUE)&opt);
	flags = opt.flags;
	if (flags & BDB_TXN_COMMIT) {
	    commit = 1;
	    flags &= ~BDB_TXN_COMMIT;
	}
    }
    if (argc >= 1 && !rb_obj_is_kind_of(argv[0], bdb_cCommon)) {
        flags = NUM2INT(argv[0]);
	if (flags & BDB_TXN_COMMIT) {
	    commit = 1;
	    flags &= ~BDB_TXN_COMMIT;
	}
        argc--; argv++;
    }
    if (rb_obj_is_kind_of(obj, bdb_cTxn)) {
        GetTxnDB(obj, txnstpar);
        txnpar = txnstpar->txnid;
	env = txnstpar->env;
	GetEnvDB(env, dbenvst);
	dbenvp = dbenvst->dbenvp;
	marshal = txnstpar->marshal;
    }
    else {
        GetEnvDB(obj, dbenvst);
	env = obj;
        dbenvp = dbenvst->dbenvp;
	marshal = dbenvst->marshal;
    }
#if DB_VERSION_MAJOR < 3
    if (dbenvp->tx_info == NULL) {
	rb_raise(bdb_eFatal, "Transaction Manager not enabled");
    }
    bdb_test_error(txn_begin(dbenvp->tx_info, txnpar, &txn));
#else
#if DB_VERSION_MAJOR >= 4
    bdb_test_error(dbenvp->txn_begin(dbenvp, txnpar, &txn, flags));
#else
    bdb_test_error(txn_begin(dbenvp, txnpar, &txn, flags));
#endif
#endif
    txnv = Data_Make_Struct(bdb_cTxn, bdb_TXN, bdb_txn_mark, bdb_txn_free, txnst);
    txnst->env = env;
    txnst->marshal = marshal;
    txnst->txnid = txn;
    txnst->parent = txnpar;
    txnst->status = 0;
    txnst->flags27 = dbenvst->flags27;
    txnst->db_ary = rb_ary_new2(0);
    b = bdb_txn_assoc(argc, argv, txnv);
#if DB_VERSION_MAJOR >= 4
    if (!NIL_P(options)) {
	bdb_txn_set_timeout(txnv, opt.timeout);
	bdb_txn_set_txn_timeout(txnv, opt.txn_timeout);
	bdb_txn_set_lock_timeout(txnv, opt.lock_timeout);
    }
#endif
    if (rb_block_given_p()) {
	VALUE result;
	txnst->status = 1;
	result = rb_catch("__bdb__begin", bdb_catch, (b == Qnil)?txnv:rb_assoc_new(txnv, b));
	if (rb_obj_is_kind_of(result, bdb_cTxnCatch)) {
	    bdb_TXN *txn1;
	    Data_Get_Struct(result, bdb_TXN, txn1);
	    if (txn1 == txnst)
		return Qnil;
	    else
		rb_throw("__bdb__begin", result);
	}
	txnst->status = 0;
	if (txnst->txnid) {
	    if (commit)
		bdb_txn_commit(0, 0, txnv);
	    else
		bdb_txn_abort(txnv);
	}
	return Qnil;
    }
    if (b == Qnil)
        return txnv;
    else
        return rb_assoc_new(txnv, b);
}

static VALUE
bdb_txn_id(obj)
    VALUE obj;
{
    bdb_TXN *txnst;
    int res;

    GetTxnDB(obj, txnst);
#if DB_VERSION_MAJOR >= 4
    res = txnst->txnid->id(txnst->txnid);
#else
    res = txn_id(txnst->txnid);
#endif
    return INT2FIX(res);
}

static VALUE
#if (DB_VERSION_MAJOR == 3 && DB_VERSION_MINOR >= 3) || DB_VERSION_MAJOR >= 4
bdb_txn_prepare(obj, txnid)
    VALUE obj, txnid;
#else
bdb_txn_prepare(obj)
    VALUE obj;
#endif
{
    bdb_TXN *txnst;
    unsigned char id;

    GetTxnDB(obj, txnst);
#if DB_VERSION_MAJOR >= 4
    id = (unsigned char)NUM2INT(txnid);
    bdb_test_error(txnst->txnid->prepare(txnst->txnid, &id));
#else
#if DB_VERSION_MAJOR == 3 && DB_VERSION_MINOR >= 3
    id = (unsigned char)NUM2INT(txnid);
    bdb_test_error(txn_prepare(txnst->txnid, &id));
#else
    bdb_test_error(txn_prepare(txnst->txnid));
#endif
#endif
    return Qtrue;
}

static VALUE
bdb_env_check(argc, argv, obj)
    int argc;
    VALUE *argv;
    VALUE obj;
{
    unsigned int kbyte, min, flag;
    bdb_ENV *dbenvst;
    VALUE a, b, c;

    kbyte = min = flag = 0;
    a = b = Qnil;
#if DB_VERSION_MAJOR >= 4
    switch (rb_scan_args(argc, argv, "03", &a, &b, &c)) {
    case 3:
	flag = NUM2INT(c);
    case 2:
	min = NUM2UINT(b);
    }
#else
    if (rb_scan_args(argc, argv, "02", &a, &b) == 2) {
	min = NUM2UINT(b);
    }
#endif
    if (!NIL_P(a))
	kbyte = NUM2UINT(a);
    GetEnvDB(obj, dbenvst);
#if DB_VERSION_MAJOR < 3
    if (dbenvst->dbenvp->tx_info == NULL) {
	rb_raise(bdb_eFatal, "Transaction Manager not enabled");
    }
    bdb_test_error(txn_checkpoint(dbenvst->dbenvp->tx_info, kbyte, min));
#else
#if DB_VERSION_MAJOR >= 4
    bdb_test_error(dbenvst->dbenvp->txn_checkpoint(dbenvst->dbenvp, kbyte, min, flag));
#else
#if DB_VERSION_MINOR >= 1
    bdb_test_error(txn_checkpoint(dbenvst->dbenvp, kbyte, min, flag));
#else
    bdb_test_error(txn_checkpoint(dbenvst->dbenvp, kbyte, min));
#endif
#endif
#endif
    return Qnil;
}

#if (DB_VERSION_MAJOR >= 3 && DB_VERSION_MINOR >= 3) || DB_VERSION_MAJOR >= 4

static VALUE
bdb_env_recover(obj)
    VALUE obj;
{
    unsigned int flags;
    long count, retp;
    unsigned char id;
    DB_PREPLIST preplist[1];
    bdb_ENV *dbenvst;
    DB_TXN *txn;
    bdb_TXN *txnst;
    VALUE txnv;

    if (!rb_block_given_p()) {
        rb_raise(bdb_eFatal, "call out of an iterator");
    }
    rb_secure(4);
    GetEnvDB(obj, dbenvst);
    txnv = Data_Make_Struct(bdb_cTxn, bdb_TXN, bdb_txn_mark, bdb_txn_free, txnst);
    txnst->env = obj;
    txnst->marshal = dbenvst->marshal;
    txnst->flags27 = dbenvst->flags27;
    txnst->db_ary = rb_ary_new2(0);
    flags = DB_FIRST;
    while (1) {
#if DB_VERSION_MAJOR >=4
	bdb_test_error(dbenvst->dbenvp->txn_recover(dbenvst->dbenvp, preplist, 1, &retp, flags));
#else
	bdb_test_error(txn_recover(dbenvst->dbenvp, preplist, 1, &retp, flags));
#endif
	if (retp == 0) break;
	txnst->txnid = preplist[0].txn;
	id = (unsigned char)preplist[0].gid[0];
	rb_yield(rb_assoc_new(txnv, INT2NUM(id)));
	flags = DB_NEXT;
    }
    return obj;
}

static VALUE
bdb_txn_discard(obj)
    VALUE obj;
{
    bdb_TXN *txnst;
    int flags;

    rb_secure(4);
    flags = 0;
    GetTxnDB(obj, txnst);
#if DB_VERSION_MAJOR >=4
    bdb_test_error(txnst->txnid->discard(txnst->txnid, flags));
#else
    bdb_test_error(txn_discard(txnst->txnid, flags));
#endif
    txnst->txnid = NULL;
    return Qtrue;
}

#endif

static VALUE
bdb_env_stat(argc, argv, obj)
    int argc;
    VALUE obj, *argv;
{
    bdb_ENV *dbenvst;
    VALUE a, b;
    DB_TXN_STAT *bdb_stat;
    int flags;

#if DB_VERSION_MAJOR >= 4
    flags = 0;
    if (rb_scan_args(argc, argv, "01", &b) == 1) {
	flags = NUM2INT(b);
    }
#else
    if (argc != 0) {
	rb_raise(rb_eArgError, "invalid number of arguments (%d for 0)", argc);
    }
#endif
    GetEnvDB(obj, dbenvst);
#if DB_VERSION_MAJOR < 3
    if (dbenvst->dbenvp->tx_info == NULL) {
	rb_raise(bdb_eFatal, "Transaction Manager not enabled");
    }
    bdb_test_error(txn_stat(dbenvst->dbenvp->tx_info, &bdb_stat, malloc));
#else
#if DB_VERSION_MAJOR >= 4
    bdb_test_error(dbenvst->dbenvp->txn_stat(dbenvst->dbenvp, &bdb_stat, flags));
#else
#if DB_VERSION_MINOR < 3
    bdb_test_error(txn_stat(dbenvst->dbenvp, &bdb_stat, malloc));
#else
    bdb_test_error(txn_stat(dbenvst->dbenvp, &bdb_stat));
#endif
#endif
#endif
    a = rb_hash_new();
    rb_hash_aset(a, rb_tainted_str_new2("st_time_ckp"), INT2NUM(bdb_stat->st_time_ckp));
    rb_hash_aset(a, rb_tainted_str_new2("st_last_txnid"), INT2NUM(bdb_stat->st_last_txnid));
    rb_hash_aset(a, rb_tainted_str_new2("st_maxtxns"), INT2NUM(bdb_stat->st_maxtxns));
    rb_hash_aset(a, rb_tainted_str_new2("st_naborts"), INT2NUM(bdb_stat->st_naborts));
    rb_hash_aset(a, rb_tainted_str_new2("st_nbegins"), INT2NUM(bdb_stat->st_nbegins));
    rb_hash_aset(a, rb_tainted_str_new2("st_ncommits"), INT2NUM(bdb_stat->st_ncommits));
    rb_hash_aset(a, rb_tainted_str_new2("st_nactive"), INT2NUM(bdb_stat->st_nactive));
#if DB_VERSION_MAJOR > 2 
    rb_hash_aset(a, rb_tainted_str_new2("st_maxnactive"), INT2NUM(bdb_stat->st_maxnactive));
    rb_hash_aset(a, rb_tainted_str_new2("st_regsize"), INT2NUM(bdb_stat->st_regsize));
    rb_hash_aset(a, rb_tainted_str_new2("st_region_wait"), INT2NUM(bdb_stat->st_region_wait));
    rb_hash_aset(a, rb_tainted_str_new2("st_region_nowait"), INT2NUM(bdb_stat->st_region_nowait));
#endif
#if DB_VERSION_MAJOR >= 4
    {
	struct dblsnst *lsnst;
	VALUE obj, ary, hash, lsn;
	int i;

	rb_hash_aset(a, rb_tainted_str_new2("st_nrestores"), INT2NUM(bdb_stat->st_nrestores));
	lsn = MakeLsn(obj);
	Data_Get_Struct(lsn, struct dblsnst, lsnst);
	MEMCPY(lsnst->lsn, &bdb_stat->st_last_ckp, DB_LSN, 1);
	rb_hash_aset(a, rb_tainted_str_new2("st_last_ckp"), lsn);
	lsn = MakeLsn(obj);
	Data_Get_Struct(lsn, struct dblsnst, lsnst);
	MEMCPY(lsnst->lsn, &bdb_stat->st_pending_ckp, DB_LSN, 1);
	rb_hash_aset(a, rb_tainted_str_new2("st_pending_ckp"), lsn);
	ary = rb_ary_new2(bdb_stat->st_nactive);
	for (i = 0; i < bdb_stat->st_nactive; i++) {
	    hash = rb_hash_new();
	    rb_hash_aset(hash, rb_tainted_str_new2("txnid"), INT2NUM(bdb_stat->st_txnarray[i].txnid));
	    rb_hash_aset(hash, rb_tainted_str_new2("parentid"), INT2NUM(bdb_stat->st_txnarray[i].parentid));
	    lsn = MakeLsn(obj);
	    Data_Get_Struct(lsn, struct dblsnst, lsnst);
	    MEMCPY(lsnst->lsn, &bdb_stat->st_txnarray[i].lsn, DB_LSN, 1);
	    rb_hash_aset(hash, rb_tainted_str_new2("lsn"), lsn);
	    rb_ary_push(ary, hash);
	}
    }
#endif
    free(bdb_stat);
    return a;
}

#if DB_VERSION_MAJOR >= 4

static VALUE
bdb_txn_set_txn_timeout(obj, a)
    VALUE obj, a;
{
    bdb_TXN *txnst;
    bdb_ENV dbenvst;

    if (!NIL_P(a)) {
	GetTxnDB(obj, txnst);
	bdb_test_error(txnst->txnid->set_timeout(txnst->txnid, NUM2UINT(a), DB_SET_TXN_TIMEOUT));
    }
    return obj;
}

static VALUE
bdb_txn_set_lock_timeout(obj, a)
    VALUE obj, a;
{
    bdb_TXN *txnst;
    bdb_ENV dbenvst;

    if (!NIL_P(a)) {
	GetTxnDB(obj, txnst);
	bdb_test_error(txnst->txnid->set_timeout(txnst->txnid, NUM2UINT(a), DB_SET_LOCK_TIMEOUT));
    }
    return obj;
}

static VALUE
bdb_txn_set_timeout(obj, a)
    VALUE obj, a;
{
    if (!NIL_P(a)) {
	if (TYPE(a) == T_ARRAY) {
	    if (RARRAY(a)->len >= 1 && !NIL_P(RARRAY(a)->ptr[0])) {
		bdb_txn_set_txn_timeout(obj, RARRAY(a)->ptr[0]);
	    }
	    if (RARRAY(a)->len == 2 && !NIL_P(RARRAY(a)->ptr[1])) {
		bdb_txn_set_lock_timeout(obj, RARRAY(a)->ptr[0]);
	    }
	}
	else {
	    bdb_txn_set_txn_timeout(obj, a);
	}
    }
    return obj;
} 

#endif


void bdb_init_transaction()
{
    bdb_cTxn = rb_define_class_under(bdb_mDb, "Txn", rb_cObject);
    bdb_cTxnCatch = rb_define_class("DBTxnCatch", bdb_cTxn);
    rb_undef_method(CLASS_OF(bdb_cTxn), "new");
    rb_define_method(bdb_cEnv, "begin", bdb_env_begin, -1);
    rb_define_method(bdb_cEnv, "txn_begin", bdb_env_begin, -1);
    rb_define_method(bdb_cEnv, "transaction", bdb_env_begin, -1);
    rb_define_method(bdb_cEnv, "stat", bdb_env_stat, 0);
    rb_define_method(bdb_cEnv, "txn_stat", bdb_env_stat, 0);
    rb_define_method(bdb_cEnv, "checkpoint", bdb_env_check, -1);
    rb_define_method(bdb_cEnv, "txn_checkpoint", bdb_env_check, -1);
#if (DB_VERSION_MAJOR == 3 && DB_VERSION_MINOR >= 3) || DB_VERSION_MAJOR >= 4
    rb_define_method(bdb_cEnv, "txn_recover", bdb_env_recover, 0);
    rb_define_method(bdb_cEnv, "recover", bdb_env_recover, 0);
#endif
    rb_define_method(bdb_cTxn, "begin", bdb_env_begin, -1);
    rb_define_method(bdb_cTxn, "txn_begin", bdb_env_begin, -1);
    rb_define_method(bdb_cTxn, "transaction", bdb_env_begin, -1);
    rb_define_method(bdb_cTxn, "commit", bdb_txn_commit, -1);
    rb_define_method(bdb_cTxn, "txn_commit", bdb_txn_commit, -1);
    rb_define_method(bdb_cTxn, "close", bdb_txn_commit, -1);
    rb_define_method(bdb_cTxn, "txn_close", bdb_txn_commit, -1);
    rb_define_method(bdb_cTxn, "abort", bdb_txn_abort, 0);
    rb_define_method(bdb_cTxn, "txn_abort", bdb_txn_abort, 0);
    rb_define_method(bdb_cTxn, "id", bdb_txn_id, 0);
    rb_define_method(bdb_cTxn, "txn_id", bdb_txn_id, 0);
#if (DB_VERSION_MAJOR == 3 && DB_VERSION_MINOR >= 3) || DB_VERSION_MAJOR >= 4
    rb_define_method(bdb_cTxn, "discard", bdb_txn_discard, 0);
    rb_define_method(bdb_cTxn, "txn_discard", bdb_txn_discard, 0);
    rb_define_method(bdb_cTxn, "prepare", bdb_txn_prepare, 1);
    rb_define_method(bdb_cTxn, "txn_prepare", bdb_txn_prepare, 1);
#else
    rb_define_method(bdb_cTxn, "prepare", bdb_txn_prepare, 0);
    rb_define_method(bdb_cTxn, "txn_prepare", bdb_txn_prepare, 0);
#endif
    rb_define_method(bdb_cTxn, "assoc", bdb_txn_assoc, -1);
    rb_define_method(bdb_cTxn, "txn_assoc", bdb_txn_assoc, -1);
    rb_define_method(bdb_cTxn, "associate", bdb_txn_assoc, -1);
    rb_define_method(bdb_cTxn, "open_db", bdb_env_open_db, -1);
#if DB_VERSION_MAJOR >= 4
    rb_define_method(bdb_cTxn, "set_timeout", bdb_txn_set_timeout, 1);
    rb_define_method(bdb_cTxn, "set_txn_timeout", bdb_txn_set_txn_timeout, 1);
    rb_define_method(bdb_cTxn, "set_lock_timeout", bdb_txn_set_lock_timeout, 1);
#endif    
}
