/* 
 * $Id: ctkentry.c,v 1.25 2000/07/25 05:50:00 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"
#include "ctkcolor.h"
#include "ctkutil.h"
#include "ctkentry.h"

gpointer ctk_entry_destroy(CtkObject *object);

/* Initialize the Entry Widget */
void ctk_entry_init(CtkEntry* entry)
{
	ctk_editable_init(&entry->editable);

	((CtkObject *)entry)->type = CtkTypeEntry;
	((CtkWidget *)entry)->width = 15;
	((CtkWidget *)entry)->orig_width = 15;
	((CtkWidget *)entry)->height = 1;
	((CtkWidget *)entry)->orig_height = 1;
	((CtkWidget *)entry)->main_col = ctk_calculate_palette(CTK_COLOR_WHITE,CTK_COLOR_BLACK);
	((CtkWidget *)entry)->insensitive_col = ctk_calculate_palette(CTK_COLOR_GRAY,CTK_COLOR_CYAN);
	((CtkObject *)entry)->destroy_func = ctk_entry_destroy;
}

/* Create a Entry Widget */
CtkWidget* ctk_entry_new()
{
	CtkEntry *entry;
	
	entry = g_malloc(sizeof(CtkEntry));
	
	ctk_entry_init(entry);

	return ((CtkWidget *)entry);
}

/* Set Text */
void ctk_entry_set_text(CtkEntry* entry, const gchar* text)
{
	CtkWidget*   widget;
	CtkEditable* editable;

	if (!entry)
	    return;

	if (!text)
	    return;

	editable = CTK_EDITABLE(entry);

	if (editable->text)
	    free(editable->text);

	editable->text = g_strdup(text);
	editable->text_start = editable->text;
	editable->curpos = 0;

	widget = CTK_WIDGET(editable);
	
	ctk_signal_emit_by_name(CTK_OBJECT(widget), "changed");

	ctk_size_mark_changed(widget);
}

/* Get Text */
gchar* ctk_entry_get_text(CtkEntry* entry)
{
	if (!entry)
	    return NULL;

	return (((CtkEditable *)entry)->text);
}

/* Set visibility */
void ctk_entry_set_visibility(CtkEntry* entry, gboolean visible)
{
	if (!entry)
	    return;

	entry->editable.visible = visible;
	
	ctk_size_mark_changed(CTK_WIDGET(entry));
}

/* Set Max Length */
void ctk_entry_set_max_length(CtkEntry* entry, guint16 max)
{
	if (!entry)
	    return;

	((CtkEditable *)entry)->max_length = max;
	ctk_size_mark_changed(CTK_WIDGET(entry));
}

/* Destroy Entry Widget */
gpointer ctk_entry_destroy(CtkObject* object)
{
	ctk_editable_destroy(CTK_EDITABLE(object));

	return NULL;
}
