/* 
 * $Id: ctkbox.c,v 1.13 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>

#include "ctk.h"

/* Initialize CtkBox */
void
    ctk_box_init(CtkBox *box, guint rows, guint cols, gboolean homogeneous)
{
	ctk_table_init(&box->table, rows, cols, homogeneous);
	
	box->pack_index = 0;
}

/* Pack Start - Pack objects from the start of the container */
void
    ctk_box_pack_end(CtkBox *box, CtkWidget *child, gboolean expand, gboolean fill, gint padding)
{
	if (!box)
	{
		ctk_close();
		g_error("ctk_box_pack_end: CtkBox *box == NULL!");
	}
	
	box->pack_end(box, child, expand, fill, padding);
}

/* Pack End - Pack objects from the back of the container */
void
    ctk_box_pack_start(CtkBox *box, CtkWidget *child, gboolean expand, gboolean fill, gint padding)
{

	if (!box)
	{
		ctk_close();
		g_error("ctk_box_pack_start: CtkBox *box == NULL!");
	}
	
	box->pack_start(box, child, expand, fill, padding);
}
