/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__DECORATOR_HPP)
#include <Decorator.hpp>
#endif

#if   !defined(__PREBANNER_HPP)
#include <PreBanner.hpp>
#endif

using namespace corelinux;

//
// Default constructor wack
//

PreBanner::PreBanner( void ) throw(Exception)
   :
   BannerComponent(),
   Decorator<BannerComponentPtr>(NULLPTR)
{
   ;  //
}

//
// Constructor with banner and implementation
//

PreBanner::PreBanner( const string &aBanner, BannerComponentPtr aImplementation )
   :
   BannerComponent( aBanner ),
   Decorator<BannerComponentPtr>( aImplementation )
{
   REQUIRE( aImplementation != NULLPTR );
}

//
// Copy constructor
//

PreBanner::PreBanner( PreBannerCref aRef )
   :
   BannerComponent( aRef ),
   Decorator<BannerComponentPtr>( aRef )
{
   ;  // do nothing
}

PreBanner::~PreBanner( void )
{
   ;  // do nothing
}

//
// Assignment operator
//

PreBannerRef   PreBanner::operator=( PreBannerCref aRef )
{
   BannerComponent::operator=(aRef);
   Decorator<BannerComponentPtr>::operator=(aRef);
   return (*this);
}

//
// Equality operator
//

bool  PreBanner::operator==( PreBannerCref aRef ) const
{
   return ( BannerComponent::operator==(aRef) &&
            Decorator<BannerComponentPtr>::operator==(aRef) );
}

//
// Retrieve the entire banner
//

string   PreBanner::getBanner( void ) const
{
   string   aString( BannerComponent::getBanner() );
   aString += getImplementation()->getBanner();
   return aString;
}

//
// Draw the banner with a stream
//

void  PreBanner::drawBanner( ostream &aStream, bool doEndl ) const
{
   aStream << BannerComponent::getBanner();
   if( doEndl == true )
   {
      aStream << endl;
   }
   else
   {
      ;  // do nothing
   }
   getImplementation()->drawBanner(aStream,doEndl);
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/03/18 13:34:29 $
   $Locker:  $
*/

