/*
 * $Id: arr_curses.h,v 1.7 2000/08/23 00:53:02 cbond Exp $
 */

#if !defined(__include_arr_curses_h__)
#define __include_arr_curses_h__

#include <stdarg.h>
#include <stdio.h>
#include <string.h>

#include <arr.h>

/*
 * libarr (n)curses compatibility routines.  Ugh.
 * XXX - incomplete and broken, among other things.
 */

#define COLS	arr_scr_x()
#define LINES	arr_scr_y()

/*
 * Some pseudo-variables ncurses programs use frequently:
 */
#define curscr		!NULL
#define stdscr		!NULL
#define erasechar()	' '
#define killchar()	''

#if !defined(FALSE) || !defined(TRUE)
#undef	FALSE
#undef	TRUE
#define FALSE	0
#define TRUE	!FALSE
#endif

#if !defined(ERR) || !defined(OK)
#undef	ERR
#undef	OK
#define ERR	-1
#define OK	0
#endif

#define __NO_FUNC ((void) 0)

#define getyx(s, y, x)		(y = arr_get_y(), x = arr_get_x())

#define clrtoeol()		arr_nprint_xy(' ', arr_get_x(), arr_get_y(), \
					(arr_scr_x() - arr_get_x()))
#define clrtobot()		arr_nprint_xy(' ', arr_get_x(), arr_get_y(), \
					((arr_scr_x() * arr_scr_y()) - \
					 (arr_get_x() * arr_get_y())))

#define mvaddstr(y, x, s)	do {					\
					arr_goto_xy(x, y);		\
					arr_strprint(s);		\
				} while (0)
#define mvaddch(y, x, ch)	do {					\
					arr_goto_xy(x, y);		\
					arr_print(ch);			\
				} while (0)
#define addch(ch)		(arr_print(ch), 0)
#define addstr(s)		arr_strprint(s)

#define move(y, x)		(arr_goto_xy(x, y), 0)
#define mvcur(or, oc, nr, nc)	arr_set_cursor_pos(nc, nr)
#define inch()			arr_get_chr()

#define standout()		(arr_set_col(FG_BLACK | BG_WHITE), 0)
#define standend()		(arr_set_col(FG_WHITE | BG_BLACK), 0)

#define erase()			do {					\
					arr_nprint_xy(' ', 0, 0,	\
						(arr_scr_x() * 		\
						 arr_scr_y()));		\
					arr_dump_screen();		\
				} while (0)
#define clear()			erase()

#define refresh()		arr_dump_screen()

#define printw			arr_nc_printw
#define mvprintw		arr_nc_printw_xy

#define scrollok(s, tf)		__NO_FUNC
#define idlok(s, tf)		__NO_FUNC
#define lineinput(tf)		__NO_FUNC

#define nl()			__NO_FUNC
#define nonl()			__NO_FUNC
#define noecho()		__NO_FUNC
#define nol()			__NO_FUNC
#define cbreak()		__NO_FUNC
#define nocbreak()		__NO_FUNC

#define getch()			getc(stdin)

#define endwin()		arr_scr_free()
#define initscr()		(arr_scr_init(), arr_buffer_init(' ', \
					(FG_WHITE | BG_BLACK)), !NULL)

/*
 * XXX: Oh my God, XXX!
 * Get the fuck rid of these functions!
 */
#if !defined(__USE_GNU)
extern int vasprintf(char **, char *, va_list);
#endif

static void __arr_nc_printw_xy(char *str, int x, int y, va_list args) {
	char *ptr;

	if (vasprintf(&ptr, str, args) < 0) {
		arr_scr_free();
		perror("Unable to allocate memory chunk");
		exit(1);
	}
	else {
		arr_goto_xy(x, y);
		arr_strprint(ptr);
		va_end(args);
		free(ptr);
	}
}

static void arr_nc_printw(char *str, ...) {
	va_list args;

	va_start(args, str);
	__arr_nc_printw_xy(str, arr_get_x(), arr_get_y(), args);
	va_end(args);
}

static void arr_nc_printw_xy(int y, int x, char *str, ...) {
	va_list args;

	va_start(args, str);
	__arr_nc_printw_xy(str, x, y, args);
	va_end(args);
}

#endif
