#include <qwidget.h>
#include "WrapperFactory.h"

#ifdef HAVE_QSA_FAC
WrapperFactory::WrapperFactory(MainWin *mw, QWorkspace *ws)
	: mw(mw), ws(ws)
{
	registerWrapper( "Point","PointWrapper");
	registerWrapper( "Arrow","ArrowWrapper");
	registerWrapper( "Line","LineWrapper");
	registerWrapper( "Rect","RectWrapper");
	registerWrapper( "Ellipse","EllipseWrapper");
	registerWrapper( "LImage","LImageWrapper");
	registerWrapper( "Symbol","SymbolWrapper");
	registerWrapper( "Style","StyleWrapper");
	registerWrapper( "LRange","LRangeWrapper");
	registerWrapper( "Label","LabelWrapper");
	registerWrapper( "Legend","LegendWrapper");
	registerWrapper( "Axis","AxisWrapper");
	registerWrapper( "Errorbar","ErrorbarWrapper");
	registerWrapper( "Plot2DSimple","Plot2DSimpleWrapper");
	registerWrapper( "Plot2DSurface","Plot2DSurfaceWrapper");
	registerWrapper( "Plot3D","Plot3DWrapper");
	registerWrapper( "PlotQWT3D","PlotQWT3DWrapper");
	registerWrapper( "PlotPie","PlotPieWrapper");
	registerWrapper( "PlotPolar","PlotPolarWrapper");
	registerWrapper( "PlotTernary","PlotTernaryWrapper");

//int a = AttributePublic|AttributeStatic;
//addStaticVariableMember( QString::fromLatin1("LOG10"), createNumber(1), a );
}

QObject *WrapperFactory::create( const QString &className, void *ptr ) {
	kdDebug()<<"WrapperFactory::create()"<<endl;
	if ( className == "Point" )
		return new PointWrapper((Point *) ptr);
	if ( className == "Arrow" )
		return new ArrowWrapper((Arrow *) ptr);
	if ( className == "Line" )
		return new LineWrapper((Line *) ptr);
	if ( className == "Rect" )
		return new RectWrapper((Rect *) ptr);
	if ( className == "Ellipse" )
		return new EllipseWrapper((Ellipse *) ptr);
	if ( className == "LImage" )
		return new LImageWrapper((LImage *) ptr);
	if ( className == "Style" )
		return new StyleWrapper((Style *) ptr);
	if ( className == "Symbol" )
		return new SymbolWrapper((Symbol *) ptr);
	if ( className == "LRange" )
		return new LRangeWrapper((LRange *) ptr);
	if ( className == "Label" )
		return new LabelWrapper((Label *) ptr);
	if ( className == "Legend" )
		return new LegendWrapper((Legend *) ptr);
	if ( className == "Axis" )
		return new AxisWrapper((Axis *) ptr);
	if ( className == "Errorbar" )
		return new ErrorbarWrapper((Errorbar *) ptr);
	if ( className == "Plot2DSimple" )
		return new Plot2DSimpleWrapper((Plot2DSimple *) ptr);
	if ( className == "Plot2DSurface" )
		return new Plot2DSurfaceWrapper((Plot2DSurface *) ptr);
	if ( className == "Plot3D" )
		return new Plot3DWrapper((Plot3D *) ptr);
	if ( className == "PlotQWT3D" )
		return new PlotQWT3DWrapper((PlotQWT3D *) ptr);
	if ( className == "PlotPie" )
		return new PlotPieWrapper((PlotPie *) ptr);
	if ( className == "PlotPolar" )
		return new PlotPolarWrapper((PlotPolar *) ptr);
	if ( className == "PlotTernary" )
		return new PlotTernaryWrapper((PlotTernary *) ptr);

	return 0;
}
#endif
