//LabPlot : SummaryRListDialog.cc

#include "SummaryRListDialog.h"
#include "operations.h"

SummaryRListDialog::SummaryRListDialog(MainWin *m, const char *name)
	: ListDialog(m, name)
{
	kdDebug()<<"SummaryRListDialog()"<<endl;
	setCaption(i18n("Summary R Dialog"));

	KConfig *config = mw->Config();
	config->setGroup( "SummaryR" );

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	// table for results
	stattable = new QTable( 100, 100, tab1 );
	updateResults();
	if(lv != 0) QObject::connect(lv,SIGNAL(selectionChanged()),SLOT(updateResults()));

	// operations on data
	QHBox *hb = new QHBox(tab1);
	new QLabel(i18n("Operation : "),hb);
	opcb = new KComboBox(hb);
	int i=0;
	while(operations_typeitems[i] != 0) opcb->insertItem(i18n(operations_typeitems[i++]));
	opcb->setCurrentItem(config->readNumEntry("Operation",0));

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw,true);
	else
		styletab = simpleStyle(tw, style, symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void SummaryRListDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "SummaryR" );

	config->writeEntry("Operation",opcb->currentItem());
}

// fill table from data
void SummaryRListDialog::fillTable(int row, QString name, double *data, int N) {
	double v;
	RInterface *rif = mw->getRInterface();
	if(rif==0) return;

	// TODO : quantiles

	if(!name.isEmpty())
		stattable->verticalHeader()->setLabel( row, name);

	stattable->horizontalHeader()->setLabel( 0, i18n("Length"));
	stattable->horizontalHeader()->setLabel( 1, i18n("Minimum"));
	stattable->horizontalHeader()->setLabel( 2, i18n("Lower Hinge"));
	stattable->horizontalHeader()->setLabel( 3, i18n("Median"));
	stattable->horizontalHeader()->setLabel( 4, i18n("Upper Hinge"));
	stattable->horizontalHeader()->setLabel( 5, i18n("Maximum"));
	stattable->horizontalHeader()->setLabel( 6, i18n("Sum"));
	stattable->horizontalHeader()->setLabel( 7, i18n("Mean"));
	stattable->horizontalHeader()->setLabel( 8, i18n("0 %"));
	stattable->horizontalHeader()->setLabel( 9, i18n("25 %"));
	stattable->horizontalHeader()->setLabel( 10, i18n("50 %"));
	stattable->horizontalHeader()->setLabel( 11, i18n("75 %"));
	stattable->horizontalHeader()->setLabel( 12, i18n("100 %"));
	stattable->horizontalHeader()->setLabel( 13, i18n("Variance"));
	stattable->horizontalHeader()->setLabel( 14, i18n("Standard Deviation"));
	stattable->horizontalHeader()->setLabel( 15, i18n("MAD"));

	stattable->setNumCols(16);

	v = rif->evalCommand("length",data,N);
	stattable->setText(row,0,QString::number(v));
	v = rif->evalCommand("min",data,N);
	stattable->setText(row,1,QString::number(v));
	v = rif->evalCommandValue("fivenum",data,N,1);
	stattable->setText(row,2,QString::number(v));
	v = rif->evalCommand("median",data,N);
	stattable->setText(row,3,QString::number(v));
	v = rif->evalCommandValue("fivenum",data,N,3);
	stattable->setText(row,4,QString::number(v));
	v = rif->evalCommand("max",data,N);
	stattable->setText(row,5,QString::number(v));
	v = rif->evalCommand("sum",data,N);
	stattable->setText(row,6,QString::number(v));
	v = rif->evalCommand("mean",data,N);
	stattable->setText(row,7,QString::number(v));
	v = rif->evalCommandValue("quantile",data,N,0);
	stattable->setText(row,8,QString::number(v));
	v = rif->evalCommandValue("quantile",data,N,1);
	stattable->setText(row,9,QString::number(v));
	v = rif->evalCommandValue("quantile",data,N,2);
	stattable->setText(row,10,QString::number(v));
	v = rif->evalCommandValue("quantile",data,N,3);
	stattable->setText(row,11,QString::number(v));
	v = rif->evalCommandValue("quantile",data,N,4);
	stattable->setText(row,12,QString::number(v));
	v = rif->evalCommand("var",data,N);
	stattable->setText(row,13,QString::number(v));
	v = rif->evalCommand("sd",data,N);
	stattable->setText(row,14,QString::number(v));
	v = rif->evalCommand("mad",data,N);
	stattable->setText(row,15,QString::number(v));
}

void SummaryRListDialog::updateResults() {
	if(mw->getRInterface() == 0)
		return;

	if(s) {
		mw = s->getMainWin();
		QTable *table = s->Table();

		int N = table->numRows();
		stattable->setNumRows(table->numCols());
		for(int i=0;i<table->numCols();i++) {
			double *data = new double[N];
			for(int j=0;j < N;j++) {
				data[j] = table->text(j,i).toDouble();
			}
			fillTable(i,s->columnTitle(i),data,N);
		}
		return;
	}

	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->Number()==0) {
		KMessageBox::error(this,i18n("No graph found!"));
		return;
	}

	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());
	GRAPHType gtype = gl->getType(item);

	int N=0;
	double *xdata, *ydata, *zdata, *tdata;
	if (gtype == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		N = g->Number();

		xdata = new double[N];
		ydata = new double[N];
		for(int i=0;i<N;i++) {
			xdata[i] = g->Data()[i].X();
			ydata[i] = g->Data()[i].Y();
		}

		stattable->setNumRows(2);
		fillTable(0,"X",xdata,N);
		fillTable(1,"Y",ydata,N);
	}
	else if(gtype == GRAPH3D) {
		Graph3D *g = gl->getGraph3D(item);
		N = g->Number();

		xdata = new double[N];
		ydata = new double[N];
		zdata = new double[N];
		for(int i=0;i<N;i++) {
			xdata[i] = g->Data()[i].X();
			ydata[i] = g->Data()[i].Y();
			zdata[i] = g->Data()[i].Z();
		}

		stattable->setNumRows(3);
		fillTable(0,"X",xdata,N);
		fillTable(1,"Y",ydata,N);
		fillTable(2,"Z",zdata,N);
	}
	else if(gtype == GRAPH4D) {
		Graph4D *g = gl->getGraph4D(item);
		N = g->Number();

		xdata = new double[N];
		ydata = new double[N];
		zdata = new double[N];
		tdata = new double[N];
		for(int i=0;i<N;i++) {
			xdata[i] = g->Data()[i].X();
			ydata[i] = g->Data()[i].Y();
			zdata[i] = g->Data()[i].Z();
			tdata[i] = g->Data()[i].T();
		}

		stattable->setNumRows(4);
		fillTable(0,"X",xdata,N);
		fillTable(1,"Y",ydata,N);
		fillTable(2,"Z",zdata,N);
		fillTable(3,"T",tdata,N);
	}
	else if(gtype == GRAPHM) {
		GraphM *g = gl->getGraphM(item);
		int NX = g->NX();	// cols
		int NY = g->NY();	// rows

		stattable->setNumRows(NX);

		for (int i=0;i<NX;i++) {
			double *data = new double[NY];

			for(int j=0;j<NY;j++)
				data[j] = g->Data()[j+NY*i];
			fillTable(i,"",data,NY);
		}
	}
	else {
		kdDebug()<<"	Sorry. This is not supported."<<endl;
	}
}

int SummaryRListDialog::apply_clicked() {
	kdDebug()<<"SummaryRListDialog::apply_clicked()"<<endl;

	RInterface *rif = mw->getRInterface();
	if(rif==0) return -1;

	if(s) {
		mw = s->getMainWin();
		QTable *table = s->Table();

		// use all selected columns from spreadsheet
		int M = table->numCols();
		int col = M;

		QTableSelection ts = table->selection(table->currentSelection());
		s->addColumn();		// add new columns
		for(int i=ts.leftCol();i<=ts.rightCol();i++) {
			int N = table->numRows();
			double *data = new double[N];
			for(int j=0;j < N;j++)
				data[j] = table->text(j,i).toDouble();

			rif->evalCommandList((char *)opcb->currentText().latin1(),data,N);

			// add new column and fill with data
			for(int j=0;j < N;j++)
				table->setText(j,col,QString::number(data[j]));
			col++;
		}

		return 0;
	}

	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->Number()==0) {
		KMessageBox::error(this,i18n("No graph found!"));
		return -2;
	}

	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());
	GRAPHType gtype = gl->getType(item);

	double *data, *xdata;
	int N=0;
	QString label;
	if (gtype == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		N = g->Number();
		label = g->getLabel()->simpleTitle();

		data = new double[N];
		xdata = new double[N];
		for(int i=0;i<N;i++) {
			xdata[i] = g->Data()[i].X();
			data[i] = g->Data()[i].Y();
		}
	}
	else {
		// TODO : more types ?
		return -1;
	}

	rif->evalCommandList((char *)opcb->currentText().latin1(),data,N);

	// add new graph
	Point *ptr = new Point[N];
	for(int i=0;i<N;i++) {
		// mask nan values
		if(!finite(data[i])) {
			data[i]=0.0;
			ptr[i].setMasked();
		}
		ptr[i].setPoint(xdata[i],data[i]);
//		kdDebug()<<"RESULT = "<<data[i]<<endl;
	}
	free(data);

	QString fun = QString(opcb->currentText()+i18n(" of ")+label);
	Style *style = 0;
	Symbol *symbol = 0;
	if(p) {
		style = new Style((StylesType)cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			width->value(),pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	}

	double xmin=0, xmax=1, ymin=0, ymax=1;
	mw->calculateRanges2D(ptr,N,&xmin,&xmax,&ymin,&ymax);

	LRange range[2];
	range[0] = LRange(xmin,xmax);
	range[1] = LRange(ymin,ymax);

	Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,N);
	mw->addGraph2D(ng,p?sheetcb->currentItem():0);

	if(p) updateList();

	return 0;
}
