// LabPlot : LTableItem.cc
#include <LTableItem.h>

LTableItem::LTableItem(QTable *table, EditType editType, const QString &text)
	: QTableItem(table,editType,text)
{
	masked=false;
};

void LTableItem::paint ( QPainter * p, const QColorGroup & cg, const QRect & cr, bool selected ) {
	QColorGroup cg1 ( cg );

	QColor color = Qt::black;
	if(masked)
		color = Qt::red;
	cg1.setColor( QColorGroup::Text, color );
	//cg1.setColor( QColorGroup::Base,  QColor (225, 248, 233 ) );

	QTableItem::paint( p , cg1 , cr ,selected );
}

int LTableItem::alignment() const {
	// align everything to the left
	return AlignLeft;
}


