//LabPlot : Graph3D.cc

#include <iostream>
#include <kdebug.h>
#include "Graph3D.h"

using namespace std;

Graph3D::Graph3D(QString n, QString l, LRange r[3], LSource src, PType t, Style *st,
		Symbol *sy, Point3D *p, int nrx, int nry, bool b)
	: Graph(n,l,src,t,st,sy,nrx*nry,b)
{
	//kdDebug()<<"TYPE : "<<t<<endl;
	//kdDebug()<<"TYPE : "<<type<<endl;
	//kdDebug()<<"NAME : "<<name<<endl;

	if(r) {
		for(int i=0;i<3;i++) {
			range[i]=r[i];
		}
	}
	nx=nrx;
	ny=nry;
	number=nrx*nry;

	ptr = new Point3D[number];
	for (int i=0;i<number;i++)
		ptr[i] = p[i];

	delete [] p;
}

Graph3D::~Graph3D() {
	delete [] ptr;

	delete label;
}

Graph3D *Graph3D::Clone() {
	Graph3D *newg = new Graph3D(*this);
	Label *l = new Label();
	*l = *(label);
	newg->setLabel(l);	// set label
	Point3D *data = new Point3D[number];
	for(int i=0;i<number;i++)
		data[i] = ptr[i];
	newg->setData(data);	// set data

	LRange nrange[3];
	nrange[0] = range[0];
	nrange[1] = range[1];
	nrange[2] = range[2];
	newg->setRange(nrange);

	return newg;
}

void Graph3D::saveXML(QDomDocument doc, QDomElement graphtag) {
	QDomElement tag = doc.createElement( "Range" );
	tag.setAttribute("xmin",QString::number(range[0].rMin()));
	tag.setAttribute("xmax",QString::number(range[0].rMax()));
	tag.setAttribute("ymin",QString::number(range[1].rMin()));
	tag.setAttribute("ymax",QString::number(range[1].rMax()));
	tag.setAttribute("zmin",QString::number(range[2].rMin()));
	tag.setAttribute("zmax",QString::number(range[2].rMax()));
    	graphtag.appendChild( tag );

	tag = doc.createElement( "Dimension" );
	tag.setAttribute("x",QString::number(nx));
	tag.setAttribute("y",QString::number(ny));
    	graphtag.appendChild( tag );

	for (int i=0;i< nx*ny;i++) {
		tag = doc.createElement( "Data" );
		tag.setAttribute("x",QString::number(ptr[i].X()));
		tag.setAttribute("y",QString::number(ptr[i].Y()));
		tag.setAttribute("z",QString::number(ptr[i].Z()));
		tag.setAttribute("masked",QString::number(ptr[i].Masked()));
    		graphtag.appendChild( tag );
	}
}

void Graph3D::save(QTextStream *t, QProgressDialog *progress) {
	saveGraph(t);
	*t<<nx<<' '<<ny<<endl;
       	*t<<range[0].rMin()<<' '<<range[0].rMax()<<' '<<range[1].rMin()<<' '<<range[1].rMax()<<' ';
	*t<<range[2].rMin()<<' '<<range[2].rMax()<<' '<<endl;
	*t<<type<<' ';
	style->save(t);
	symbol->save(t);

	//dump data
	progress->setTotalSteps(number);
	for (int i=0;i< nx*ny;i++) {
		if(i%1000 == 0) progress->setProgress(i);
		*t<<ptr[i].X()<<' '<<ptr[i].Y()<<' '<<ptr[i].Z()<<' '<<ptr[i].Masked()<<endl;
	}
	progress->cancel();
}

void Graph3D::open(QTextStream *t, int version, QProgressDialog *progress) {
	openGraph(t,version);

	if (version > 2)
		*t>>nx>>ny;
	else if (version > 1) {
		QString title;
		*t>>name>>title>>nx>>ny;
		label->setTitle(title);
	}
	else
		*t>>name>>nx>>ny;

	kdDebug()<<"Graph3D : "<<name<<' '<<label<<' '<<nx<<' '<<ny<<endl;

	number=nx*ny;

	double xmin, xmax, ymin, ymax, zmin, zmax;
	*t>>xmin>>xmax>>ymin>>ymax>>zmin>>zmax;
	range[0].setMin(xmin);
	range[0].setMax(xmax);
	range[1].setMin(ymin);
	range[1].setMax(ymax);
	range[2].setMin(zmin);
	range[2].setMax(zmax);
	type = (PType) style->open(t,version);
	symbol->open(t,version);

	// read data
	double x, y, z;
	int m;
	ptr = new Point3D[nx*ny];
	progress->setTotalSteps(nx*ny);
	for (int i=0;i< nx*ny;i++) {
		if(i%1000 == 0) progress->setProgress(i);
		if (version>18) {
			*t>>x>>y>>z>>m;
			ptr[i].setMasked(m);
		}
		else
			*t>>x>>y>>z;
		ptr[i].setPoint(x,y,z);

		//kdDebug()<<x<<' '<<y<<' '<<z<<endl;
	}
	progress->cancel();
}

void Graph3D::openXML(QDomNode node) {
	int i=0;
	while(!node.isNull()) {
		QDomElement e = node.toElement();
//		kdDebug()<<"GRAPH TAG = "<<e.tagName()<<endl;
//		kdDebug()<<"GRAPH TEXT = "<<e.text()<<endl;

		openGraphXML(e);

		if(e.tagName() == "Number")
			ptr = new Point3D[e.text().toInt()];
		else if(e.tagName() == "Dimension") {
			nx = e.attribute("x").toInt();
			ny = e.attribute("y").toInt();
		}
		else if(e.tagName() == "Range") {
			range[0].setRange(e.attribute("xmin").toDouble(),e.attribute("xmax").toDouble());
			range[1].setRange(e.attribute("ymin").toDouble(),e.attribute("ymax").toDouble());
			range[2].setRange(e.attribute("zmin").toDouble(),e.attribute("zmax").toDouble());
		}
		else if(e.tagName() == "Data") {
			ptr[i].setPoint(e.attribute("x").toDouble(),e.attribute("y").toDouble(),
				e.attribute("z").toDouble());
			ptr[i].setMasked((bool) e.attribute("masked").toInt());
			i++;
		}

		node = node.nextSibling();
	}
}

QStringList Graph3D::Info(){
	QStringList s;
	QString t;
	if(type==P2D)
		t=i18n("2D");
	else if (type==PSURFACE)
		t=i18n("Surface");
	else if (type==P3D)
		t=i18n("3D");
	else if (type==PTERNARY)
		t=i18n("Ternary");

	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");

	s << label->simpleTitle() << t << sh;
	s << QString::number(nx) << QString::number(ny);
	s << QString::number(range[0].rMin()) + " .. " + QString::number(range[0].rMax());
	s << QString::number(range[1].rMin())+ " .. " + QString::number(range[1].rMax());
	s << QString::number(range[2].rMin())+ " .. " + QString::number(range[2].rMax());

	return s;
}

// calculate error range for xydy graph3d
LRange Graph3D::ErrorDYRange() {
	kdDebug()<<"ErrorDYRange()"<<endl;
	double min=0,max=0;
	double y,z;
	if(ptr==0)
		kdDebug()<<"ERROR ptr=0!"<<endl;
	for(int i=0;i<nx;i++) {
		y=ptr[i].Y();
		z=ptr[i].Z();
		if(i==0) {
			min=y-z;
			max=y+z;
		}
		else {
			y-z<min?min=y-z:0;
			y+z>max?max=y+z:0;
		}
	}

	return LRange(min,max);
}
