//LabPlot : Graph4D.cc

#include <iostream>
#include <kdebug.h>
#include "Graph4D.h"

using namespace std;

Graph4D::Graph4D(QString n, QString l, LRange r[4], LSource src, PType t, Style *st, 
		Symbol *sy, Point4D *p, int nr,bool ty, bool s)
	: Graph(n,l,src,t,st,sy,nr,s)
{
	if(r) {
		for(int i=0;i<4;i++) {
			range[i]=r[i];
		}
	}

	ptr = new Point4D[number];
	for (int i=0;i<number;i++)
		ptr[i] = p[i];
	
	gtype = ty;
}

Graph4D *Graph4D::Clone() {
	Graph4D *newg = new Graph4D(*this);
	Label *l = new Label();
	*l = *(label);
	newg->setLabel(l);	// set label
	Point4D *data = new Point4D[number];
	for(int i=0;i<number;i++)
		data[i] = ptr[i];
	newg->setData(data);	// set data

	LRange nrange[4];
	nrange[0] = range[0];
	nrange[1] = range[1];
	nrange[2] = range[2];
	nrange[3] = range[3];
	newg->setRange(nrange);

	return newg;
}

void Graph4D::saveXML(QDomDocument doc, QDomElement graphtag) {
	QDomElement tag = doc.createElement( "Range" );
	tag.setAttribute("xmin",QString::number(range[0].rMin()));
	tag.setAttribute("xmax",QString::number(range[0].rMax()));
	tag.setAttribute("ymin",QString::number(range[1].rMin()));
	tag.setAttribute("ymax",QString::number(range[1].rMax()));
	tag.setAttribute("zmin",QString::number(range[2].rMin()));
	tag.setAttribute("zmax",QString::number(range[2].rMax()));
	tag.setAttribute("tmin",QString::number(range[3].rMin()));
	tag.setAttribute("tmax",QString::number(range[3].rMax()));
    	graphtag.appendChild( tag );

	tag = doc.createElement( "GraphType" );
   	graphtag.appendChild( tag );
  	QDomText t = doc.createTextNode( QString::number(gtype) );
    	tag.appendChild( t );
	
	for (int i=0;i< number;i++) {
		tag = doc.createElement( "Data" );
		tag.setAttribute("x",QString::number(ptr[i].X()));
		tag.setAttribute("y",QString::number(ptr[i].Y()));
		tag.setAttribute("z",QString::number(ptr[i].Z()));
		tag.setAttribute("t",QString::number(ptr[i].T()));
		tag.setAttribute("masked",QString::number(ptr[i].Masked()));
    		graphtag.appendChild( tag );
	}
}

void Graph4D::save(QTextStream *t, QProgressDialog *progress) {
	saveGraph(t);
	*t<<number<<endl;
       	*t<<range[0].rMin()<<' '<<range[0].rMax()<<' '<<range[1].rMin()<<' '<<range[1].rMax()<<' ';
	*t<<range[2].rMin()<<' '<<range[2].rMax()<<' '<<range[3].rMin()<<' '<<range[4].rMax()<<endl;
	*t<<type<<' ';
	style->save(t);
	symbol->save(t);

	//dump data
	progress->setTotalSteps(number);
	for (int i=0;i< number;i++) {
		if(i%1000 == 0) progress->setProgress(i);
		*t<<ptr[i].X()<<' '<<ptr[i].Y()<<' '<<ptr[i].Z()<<' '<<ptr[i].T()<<' '<<ptr[i].Masked()<<endl;
	}
	progress->cancel();

	*t<<gtype<<endl;
}

void Graph4D::open(QTextStream *t, int version, QProgressDialog *progress) {
	openGraph(t,version);
	
	if (version > 2)
		*t>>number;
	else if (version > 1) {
		QString title;
		*t>>name>>title>>number;
		label->setTitle(title);
	}
	else
		*t>>name>>number;

	double xmin, xmax, ymin, ymax, zmin, zmax, tmin, tmax;
	*t>>xmin>>xmax>>ymin>>ymax>>zmin>>zmax>>tmin>>tmax;
	range[0].setMin(xmin);
	range[0].setMax(xmax);
	range[1].setMin(ymin);
	range[1].setMax(ymax);
	range[2].setMin(zmin);
	range[2].setMax(zmax);
	range[3].setMin(tmin);
	range[3].setMax(tmax);
	type = (PType) style->open(t,version);
	symbol->open(t,version);

	// read data
	double x, y, z, tt;
	int m;
	ptr = new Point4D[number];
	progress->setTotalSteps(number);
	for (int i=0;i< number;i++) {
		if(i%1000 == 0) progress->setProgress(i);

		if (version>18) {
			*t>>x>>y>>z>>tt>>m;
			ptr[i].setMasked(m);
		}
		else
			*t>>x>>y>>z>>tt;
		ptr[i].setPoint(x,y,z,tt);

		//kdDebug()<<x<<' '<<y<<' '<<z<<' '<<tt<<endl;
	}
	progress->cancel();

	*t>>tt;
	gtype = (bool)tt;
}

void Graph4D::openXML(QDomNode node) {
	int i=0;
	while(!node.isNull()) {
		QDomElement e = node.toElement();
		kdDebug()<<"GRAPH TAG = "<<e.tagName()<<endl;
		kdDebug()<<"GRAPH TEXT = "<<e.text()<<endl;

		openGraphXML(e);

		if(e.tagName() == "Number")
			ptr = new Point4D[e.text().toInt()];
		else if(e.tagName() == "GraphType")
			gtype = e.text().toInt();
		else if(e.tagName() == "Data") {
			ptr[i].setPoint(e.attribute("x").toDouble(),e.attribute("y").toDouble(),
				e.attribute("z").toDouble(),e.attribute("t").toDouble());
			ptr[i].setMasked((bool) e.attribute("masked").toInt());
			i++;
		}

		node = node.nextSibling();
	}
}

QStringList Graph4D::Info(){
	QStringList s;
	QString t;
	if(type==P2D)		// only possible type
		t=i18n("2D");
	
	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");
	
	// TODO : bool gtype ???
	s << label->simpleTitle() << t << sh;
	s << QString::number(number) << QString::number(1);
	s << QString::number(range[0].rMin()) + " .. " + QString::number(range[0].rMax());
	s << QString::number(range[1].rMin())+ " .. " + QString::number(range[1].rMax());
	s << QString::number(range[2].rMin())+ " .. " + QString::number(range[2].rMax());
	s << QString::number(range[3].rMin())+ " .. " + QString::number(range[3].rMax());
	
	return s;
}

// calculate x error range
LRange Graph4D::ErrorDXRange() {
	if(gtype == 1)	// x-y-dy1-dy2
		return range[0];

	double x,z;
	double min=0,max=0;
	for(int i=0;i<number;i++) {
		x=ptr[i].X();
		z=ptr[i].Z();
		if(i==0) {
			min=x-z;
			max=x+z;
		}
		else {
			x-z<min?min=x-z:0;
			x+z>max?max=x+z:0;
		}
	}

	return LRange(min,max);
}

// calculate y error range
LRange Graph4D::ErrorDYRange() {
	double min=0,max=0;
	double x,y,z,t;
	for(int i=0;i<number;i++) {
		x=ptr[i].X();
		y=ptr[i].Y();
		z=ptr[i].Z();
		t=ptr[i].T();
		if(i==0) {
			if(gtype == 0) {
				min=y-t;
				max=y+t;
			}
			else {
				min=y-z;
				max=y+t;
			}
		}
		else {
			if(gtype == 0) {
				y-t<min?min=y-t:0;
				y+t>max?max=y+t:0;
			}
			else {
				y-z<min?min=y-z:0;
				y+t>max?max=y+t:0;
			}
		}
	}

	return LRange(min,max);
}
