//LabPlot : FunctionDialog.h

#ifndef FUNCTIONDIALOG_H
#define FUNCTIONDIALOG_H

#include <qtoolbutton.h>
#include <qcheckbox.h>
#include <qcolor.h>
#include <klineedit.h>
#include <knuminput.h>
#include "Dialog.h"
#include "Worksheet.h"
#include "GraphListDialog.h"
#include "Graph2D.h"
#include "RichTextWidget.h"

class FunctionDialog: public Dialog
{
	Q_OBJECT
public:
	FunctionDialog(MainWin *mw, const char *name, ListDialog *l, int item, PType newtype);
public slots:
	int addFunction();	
	void updateLabel() { rtw->getLabel()->setTitle(funle->text()); rtw->update(); }

	void setFunction(QString fun) { funle->setText(fun); }			//!< set function to create 
	void recreate(bool b=true) { reread->setChecked(b); }		//!< create function new ?
	void setLabel(QString l=0) {					//!< set label of function
		if(l!=0) funle->setText(l);
		updateLabel();
	}
	void setRange(double a, double b) { xmin->setText(QString::number(a)); xmax->setText(QString::number(b)); }
														//!< set X range of function
	void setYRange(double a, double b) { ymin->setText(QString::number(a)); ymax->setText(QString::number(b)); }
														//!< set Y range of function
	void setPoints(int nr) { nx->setValue(nr); }				//!< set number of X points for function
	void setYPoints(int nr) { ny->setValue(nr); }				//!< set number of Y points for function
	
	int Apply() { return apply_clicked(); }
private slots :
	void insertConstant(int i);
	void insertFunction(int i);
	void ok_clicked() { if (!apply_clicked()) accept(); }
	void saveSettings(bool pressed=true);
	int apply_clicked();
private:
	void findPlot();
	KLineEdit *funle, *ymin, *ymax;
	KLineEdit *xmin, *xmax;
	KIntNumInput *nx, *ny;
	KComboBox *concb, *selcb;
	QCheckBox *reread;
	ListDialog *l;
	int item;
	PType type;
	Graph *graph;			// Graph
	RichTextWidget *rtw;		// label widget
};
#endif //FUNCTIONDIALOG_H
