//LabPlot : FilterMAGICK.cc

#include <klocale.h>
#include <kdebug.h>
#include <ktempfile.h>
#include "FilterMAGICK.h"

FilterMAGICK::FilterMAGICK(QString filename)
	: filename(filename)
{
#ifdef HAVE_MAGICK
	if(!filename.isEmpty()) {
		try {
			fileok=true;
			image.read(filename.latin1());
		}
		catch (Exception &e) {
			fileok=false;
			kdDebug() << "Image read : Caught exception: "<<endl;
#ifdef HAVE_EXCEPTIONS
			kdDebug() << e.what() << endl;
#endif
		}
		try {
			kdDebug()<<" FORMAT : "<<image.format().c_str()<<endl;
			if (image.format() == "Text" ) {
				fileok=false;
			}
		}
		catch (Exception &e) {
			fileok=false;
#ifdef HAVE_EXCEPTIONS
			kdDebug() << "Image format : Caught exception: " << e.what() << endl;
#endif
		}
	}
#else
	fileok=false;
#endif
}

//! return image as QPixmap
#ifdef HAVE_MAGICK
QPixmap FilterMAGICK::Pixmap() {
	KTempFile *tmpfile = new KTempFile(QString::null,".bmp");
	tmpfile->setAutoDelete(true);
	QString tmpname = tmpfile->name();

	// save image as bmp (tmp file)
	image.magick( "XPM" );
	image.write(tmpname.latin1());
	
	// read tmp file into pixmap
	QPixmap pm(width(),height());
	pm.fill(Qt::white);
	bool res = pm.load(tmpname.latin1(),"XPM");
	
	// load() sometimes does not work. Why?
	if(res==TRUE)
		kdDebug()<<"ImageMagick Loading was successful"<<endl;
	else {
		kdDebug()<<"ImageMagick Loading error"<<endl;
		return 0;
	}

	return pm;
}
#endif
