//LabPlot : FFTListDialog.h

#ifndef FFTLISTDIALOG_H
#define FFTLISTDIALOG_H

#include "ListDialog.h"

class FFTListDialog : public ListDialog
{
	Q_OBJECT
public:
	FFTListDialog(MainWin *mw, const char *name);
public slots:
	void setLibrary(int l) { library->setCurrentItem(l); }				//!< set library to use
	void setDirection(bool d=false) { transform->setCurrentItem(d); }	//!< set direction of transform (forward/backward)
	void setXValues(int v) { xvalues->setCurrentItem(v); }				//!< set type of x values
	void setYValues(int v) { yvalues->setCurrentItem(v); }				//!< set type of y values
	void setThreads(int t) { threadsni->setValue(t); }		//!< set number of threads
	void setNrThreads(int t) { setThreads(t); }
	int Apply() { return apply_clicked(); }
private slots:
	void saveSettings();
	int apply_clicked();
private:
	QComboBox *library, *transform, *xvalues, *yvalues;
	KIntNumInput *threadsni;
};

#endif // FFTLISTDIALOG_H
