//LabPlot : ConfigureDialog.h

#ifndef CONFIGUREDIALOG_H
#define CONFIGUREDIALOG_H

#include <qcheckbox.h>
#include <kdialogbase.h>
#include <kconfig.h>
#include <knuminput.h>
#include "MainWin.h"
#include "Dialog.h"

class ConfigureDialog: public KDialogBase
{
	Q_OBJECT
public:
	ConfigureDialog(MainWin *mw, KConfig *config);
private slots:
	void selectFont();
	void apply_clicked();
	void ok_clicked();
private:
	MainWin *mw;
	Dialog *dialog;
	KConfig *config;
	QRadioButton *fullscreen, *cascade;
	QCheckBox *asksheet, *originalsize, *ps2eps, *ps2pdf;
	KIntNumInput *recentnr;
	QRadioButton *color, *grayscale;
	KComboBox *pagesize, *orientation;
	QCheckBox *autosave, *auto_original, *speedmode, *keydatamode;
	KIntNumInput *asIntervalInput, *speedmodevalue;
	QFont defaultfont;	// local var for default font
	KLineEdit *fontle;
};
#endif //CONFIGUREDIALOG_H
