#ifndef SPREADSHEET_H
#define SPREADSHEET_H

#include <qwidget.h>
#include <qtable.h>
#include "MainWin.h"

class Spreadsheet: public QWidget
{
	Q_OBJECT
public:
	Spreadsheet(QWidget *parent, class MainWin *mw, const char *name);
	QStringList Info();
	QTable *Table() { return table; }
	void save(QTextStream *t);
	void open(QTextStream *t, int version);
	QString columnTitle(int col);
	void setColumnTitle(int col, QString name);
	bool eventFilter(QObject *object, QEvent *e);
public slots:
	void Clear();								//!< clear spreadsheet	

	void plot2DSimple() { plot2D(P2D); }			//!< make a simple 2d plot of all selected columns
	void plot2DPie() { plot2D(PPIE); }				//!< make a pie plot of all selected columns
	void plot2DPolar() { plot2D(PPOLAR); }			//!< make a polar plot of all selected columns
	void plotSurface() { plotMatrix(PSURFACE); }		//!< make a surface plot of all selected columns
	void plotQWT3D() { plotMatrix(PQWT3D); }
	void plot3DXYDY();							//!< make a 2d y-error plot of all selected columns
	void plot4DXYDXDY();						//!< make a 2d x-y-error plot of all selected columns
	void plot4DXYDYDY();						//!< make a 2d y1-y2-error plot of all selected columns
	void plot3DSimple() { plot3D(P3D); }			//!< make a simple 3d plot of all selected columns
	void plot3DTernary() { plot3D(PTERNARY); }		//!< make a ternary plot of all selected columns
	
	void cutSelection();							//!< cut current selection
	void copySelection();						//!< copy current selection
	void pasteSelection();						//!< paste current selection
	void clearSelection();						//!< clear current selection
	
	void fillRowNumber();						//!< fill selected column with row numbers
	void fillRandom(double max=1.0);				//!< fill selected column with random numbers (0..max)
	void setCurrentColumn(int i);					//!< set column i to current column (first column : 0) 
	
	void normSum();							//!< normalize current column to sum = 1.0
	void normMax(double max=1.0);				//!< normalize current column to maximum = max
	void transposeMatrix();						//!< transpose spreadsheet matrix
	void convertMatrixtoXYZ();					//!< convert matrix data to x-y-z data
	void convertXYZtoMatrix();					//!< convert x-y-z data to matrix data
	void exportData();							// TODO : export data to file <fn>
	void addColumn();							//!< add a column
	void sortAscending();						//!< sort current column ascending
	void sortDescending();						//!< sort current column descending
	void selectColumns(int left, int right=-1);		//!< select columns from right to left
	void selectRows(int top, int bottom=-1);			//!< select rows from top to bottom
	void deleteRows();							//!< delete selected rows
	void deleteColumns();						//!< delete selected columns
	void setValues(int srow=1, int erow=0, QString expr=0);	//!< set value of rows srow to erow in currentColumn to expr
	void setProperties(QString label=0, int type=1, int format=1, int rows=100);	
											//!< set properties of current columns (label, type, format, rows)
private slots:
	void plot2D(PType type);
	void plot3D(PType type);
	void plotMatrix(PType type);
private:
	int filledRows();
	int formatItem(int col);
	void sort();
	void qsort(int s, int e);
	void contextMenuEvent(QContextMenuEvent *);
	void resizeEvent(QResizeEvent *);
	void closeEvent(QCloseEvent *);
	class MainWin *mw;
	QTable *table;
	bool ascending;		// for sorting a column
};

#endif //SPREADSHEET
