//LabPlot : PlotQWT3D.h

#ifndef PLOTQWT3D_H
#define PLOTQWT3D_H

#ifdef HAVE_GL
#include "qwt3d_surfaceplot.h"
#endif
#include "Plot.h"

class PlotQWT3D : public Plot
#ifdef HAVE_GL
	, public Qwt3D::SurfacePlot
#endif
{
public:
	PlotQWT3D(Worksheet *p);
	QStringList Info();
	
	void Export(QString fn,QString format, int w, int h);
	void draw(QPainter *p, int w, int h);
	void drawCurves(QPainter *p, int w, int h);
#ifdef HAVE_GL
	void setPlotStyle(Qwt3D::PLOTSTYLE p) { plotstyle = p; }
	Qwt3D::PLOTSTYLE PlotStyle() { return plotstyle; }
	void setCoordinateStyle(Qwt3D::COORDSTYLE c) { coordinatestyle = c; }
	Qwt3D::COORDSTYLE CoordinateStyle() { return coordinatestyle; }
	void setFloorStyle( Qwt3D::FLOORSTYLE f) { floorstyle = f; }
	Qwt3D::FLOORSTYLE FloorStyle() { return floorstyle; }
	void setColorVector(Qwt3D::ColorVector c) { cv=c; }
	Qwt3D::ColorVector getColorVector() { return cv; }
#endif
	// unused	
	void saveAxes(QTextStream *t) {}
	void openAxes(QTextStream *t,int version) {}
	Axis *getAxis(int i) { return &axis[i]; }
	void setRanges(LRange* r) {range[0]=r[0];range[1]=r[1];range[2]=r[2];}
	void setActRanges(LRange* r) {}
	void enableGrid(int index,bool b) { gridenabled[index] = b; }
	bool gridEnabled(int index) { return gridenabled[index]; }
	void enableBorder(int index,bool b) { borderenabled[index] = b; }
	bool borderEnabled(int index) { return borderenabled[index]; }
	void setBorder(int item, bool on) {}
	bool aspectRatio() { return aspect_ratio; }
	void setAspectRatio(bool a) { aspect_ratio=a; }
private:
	void draw();
#ifdef HAVE_GL
	Qwt3D::PLOTSTYLE plotstyle;
	Qwt3D::COORDSTYLE coordinatestyle;
	Qwt3D::FLOORSTYLE floorstyle;
	Qwt3D::ColorVector cv;
#endif
	Axis axis[12];			//unused
	bool borderenabled[4];	// unused
	bool gridenabled[24];	// unused
	// x, xmin, y, ymin, z, zmin, x2, x2min, y2, y2min , z2, z2min, 
	// x3, x3min, y3, y3min, z3, z3min, x4, x4min, y4, y4min, z4, z4min
	bool aspect_ratio;	
};

#endif //PLOTQWT3D_H
