#include <qwidget.h>

#include "ModuleFactory.h"

#include "MainWin.h"
#include "Spreadsheet.h"
#include "GraphListDialog.h"
#include "ImportDialog.h"
#include "PstoEditDialog.h"

ModuleFactory::ModuleFactory(MainWin *mw, QWorkspace *ws)
	: mw(mw), ws(ws)
{
#ifdef HAVE_QSA_FAC
    registerClass( "Spreadsheet");
    registerClass( "Worksheet");
    registerClass( "GraphListDialog");
    registerClass( "ImportDialog");
    registerClass( "PstoEditDialog");
    registerClass( "ImageMagickDialog");
#endif
}

#ifdef HAVE_QSA_FAC
QObject *ModuleFactory::create( const QString &type, const QSArgumentList &args, QObject * ) {
	if ( type == "Spreadsheet" )
		return new Spreadsheet(ws, mw,"script");
	if ( type == "Worksheet" )
		return new Worksheet(ws, mw,"script");
	if ( type == "GraphListDialog" )
		return new GraphListDialog(mw,"script");
	if ( type == "ImportDialog" ) {
    		QString filename("1.dat");
		if (args.count()==1)
			filename=args[0].variant().toString();	
		return new ImportDialog(mw,filename,"script");
	}
	if ( type == "PstoEditDialog" ) {
    		QString filename("out.pdf");
		int format=4, size=5;
		double scale=1.0, rotation=0.0;
		if (args.count()>0)
			filename=args[0].variant().toString();	
		if (args.count()>1)
			format=args[1].variant().toInt();
		if (args.count()>2)
			size=args[2].variant().toInt();
		if (args.count()>3)
			scale=args[3].variant().toDouble();
		if (args.count()>4)
			rotation=args[4].variant().toDouble();
		return new PstoEditDialog(mw, filename, format, size, scale, rotation, "script");
	}
	if ( type == "ImageMagickDialog" ) {
    		QString filename("out.8bim");
		int format=0, sizex=800, sizey=600;
		double rotation=0.0;
		if (args.count()>0)
			filename=args[0].variant().toString();	
		if (args.count()>1)
			format=args[1].variant().toInt();
		if (args.count()>2)
			sizex=args[2].variant().toInt();
		if (args.count()>3)
			sizey=args[3].variant().toInt();
		if (args.count()>4)
			rotation=args[4].variant().toDouble();
		return new PstoEditDialog(mw, filename, format, sizex, sizey, rotation, "script");
	}

    return 0;
}
#endif
