//LabPlot : IntegrationListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <math.h>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "IntegrationListDialog.h"

using namespace std;

IntegrationListDialog::IntegrationListDialog(Worksheet *p, Spreadsheet *s, const char *name)
	: ListDialog(p, s, name)
{
	setCaption(i18n("Integration Dialog"));

	Plot *plot=0;
	if(p)
		plot = p->getPlot(p->API());

	// TODO : check for p==0

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	regioncb = new QCheckBox(i18n("use Region "),hb);
	if(plot && plot->RegionMin() != plot->RegionMax() )
		regioncb->setChecked(true);
	else
		regioncb->setChecked(false);
	new QLabel(i18n("( From "),hb);
	double from, to;
	if (s) {
		from=0;
		to=s->Table()->numRows();
	}
	else {
		from = plot->RegionMin();
		to = plot->RegionMax();
	}
	regionminle = new KLineEdit(QString::number(from),hb);
	regionminle->setValidator(new QDoubleValidator(regionminle));
	new QLabel(i18n(" To "),hb);
	regionmaxle = new KLineEdit(QString::number(to),hb);
	regionmaxle->setValidator(new QDoubleValidator(regionmaxle));
	new QLabel(i18n(" )"),hb);

	hb = new QHBox(tab1);
	areacb = new QCheckBox(i18n("Sum absolute values (area)"),hb);
	areacb->setChecked(false);
	hb = new QHBox(tab1);
	baselinecb = new QCheckBox(i18n("Use Baseline @ y = "),hb);
	baselinecb->setChecked(false);
	double baseline=0;
	if(p)
		baseline = plot->Baseline();
	baselinele = new KLineEdit(QString::number(baseline),hb);
	baselinele->setValidator(new QDoubleValidator(baselinele));

	hb = new QHBox(tab1);
	addgraph = new QCheckBox(i18n("Add Graph"),hb);
	addgraph->setChecked(true);
	infocb = new QCheckBox(i18n("Show Info"),hb);
	infocb->setChecked(true);

	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void IntegrationListDialog::apply_clicked() {
	// TODO : more selected graphs ???
	double sum=0, baseline = baselinele->text().toDouble();
	
	if(s) {
		QTable *table = s->Table();
		int col = table->currentColumn();
		
		// add column if needed
		bool empty=TRUE;
		for(int i=0;i<table->numRows();i++) {
			if(table->text(i,table->numCols()-1).length()>0) {
				empty =FALSE;
			}
		}
		if (!empty)
			s->addColumn();

		int newcol = table->numCols()-1;
		for (int i = regionminle->text().toInt() ;i<regionmaxle->text().toInt() ;i++) {
			double y1 = table->text(i,col).toDouble(), y2 = table->text(i+1,col).toDouble();
			if (baselinecb->isChecked()) {
				y1 -= baseline;
				y2 -= baseline;
			}	

			double area = (y1+y2)/2.0;
			
			if (areacb->isChecked())
				sum += fabs(area);
			else
				sum += area;
				
			// insert into last column
			table->setText(i,newcol,QString::number(sum));
		}
		return;
	}
	
	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->getNumber()==0)
		return;
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GRAPHType st = gl->getStruct(item);
	
	if (baselinecb->isChecked()) {
		p->getPlot(p->API())->setBaseline(baseline);
	}
	
	if (st == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->Data();
		int n=0;

		double xmin=0, xmax=1, ymin=0, ymax=1;
		for (int i = 0;i<nx-1;i++) {
			if (regioncb->isChecked() &&
				(a[i].X()<regionminle->text().toDouble() ||
				a[i+1].X()>regionmaxle->text().toDouble() )) {
				continue;
			}
			double y1 = a[i].Y(), y2 = a[i+1].Y();
			if (baselinecb->isChecked()) {
				y1 -= baseline;
				y2 -= baseline;
			}	
			double area = (y1+y2)/2.0*(a[i+1].X()-a[i].X());
			
			if (areacb->isChecked())
				sum += fabs(area);
			else
				sum += area;
			
			double x = (a[i].X()+a[i+1].X())/2;
			double y = sum;
			
			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}

			ptr[n++].setPoint(x,y);
		}

		if (addgraph->isChecked()) {
			LRange range[2];
			range[0] = LRange(xmin,xmax);
			range[1] = LRange(ymin,ymax);

			QString fun = QString("integration of "+g->Label());

			Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
				widthle->text().toInt(),pencb->currentItem(),brushcb->currentItem());
			Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
				(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
			
			Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,n);
			p->addGraph2D(ng);
		}
	}
	else if (st == GRAPH3D) {
		// TODO
	}
	else if (st == GRAPHM) {
		// TODO
	}

	updateList();

	QString info(" cummulative sum : "+QString::number(sum));
	if(baselinecb->isChecked())
		info += "\nwith baseline y = "+QString::number(baseline);
	if(regioncb->isChecked()) {
		double minx = regionminle->text().toDouble();
		double maxx = regionmaxle->text().toDouble();
		info += "\nwith region x = "+QString::number(minx)+
			" .. "+ QString::number(maxx);

		p->getPlot(p->API())->setRegionMin(minx);
		p->getPlot(p->API())->setRegionMax(maxx);
	}

	if (infocb->isChecked())
		KMessageBox::information(0,info);
}
