/*
**********************************************************************
**	File Name : dc395x_trm.h
**				
**  TEKRAM DC395U/UW/F ,DC315/U
**  PCI SCSI Bus Master Host AdapterDevice Driver
**  (SCSI chip set used Tekram ASIC TRM-S1040)
**		    				 
**********************************************************************
*/
/* $Id: dc395x_trm.h,v 1.43 2002/06/21 09:57:38 garloff Exp $ */
/*
*****************************************************
**    Tekram TRM_S1040 for DC395x driver, header file
*****************************************************
*/
#ifndef DC395x_trm_H
#define DC395x_trm_H

#include <linux/config.h>

#define DC395x_BANNER "Tekram DC395U/UW/F DC315/U"
#define DC395x_VERSION "1.41, 2002-06-21"

/* Kernel version autodetection */
#include <linux/version.h>
#ifndef KERNEL_VERSION
# define KERNEL_VERSION(V, P, S)	(((V) << 16) + ((P) << 8) + (S))
#endif

//-----------------------------------------------------
#if LINUX_VERSION_CODE < KERNEL_VERSION(1,3,50)
       #define VERSION_ELF_1_2_13
#elseif LINUX_VERSION_CODE < KERNEL_VERSION(1,3,95)
       #define VERSION_1_3_85
#else
       #define VERSION_2_0_0
#endif

#if defined(__SMP__) && !defined(CONFIG_SMP)
# define CONFIG_SMP
#endif

#define DC395x_MAX_CMD_QUEUE	32
//#define DC395x_MAX_QTAGS	32
#define DC395x_MAX_QTAGS	16
#define DC395x_MAX_ADAPTER_NUM	4
#define DC395x_MAX_SCSI_ID	16
#define DC395x_MAX_CMD_PER_LUN	DC395x_MAX_QTAGS 
#define DC395x_MAX_SG_TABLESIZE	64	/* HW limitation */
#define DC395x_MAX_SG_LISTENTRY	64	/* Must be equal or lower to previous item */
#define DC395x_MAX_SRB_CNT	63
//#define DC395x_MAX_CAN_QUEUE	7 * DC395x_MAX_QTAGS
#define DC395x_MAX_CAN_QUEUE	DC395x_MAX_SRB_CNT
#define DC395x_END_SCAN		2
#define DC395x_SEL_TIMEOUT	153	/* 250 ms selection timeout (@ 40 MHz) */
#define DC395x_MAX_RETRIES	3

//#define SYNC_FIRST

#if (LINUX_VERSION_CODE < KERNEL_VERSION (2,5,6) && !defined(FORCE_NEW_EH))
/* Our new EH is not yet so well tested; only use it for 2.5 ... */
# define OLD_EH
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION (2,1,70)) || defined(OLD_EH)
# define EH_FUNC	abort:		DC395x_abort,		\	
			reset:		DC395x_reset,
# define NORM_REC_LVL 1
#else
# define USE_NEW_EH
# define NORM_REC_LVL 0
# if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,14)
#  define EH_FUNC	use_new_eh_code: 1,			\
			eh_abort_handler: DC395x_eh_abort,	\
			eh_bus_reset_handler: DC395x_eh_bus_reset,
# else
#  define EH_FUNC	eh_abort_handler: DC395x_eh_abort,	\
			eh_bus_reset_handler: DC395x_eh_bus_reset,
# endif	
#endif

#if defined(HOSTS_C) || defined(MODULE) || LINUX_VERSION_CODE > KERNEL_VERSION(2,3,99)

# include <scsi/scsicam.h>

extern  int DC395x_detect(Scsi_Host_Template *psht);
extern  int DC395x_queue_command(Scsi_Cmnd *cmd, void (*done)(Scsi_Cmnd *));
# ifdef USE_NEW_EH
extern int DC395x_eh_abort(Scsi_Cmnd * SCpnt);
extern int DC395x_eh_bus_reset(Scsi_Cmnd * SCpnt);
# else
extern  int DC395x_abort(Scsi_Cmnd *cmd);
extern  int DC395x_reset(Scsi_Cmnd *cmd ,unsigned int resetFlags);
# endif
extern  int DC395x_bios_param(Disk *disk, kdev_t devno, int geom[]);
//--------------
# ifdef  MODULE
static  int DC395x_release(struct Scsi_Host *);
# else
#  define DC395x_release NULL
# endif
//--------------
extern  int DC395x_proc_info(char*, char**, off_t, int, int, int);
//--------------
# if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,30)
#  define DC395x_TRMS1040  {					\
		proc_name:	"dc395x_trm",			\
		proc_info:	DC395x_proc_info,		\
		name:		DC395x_BANNER " V" DC395x_VERSION,\
		detect:		DC395x_detect,			\
		release:	DC395x_release,			\
		queuecommand:	DC395x_queue_command,		\
		bios_param:	DC395x_bios_param,		\
		can_queue:	DC395x_MAX_CAN_QUEUE,		\
		this_id:	7,				\
		sg_tablesize:	DC395x_MAX_SG_TABLESIZE,	\
		cmd_per_lun:	DC395x_MAX_CMD_PER_LUN,		\
		EH_FUNC						\
		unchecked_isa_dma: 0,				\
		use_clustering:	DISABLE_CLUSTERING		\
		}
# else	/* 2.3.30 */
extern  struct proc_dir_entry DC395x_proc_scsi;
#  define DC395x_TRMS1040  {					\
		proc_dir:	&DC395x_proc_scsi,		\
		proc_info:	DC395x_proc_info,		\
		name:		DC395x_BANNER " V" DC395x_VERSION,\
		detect:		DC395x_detect,			\
		release:	DC395x_release,			\
		queuecommand:	DC395x_queue_command,		\
		bios_param:	DC395x_bios_param,		\
		can_queue:	DC395x_MAX_CAN_QUEUE,		\
		this_id:	7,				\
		sg_tablesize:	DC395x_MAX_SG_TABLESIZE,	\
		cmd_per_lun:	DC395x_MAX_CMD_PER_LUN,		\
		EH_FUNC						\
		unchecked_isa_dma: 0,				\
		use_clustering:	DISABLE_CLUSTERING		\
		}
# endif /* 2,3,30 */
#endif /* defined(HOSTS_C) || defined(MODULE) || LINUX_VERSION_CODE > 2,3,99 */
#endif /* DC395x_trm_H */
