/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.IoUtils;
import com.tonicsystems.jarjar.StringReader;
import com.tonicsystems.jarjar.StringVisitor;
import com.tonicsystems.jarjar.asm.ClassReader;
import com.tonicsystems.jarjar.ext_util.ClassPathIterator;
import com.tonicsystems.jarjar.ext_util.RuntimeIOException;
import java.io.IOException;
import java.io.PrintWriter;

class StringDumper {
    public void run(String classPath, final PrintWriter pw) throws IOException {
        try {
            StringVisitor sv = new StringVisitor(){
                private String className;
                private boolean needName;

                public void visitStart(String className) {
                    this.className = className;
                    this.needName = true;
                }

                public void visitString(String value, int line) {
                    if (value.length() > 0) {
                        if (this.needName) {
                            pw.println(this.className.replace('/', '.'));
                            this.needName = false;
                        }
                        pw.print("\t");
                        if (line >= 0) {
                            pw.print(line + ": ");
                        }
                        pw.print(IoUtils.escapeStringLiteral(value));
                        pw.println();
                    }
                }

                public void visitEnd() {
                    pw.flush();
                }
            };
            StringReader stringReader = new StringReader(sv);
            ClassPathIterator cp = new ClassPathIterator(classPath);
            while (cp.hasNext()) {
                new ClassReader(cp.getInputStream(cp.next())).accept(stringReader, false);
            }
        }
        catch (RuntimeIOException e) {
            throw (IOException)e.getCause();
        }
    }
}

