/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DepKill;
import com.tonicsystems.jarjar.DepKillTransformer;
import com.tonicsystems.jarjar.ManifestProcessor;
import com.tonicsystems.jarjar.PackageTransformer;
import com.tonicsystems.jarjar.PatternElement;
import com.tonicsystems.jarjar.ResourceProcessor;
import com.tonicsystems.jarjar.Rule;
import com.tonicsystems.jarjar.RulesImpl;
import com.tonicsystems.jarjar.Zap;
import com.tonicsystems.jarjar.ZapProcessor;
import com.tonicsystems.jarjar.ext_util.ClassTransformer;
import com.tonicsystems.jarjar.ext_util.EntryStruct;
import com.tonicsystems.jarjar.ext_util.JarProcessor;
import com.tonicsystems.jarjar.ext_util.JarProcessorChain;
import com.tonicsystems.jarjar.ext_util.JarTransformerChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class MainProcessor
implements JarProcessor {
    private boolean verbose;
    private JarProcessor chain;

    public MainProcessor(List patterns, boolean verbose) {
        this.verbose = verbose;
        ArrayList<PatternElement> zapList = new ArrayList<PatternElement>();
        ArrayList<PatternElement> killList = new ArrayList<PatternElement>();
        ArrayList<PatternElement> ruleList = new ArrayList<PatternElement>();
        Iterator it = patterns.iterator();
        while (it.hasNext()) {
            PatternElement pattern = (PatternElement)it.next();
            if (pattern instanceof Zap) {
                zapList.add(pattern);
                continue;
            }
            if (pattern instanceof Rule) {
                ruleList.add(pattern);
                continue;
            }
            if (!(pattern instanceof DepKill)) continue;
            killList.add(pattern);
        }
        RulesImpl rules = new RulesImpl(ruleList, verbose);
        this.chain = new JarProcessorChain(new JarProcessor[]{ManifestProcessor.getInstance(), new ZapProcessor(zapList), new JarTransformerChain(new ClassTransformer[]{new DepKillTransformer(killList), new PackageTransformer(rules)}), new ResourceProcessor(rules)});
    }

    public boolean process(EntryStruct struct) throws IOException {
        String name = struct.name;
        boolean result = this.chain.process(struct);
        if (this.verbose) {
            if (result) {
                if (name.equals(struct.name)) {
                    System.err.println("Renamed " + name + " -> " + struct.name);
                }
            } else {
                System.err.println("Removed " + name);
            }
        }
        return result;
    }
}

