/* GNOME Transcript
 * Copyright (C) 1999-2000 the Free Software Foundation
 * Authors : Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <gnome.h>
#include <gtrans_ifase/gtrans_ifase.h>
#include "gtrans_conn_list.h"




/**
 * gtrans_conn_list_remove_selected:
 * cl : The connection list
 *
 * Remove the selected item from the connection list.
 */
void
gtrans_conn_list_remove_selected(GtkWidget *cl)
{
	GList *sel;
	gint   row;
	
	sel = GTK_CLIST(cl)->selection;
	if(sel == NULL)
		return;
	
	row = GTK_CLIST(cl)->focus_row;
	gtk_clist_remove(GTK_CLIST(cl),row);
}




/**
 * gtrans_conn_list_selected:
 * @cl : The connection list
 *
 * Return the GTransConnListItem from the selected row.
 */
GTransConnListItem *
gtrans_conn_list_selected(GtkWidget *cl)
{
	GList *sel;
	gint   row;
	
	sel = GTK_CLIST(cl)->selection;
	if(sel == NULL)
		return NULL;
	
	row = GTK_CLIST(cl)->focus_row;
	return (GTransConnListItem *) gtk_clist_get_row_data(GTK_CLIST(cl),row);
}




/**
 * gtrans_conn_list_append:
 * @cl     : The connection list
 * @conn   : The open connection
 * @plugin : The plugin manging the connection
 *
 * Append the connection to the open connection's list.
 * Create a GTransConnListItem with the data passed attach it
 * as the rows data.
 */
void
gtrans_conn_list_append(GtkWidget           *cl,
			GTransIFaseConn     *conn,
			GTransIFasePlugin   *plugin)
{
	GTransConnListItem *item;
	gint                row;
	gchar              *info[4];
	
	item = g_new(GTransConnListItem,1);
	
	item->conn = conn;
	item->plugin = plugin;
	item->gde = NULL;
	
	info[0] = conn->db;
	info[1] = conn->user;
	info[2] = conn->host;
	info[3] = conn->port;
	
	row = gtk_clist_append(GTK_CLIST(cl),info);
	gtk_clist_set_row_data(GTK_CLIST(cl),row,(gpointer) item);
}




/**
 * gtrans_conn_list_new:
 *
 * Return a new connection list.
 */
GtkWidget *
gtrans_conn_list_new()
{
	GtkWidget *cl;
	gint       i;
	gchar     *titles[] = { N_("Database") , 
				N_("User") , 
				N_("Host") , 
				N_("Port") };
	

	cl = gtk_clist_new_with_titles(4,titles);
	gtk_clist_column_titles_passive(GTK_CLIST(cl));
	gtk_clist_set_shadow_type(GTK_CLIST(cl),GTK_SHADOW_NONE);
	for (i = 0 ; i < 4 ; i++)
		gtk_clist_set_column_auto_resize(GTK_CLIST(cl),i,TRUE);
	
	return cl;
}
