/*
 * GooCanvas. Copyright (C) 2005 Damon Chaplin.
 * Released under the GNU LGPL license. See COPYING for details.
 *
 * goocanvasgroupview.h - view for group item.
 */
#ifndef __GOO_CANVAS_GROUP_VIEW_H__
#define __GOO_CANVAS_GROUP_VIEW_H__

#include <gtk/gtk.h>
#include "goocanvasitemviewsimple.h"
#include "goocanvasgroup.h"

G_BEGIN_DECLS


#define GOO_TYPE_CANVAS_GROUP_VIEW            (goo_canvas_group_view_get_type ())
#define GOO_CANVAS_GROUP_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GOO_TYPE_CANVAS_GROUP_VIEW, GooCanvasGroupView))
#define GOO_CANVAS_GROUP_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GOO_TYPE_CANVAS_GROUP_VIEW, GooCanvasGroupViewClass))
#define GOO_IS_CANVAS_GROUP_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GOO_TYPE_CANVAS_GROUP_VIEW))
#define GOO_IS_CANVAS_GROUP_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GOO_TYPE_CANVAS_GROUP_VIEW))
#define GOO_CANVAS_GROUP_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GOO_TYPE_CANVAS_GROUP_VIEW, GooCanvasGroupViewClass))


typedef struct _GooCanvasGroupView       GooCanvasGroupView;
typedef struct _GooCanvasGroupViewClass  GooCanvasGroupViewClass;

/**
 * GooCanvasGroupView
 *
 * The #GooCanvasGroupView-struct struct contains private data only.
 */
struct _GooCanvasGroupView
{
  GObject parent;

  /* The canvas view. */
  GooCanvasView *canvas_view;

  /* The parent view. */
  GooCanvasItemView *parent_view;

  /* The corresponding group item. */
  GooCanvasItem *group;

  /* An array of pointers to GooCanvasItemViews, corresponding exactly to
     the items in the model. */
  GPtrArray *item_views;

  /* The bounds of the group. */
  GooCanvasBounds bounds;

  /* A few flags. */
  GooCanvasItemViewFlags flags;
};

struct _GooCanvasGroupViewClass
{
  GObjectClass parent_class;
};


GType              goo_canvas_group_view_get_type (void) G_GNUC_CONST;
GooCanvasItemView* goo_canvas_group_view_new      (GooCanvasView     *canvas_view,
						   GooCanvasItemView *parent_view,
						   GooCanvasItem     *group);

/* For subclass construction functions. */
void   goo_canvas_group_view_set_group (GooCanvasGroupView *group_view,
					GooCanvasItem      *group);

G_END_DECLS

#endif /* __GOO_CANVAS_GROUP_VIEW_H__ */
