#include "rbgnome.h"

static VALUE
get_gnome_type(gnobj)
     GtkObject* gnobj;
{
    VALUE klass;

    if (0);
    else if GTK_IS_CLOCK(gnobj) klass = gClock;
    else if GTK_IS_DIAL(gnobj) klass = gDial;
    else if GNOME_IS_ABOUT(gnobj) klass = gnoAbout;
    else if GNOME_IS_ANIMATOR(gnobj) klass = gnoAnimator;
    else if GNOME_IS_APP(gnobj) klass = gnoApp;
    else if GNOME_IS_APPBAR(gnobj) klass = gnoAppBar;
    else if GNOME_IS_CALCULATOR(gnobj) klass = gnoCalculator;
    else if GNOME_IS_CLIENT(gnobj) klass = gnoClient;
    else if GNOME_IS_COLOR_PICKER(gnobj) klass = gnoColorPicker;
    else if GNOME_IS_DATE_EDIT(gnobj) klass = gnoDateEdit;
    else if GNOME_IS_DIALOG(gnobj) klass = gnoDialog;
    else if GNOME_IS_DOCK(gnobj) klass = gnoDock;
    else if GNOME_IS_DOCK_BAND(gnobj) klass = gnoDockBand;
    else if GNOME_IS_DOCK_ITEM(gnobj) klass = gnoDockItem;
    else if GNOME_IS_DOCK_LAYOUT(gnobj) klass = gnoDockLayout;
    else if GNOME_IS_ENTRY(gnobj) klass = gnoEntry;
    else if GNOME_IS_FILE_ENTRY(gnobj) klass = gnoFileEntry;
    else if GNOME_IS_FONT_SELECTOR(gnobj) klass = gnoFontSelector;
    else if GNOME_IS_HREF(gnobj) klass = gnoHRef;
    else if GNOME_IS_ICON_ENTRY(gnobj) klass = gnoIconEntry;
    else if GNOME_IS_LESS(gnobj) klass = gnoLess;
    else if GNOME_IS_MESSAGE_BOX(gnobj) klass = gnoMessageBox;
    else if GNOME_IS_NUMBER_ENTRY(gnobj) klass = gnoNumberEntry;
    else if GNOME_IS_PAPER_SELECTOR(gnobj) klass = gnoPaperSelector;
    else if GNOME_IS_PIXMAP(gnobj) klass = gnoPixmap;
    else if GNOME_IS_PIXMAP_ENTRY(gnobj) klass = gnoPixmapEntry;
    else if GNOME_IS_SPELL(gnobj) klass = gnoSpell;
    else if GNOME_IS_STOCK(gnobj) klass = gnoStock;
    else klass = get_gtk_type(gnobj);

    return klass;
}

VALUE
make_gnobject_auto_type(gnobj)
    GtkObject* gnobj;
{
    return make_gobject(get_gnome_type(gnobj), gnobj);
}

VALUE mGnome;

void
Init_gnome()
{
    int argc, i;
    char **argv;

    argc = RARRAY(rb_argv)->len;
    argv = ALLOCA_N(char*,argc+1);
#if 1
    argv[0] = STR2CSTR(rb_progname);
#else
    argv[0] = STR2CSTR(rb_argv0);
#endif
    for (i=0;i<argc;i++) {
	if (TYPE(RARRAY(rb_argv)->ptr[i]) == T_STRING) {
	    argv[i+1] = RSTRING(RARRAY(rb_argv)->ptr[i])->ptr;
	}
	else {
	    argv[i+1] = "";
	}
    }
    argc++;
    program_invocation_name = 0;
    gnome_init("Ruby/GNOME", "0.0", argc, argv);

    mGnome = rb_define_module("Gnome");

    /* GnomePreferencesType */
    rb_define_const(mGnome, "REFERENCES_NEVER",
		    INT2FIX(GNOME_PREFERENCES_NEVER));
    rb_define_const(mGnome, "REFERENCES_USER",
		    INT2FIX(GNOME_PREFERENCES_USER));
    rb_define_const(mGnome, "REFERENCES_ALWAYS",
		    INT2FIX(GNOME_PREFERENCES_ALWAYS));

    Init_gtk_dial();
    Init_gtk_clock();

    Init_gnome_animator();
    Init_gnome_app();
    Init_gnome_appbar();
    Init_gnome_app_helper();
    Init_gnome_calculator();
    Init_gnome_client();
    Init_gnome_color_picker();
    Init_gnome_dateedit();
    Init_gnome_dialog();
    Init_gnome_dock();
    Init_gnome_dock_band();
    Init_gnome_dock_item();
    Init_gnome_dock_layout();
    Init_gnome_entry();
    Init_gnome_file_entry();
    Init_gnome_font_selector();
    Init_gnome_href();
    Init_gnome_icon_entry();
    Init_gnome_less();
    Init_gnome_messagebox();
    Init_gnome_number_entry();
    Init_gnome_paper_selector();
    Init_gnome_pixmap();
    Init_gnome_pixmap_entry();
    Init_gnome_spell();
    Init_gnome_stock();
    Init_gnome_about();

    Init_gnome_config();
    Init_gnome_i18n();
    Init_gnome_uidefs();
    Init_gnome_util();
}
