/* plugin.c generated by valac 0.14.2, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2010-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <fsobasics.h>
#include <freesmartphone.h>
#include <fsoframework.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <i2c.h>
#include <gio/gio.h>


#define POWER_SUPPLY_TYPE_N900 (power_supply_n900_get_type ())
#define POWER_SUPPLY_N900(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POWER_SUPPLY_TYPE_N900, PowerSupplyN900))
#define POWER_SUPPLY_N900_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POWER_SUPPLY_TYPE_N900, PowerSupplyN900Class))
#define POWER_SUPPLY_IS_N900(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POWER_SUPPLY_TYPE_N900))
#define POWER_SUPPLY_IS_N900_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POWER_SUPPLY_TYPE_N900))
#define POWER_SUPPLY_N900_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POWER_SUPPLY_TYPE_N900, PowerSupplyN900Class))

typedef struct _PowerSupplyN900 PowerSupplyN900;
typedef struct _PowerSupplyN900Class PowerSupplyN900Class;
typedef struct _PowerSupplyN900Private PowerSupplyN900Private;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _PowerSupplyN900GetInfoData PowerSupplyN900GetInfoData;
typedef struct _PowerSupplyN900GetPowerStatusData PowerSupplyN900GetPowerStatusData;
typedef struct _PowerSupplyN900GetCapacityData PowerSupplyN900GetCapacityData;

typedef enum  {
	POWER_SUPPLY_I2C_ERROR_SELECT_SLAVE_DEVICE,
	POWER_SUPPLY_I2C_ERROR_READ_FROM_DEVICE,
	POWER_SUPPLY_I2C_ERROR_WRITE_TO_DEVICE
} PowerSupplyI2C_ERROR;
#define POWER_SUPPLY_I2C_ERROR power_supply_i2c_error_quark ()
struct _PowerSupplyN900 {
	FsoFrameworkAbstractObject parent_instance;
	PowerSupplyN900Private * priv;
	gchar* name;
	gchar* typ;
	FreeSmartphoneDevicePowerStatus status;
	gboolean present;
	gint fd;
	gint capacity;
};

struct _PowerSupplyN900Class {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _PowerSupplyN900Private {
	FsoFrameworkSubsystem* subsystem;
	gchar* sysfsnode;
	guint8 charging_mode;
};

struct _PowerSupplyN900GetInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	PowerSupplyN900* self;
	GHashTable* result;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* res;
};

struct _PowerSupplyN900GetPowerStatusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	PowerSupplyN900* self;
	FreeSmartphoneDevicePowerStatus result;
	FreeSmartphoneDevicePowerStatus _tmp0_;
};

struct _PowerSupplyN900GetCapacityData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	PowerSupplyN900* self;
	gint result;
	gint _tmp0_;
};


static gpointer power_supply_n900_parent_class = NULL;
static FreeSmartphoneDevicePowerSupplyIface* power_supply_n900_free_smartphone_device_power_supply_parent_iface = NULL;
static FreeSmartphoneInfoIface* power_supply_n900_free_smartphone_info_parent_iface = NULL;
static GType power_supply_n900_type_id = 0;
extern gchar* sysfs_root;
gchar* sysfs_root = NULL;
extern gchar* sys_devices_platform_msusb_hdrc;
gchar* sys_devices_platform_msusb_hdrc = NULL;
extern PowerSupplyN900* instance;
PowerSupplyN900* instance = NULL;

#define POWER_SUPPLY_N900_CHARGER_I2C_FILE "/dev/i2c-2"
#define POWER_SUPPLY_N900_CHARGER_I2C_DEVICE ((guint8) 0x55)
#define POWER_SUPPLY_N900_CHARGER_READ_CAPACITY ((guint8) 0x0b)
GQuark power_supply_i2c_error_quark (void);
GType power_supply_n900_get_type (void) G_GNUC_CONST;
GType power_supply_n900_register_type (GTypeModule * module);
#define POWER_SUPPLY_N900_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), POWER_SUPPLY_TYPE_N900, PowerSupplyN900Private))
enum  {
	POWER_SUPPLY_N900_DUMMY_PROPERTY
};
PowerSupplyN900* power_supply_n900_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
PowerSupplyN900* power_supply_n900_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
void power_supply_n900_onPowerSupplyChangeNotification (PowerSupplyN900* self, GHashTable* properties);
static void _power_supply_n900_onPowerSupplyChangeNotification_fso_framework_kobject_notifier_func (GHashTable* properties, gpointer self);
gboolean power_supply_n900_onIdle (PowerSupplyN900* self);
static gboolean _power_supply_n900_onIdle_gsource_func (gpointer self);
static gchar* power_supply_n900_real_repr (FsoFrameworkAbstractObject* base);
static void power_supply_n900_pushMaskedByteToI2C (PowerSupplyN900* self, gint file, guint8 mask, guint8 device, guint8 command, guint8 value, GError** error);
static void power_supply_n900_pushByteToI2C (PowerSupplyN900* self, gint file, guint8 device, guint8 command, guint8 value, GError** error);
static guint8 power_supply_n900_pullByteFromI2C (PowerSupplyN900* self, gint file, guint8 device, guint8 command, GError** error);
static gboolean power_supply_n900_onTimeout (PowerSupplyN900* self);
static gboolean __lambda0_ (PowerSupplyN900* self);
static gboolean ___lambda0__gsource_func (gpointer self);
static gboolean _power_supply_n900_onTimeout_gsource_func (gpointer self);
gboolean power_supply_n900_isBattery (PowerSupplyN900* self);
gboolean power_supply_n900_isPresent (PowerSupplyN900* self);
gint power_supply_n900_getCapacity (PowerSupplyN900* self);
static void power_supply_n900_real_get_info_data_free (gpointer _data);
static void power_supply_n900_real_get_info (FreeSmartphoneInfo* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean power_supply_n900_real_get_info_co (PowerSupplyN900GetInfoData* _data_);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static void power_supply_n900_real_get_power_status_data_free (gpointer _data);
static void power_supply_n900_real_get_power_status (FreeSmartphoneDevicePowerSupply* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean power_supply_n900_real_get_power_status_co (PowerSupplyN900GetPowerStatusData* _data_);
static void power_supply_n900_real_get_capacity_data_free (gpointer _data);
static void power_supply_n900_real_get_capacity (FreeSmartphoneDevicePowerSupply* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean power_supply_n900_real_get_capacity_co (PowerSupplyN900GetCapacityData* _data_);
static void power_supply_n900_finalize (GObject* obj);
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error);
void fso_register_function (GTypeModule* module);


GQuark power_supply_i2c_error_quark (void) {
	return g_quark_from_static_string ("power_supply_i2c_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _power_supply_n900_onPowerSupplyChangeNotification_fso_framework_kobject_notifier_func (GHashTable* properties, gpointer self) {
	power_supply_n900_onPowerSupplyChangeNotification (self, properties);
}


static gboolean _power_supply_n900_onIdle_gsource_func (gpointer self) {
	gboolean result;
	result = power_supply_n900_onIdle (self);
	return result;
}


PowerSupplyN900* power_supply_n900_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	PowerSupplyN900 * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_;
	FsoFrameworkLogger* _tmp13_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (sysfsnode != NULL, NULL);
	self = (PowerSupplyN900*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = subsystem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->subsystem);
	self->priv->subsystem = _tmp1_;
	_tmp2_ = sysfsnode;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->sysfsnode);
	self->priv->sysfsnode = _tmp3_;
	_tmp4_ = open (POWER_SUPPLY_N900_CHARGER_I2C_FILE, O_RDWR, (mode_t) 0);
	self->fd = _tmp4_;
	_tmp5_ = self->fd;
	if (_tmp5_ == (-1)) {
		FsoFrameworkLogger* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp6_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp7_ = string_to_string (POWER_SUPPLY_N900_CHARGER_I2C_FILE);
		_tmp8_ = errno;
		_tmp9_ = g_strerror (_tmp8_);
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("Can't open ", _tmp7_, ": ", _tmp10_, ". Powersupply will not available.", NULL);
		_tmp12_ = _tmp11_;
		fso_framework_logger_warning (_tmp6_, _tmp12_);
		_g_free0 (_tmp12_);
		return self;
	}
	fso_framework_base_kobject_notifier_addMatch ("change", "power_supply", _power_supply_n900_onPowerSupplyChangeNotification_fso_framework_kobject_notifier_func, self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _power_supply_n900_onIdle_gsource_func, g_object_ref (self), g_object_unref);
	_tmp13_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp13_, "Created");
	return self;
}


PowerSupplyN900* power_supply_n900_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	return power_supply_n900_construct (POWER_SUPPLY_TYPE_N900, subsystem, sysfsnode);
}


static gchar* power_supply_n900_real_repr (FsoFrameworkAbstractObject* base) {
	PowerSupplyN900 * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (PowerSupplyN900*) base;
	_tmp0_ = self->priv->sysfsnode;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("<", _tmp1_, ">", NULL);
	result = _tmp2_;
	return result;
}


static gint32 i2c_smbus_write_byte_data_masked (gint file, guint8 mask, guint8 command, guint8 value) {
	gint32 result = 0;
	gint _tmp0_;
	guint8 _tmp1_;
	gint32 _tmp2_ = 0;
	gint32 _result_;
	gint32 _tmp3_;
	gint32 _tmp4_;
	guint8 oldvalue;
	gint _tmp5_;
	guint8 _tmp6_;
	guint8 _tmp7_;
	guint8 _tmp8_;
	guint8 _tmp9_;
	gint32 _tmp10_ = 0;
	_tmp0_ = file;
	_tmp1_ = command;
	_tmp2_ = i2c_smbus_read_byte_data (_tmp0_, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ == ((gint32) (-1))) {
		result = (gint32) (-1);
		return result;
	}
	_tmp4_ = _result_;
	oldvalue = ((guint8) _tmp4_) & 0xff;
	_tmp5_ = file;
	_tmp6_ = command;
	_tmp7_ = oldvalue;
	_tmp8_ = value;
	_tmp9_ = mask;
	_tmp10_ = i2c_smbus_write_byte_data (_tmp5_, _tmp6_, _tmp7_ | (_tmp8_ & _tmp9_));
	result = _tmp10_;
	return result;
}


static void power_supply_n900_pushMaskedByteToI2C (PowerSupplyN900* self, gint file, guint8 mask, guint8 device, guint8 command, guint8 value, GError** error) {
	gint _tmp0_;
	guint8 _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp10_;
	guint8 _tmp11_;
	guint8 _tmp12_;
	guint8 _tmp13_;
	gint32 _tmp14_ = 0;
	gint32 _result_;
	gint32 _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->fd;
	_tmp1_ = device;
	_tmp2_ = ioctl (_tmp0_, I2C_SLAVE, _tmp1_);
	if (_tmp2_ == (-1)) {
		guint8 _tmp3_;
		gint _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp3_ = device;
		_tmp4_ = errno;
		_tmp5_ = g_strerror (_tmp4_);
		_tmp6_ = g_strdup_printf ("Could not select slave device 0x%02X (%s)", (guint) _tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (POWER_SUPPLY_I2C_ERROR, POWER_SUPPLY_I2C_ERROR_SELECT_SLAVE_DEVICE, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == POWER_SUPPLY_I2C_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp10_ = file;
	_tmp11_ = mask;
	_tmp12_ = command;
	_tmp13_ = value;
	_tmp14_ = i2c_smbus_write_byte_data_masked (_tmp10_, _tmp11_, _tmp12_, _tmp13_);
	_result_ = _tmp14_;
	_tmp15_ = _result_;
	if (_tmp15_ == ((gint32) (-1))) {
		guint8 _tmp16_;
		guint8 _tmp17_;
		gint _tmp18_;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		GError* _tmp22_;
		GError* _tmp23_;
		_tmp16_ = device;
		_tmp17_ = command;
		_tmp18_ = errno;
		_tmp19_ = g_strerror (_tmp18_);
		_tmp20_ = g_strdup_printf ("Could not write at 0x%02X:0x%02X (%s)", (guint) _tmp16_, (guint) _tmp17_, _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_error_new_literal (POWER_SUPPLY_I2C_ERROR, POWER_SUPPLY_I2C_ERROR_WRITE_TO_DEVICE, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		_inner_error_ = _tmp23_;
		if (_inner_error_->domain == POWER_SUPPLY_I2C_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void power_supply_n900_pushByteToI2C (PowerSupplyN900* self, gint file, guint8 device, guint8 command, guint8 value, GError** error) {
	gint _tmp0_;
	guint8 _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp10_;
	guint8 _tmp11_;
	guint8 _tmp12_;
	gint32 _tmp13_ = 0;
	gint32 _result_;
	gint32 _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->fd;
	_tmp1_ = device;
	_tmp2_ = ioctl (_tmp0_, I2C_SLAVE, _tmp1_);
	if (_tmp2_ == (-1)) {
		guint8 _tmp3_;
		gint _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp3_ = device;
		_tmp4_ = errno;
		_tmp5_ = g_strerror (_tmp4_);
		_tmp6_ = g_strdup_printf ("Could not select i2c slave device 0x%02X (%s)", (guint) _tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (POWER_SUPPLY_I2C_ERROR, POWER_SUPPLY_I2C_ERROR_SELECT_SLAVE_DEVICE, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == POWER_SUPPLY_I2C_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp10_ = file;
	_tmp11_ = command;
	_tmp12_ = value;
	_tmp13_ = i2c_smbus_write_byte_data (_tmp10_, _tmp11_, _tmp12_);
	_result_ = _tmp13_;
	_tmp14_ = _result_;
	if (_tmp14_ == ((gint32) (-1))) {
		guint8 _tmp15_;
		guint8 _tmp16_;
		gint _tmp17_;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		GError* _tmp21_;
		GError* _tmp22_;
		_tmp15_ = device;
		_tmp16_ = command;
		_tmp17_ = errno;
		_tmp18_ = g_strerror (_tmp17_);
		_tmp19_ = g_strdup_printf ("Could not write at 0x%02X:0x%02X (%s)", (guint) _tmp15_, (guint) _tmp16_, _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_error_new_literal (POWER_SUPPLY_I2C_ERROR, POWER_SUPPLY_I2C_ERROR_WRITE_TO_DEVICE, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		_inner_error_ = _tmp22_;
		if (_inner_error_->domain == POWER_SUPPLY_I2C_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static guint8 power_supply_n900_pullByteFromI2C (PowerSupplyN900* self, gint file, guint8 device, guint8 command, GError** error) {
	guint8 result = 0U;
	gint _tmp0_;
	guint8 _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp10_;
	guint8 _tmp11_;
	gint32 _tmp12_ = 0;
	gint32 _result_;
	gint32 _tmp13_;
	gint32 _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->fd;
	_tmp1_ = device;
	_tmp2_ = ioctl (_tmp0_, I2C_SLAVE, _tmp1_);
	if (_tmp2_ == (-1)) {
		guint8 _tmp3_;
		gint _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp3_ = device;
		_tmp4_ = errno;
		_tmp5_ = g_strerror (_tmp4_);
		_tmp6_ = g_strdup_printf ("Could not select i2c slave device 0x%02X (%s)", (guint) _tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (POWER_SUPPLY_I2C_ERROR, POWER_SUPPLY_I2C_ERROR_SELECT_SLAVE_DEVICE, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == POWER_SUPPLY_I2C_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0U;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	_tmp10_ = file;
	_tmp11_ = command;
	_tmp12_ = i2c_smbus_read_byte_data (_tmp10_, _tmp11_);
	_result_ = _tmp12_;
	_tmp13_ = _result_;
	if (_tmp13_ == ((gint32) (-1))) {
		guint8 _tmp14_;
		guint8 _tmp15_;
		gint _tmp16_;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		GError* _tmp20_;
		GError* _tmp21_;
		_tmp14_ = device;
		_tmp15_ = command;
		_tmp16_ = errno;
		_tmp17_ = g_strerror (_tmp16_);
		_tmp18_ = g_strdup_printf ("Could not read at 0x%02X:0x%02X (%s)", (guint) _tmp14_, (guint) _tmp15_, _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_error_new_literal (POWER_SUPPLY_I2C_ERROR, POWER_SUPPLY_I2C_ERROR_READ_FROM_DEVICE, _tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp19_);
		_inner_error_ = _tmp21_;
		if (_inner_error_->domain == POWER_SUPPLY_I2C_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0U;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	_tmp22_ = _result_;
	result = ((guint8) _tmp22_) & 0xff;
	return result;
}


static gboolean power_supply_n900_onTimeout (PowerSupplyN900* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint _tmp0_;
		guint8 _tmp1_ = 0U;
		guint8 status;
		FsoFrameworkLogger* _tmp2_;
		guint8 _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gint _tmp6_;
		_tmp0_ = self->fd;
		_tmp1_ = power_supply_n900_pullByteFromI2C (self, _tmp0_, (guint8) 0x6b, (guint8) 0x00, &_inner_error_);
		status = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp2_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp3_ = status;
		_tmp4_ = g_strdup_printf ("Triggering charger while status is 0x%02X", (guint) _tmp3_);
		_tmp5_ = _tmp4_;
		fso_framework_logger_info (_tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = self->fd;
		power_supply_n900_pushByteToI2C (self, _tmp6_, (guint8) 0x6b, (guint8) 0x00, (guint8) 0x80, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FsoFrameworkLogger* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("Error: ", _tmp10_, ", abandoning charging", NULL);
		_tmp12_ = _tmp11_;
		fso_framework_logger_error (_tmp7_, _tmp12_);
		_g_free0 (_tmp12_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
	result = TRUE;
	return result;
}


void power_supply_n900_onPowerSupplyChangeNotification (PowerSupplyN900* self, GHashTable* properties) {
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* name;
	const gchar* _tmp3_;
	GHashTable* _tmp4_;
	gconstpointer _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* current_max;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GQuark _tmp10_ = 0U;
	static GQuark _tmp9_label0 = 0;
	static GQuark _tmp9_label1 = 0;
	static GQuark _tmp9_label2 = 0;
	FsoFrameworkLogger* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_ = NULL;
	guint8 _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (properties != NULL);
	_tmp0_ = properties;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "POWER_SUPPLY_NAME");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	name = _tmp2_;
	_tmp3_ = name;
	if (g_strcmp0 (_tmp3_, "isp1704") != 0) {
		_g_free0 (name);
		return;
	}
	_tmp4_ = properties;
	_tmp5_ = g_hash_table_lookup (_tmp4_, "POWER_SUPPLY_CURRENT_MAX");
	_tmp6_ = g_strdup ((const gchar*) _tmp5_);
	current_max = _tmp6_;
	_tmp7_ = current_max;
	_tmp8_ = _tmp7_;
	_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
	if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("1800")))) {
		switch (0) {
			default:
			{
				self->priv->charging_mode = (guint8) 0xc8;
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("800")))) {
		switch (0) {
			default:
			{
				self->priv->charging_mode = (guint8) 0x88;
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("500")))) {
		switch (0) {
			default:
			{
				self->priv->charging_mode = (guint8) 0x48;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				self->priv->charging_mode = (guint8) 0x08;
				break;
			}
		}
	}
	_tmp11_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp12_ = current_max;
	_tmp13_ = string_to_string (_tmp12_);
	_tmp14_ = self->priv->charging_mode;
	_tmp15_ = g_strdup_printf ("%hhu", _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat ("charging mode ", _tmp13_, " -> ", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	fso_framework_logger_info (_tmp11_, _tmp18_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _power_supply_n900_onIdle_gsource_func, g_object_ref (self), g_object_unref);
	_g_free0 (current_max);
	_g_free0 (name);
}


static gboolean __lambda0_ (PowerSupplyN900* self) {
	gboolean result = FALSE;
	power_supply_n900_onTimeout (self);
	result = FALSE;
	return result;
}


static gboolean ___lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda0_ (self);
	return result;
}


static gboolean _power_supply_n900_onTimeout_gsource_func (gpointer self) {
	gboolean result;
	result = power_supply_n900_onTimeout (self);
	return result;
}


gboolean power_supply_n900_onIdle (PowerSupplyN900* self) {
	gboolean result = FALSE;
	FsoFrameworkLogger* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp0_, "Disabling charger for configuration");
	{
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		guint8 _tmp5_;
		gint _tmp6_;
		FsoFrameworkLogger* _tmp7_;
		_tmp1_ = self->fd;
		power_supply_n900_pushByteToI2C (self, _tmp1_, (guint8) 0x6b, (guint8) 0x01, (guint8) 0xcc, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_tmp2_ = self->fd;
		power_supply_n900_pushMaskedByteToI2C (self, _tmp2_, (guint8) 0xff, (guint8) 0x6b, (guint8) 0x04, (guint8) 0x50, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_tmp3_ = self->fd;
		power_supply_n900_pushMaskedByteToI2C (self, _tmp3_, (guint8) 0xfc, (guint8) 0x6b, (guint8) 0x02, (guint8) 0x8c, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_tmp4_ = self->fd;
		_tmp5_ = self->priv->charging_mode;
		power_supply_n900_pushByteToI2C (self, _tmp4_, (guint8) 0x6b, (guint8) 0x01, _tmp5_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_tmp6_ = self->fd;
		power_supply_n900_pushByteToI2C (self, _tmp6_, (guint8) 0x6b, (guint8) 0x00, (guint8) 0x00, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_tmp7_ = ((FsoFrameworkAbstractObject*) self)->logger;
		fso_framework_logger_info (_tmp7_, "Charger programmed... sleeping 1 second");
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FsoFrameworkLogger* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = g_strconcat ("Error: ", _tmp11_, ", aborting", NULL);
		_tmp13_ = _tmp12_;
		fso_framework_logger_error (_tmp8_, _tmp13_);
		_g_free0 (_tmp13_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 15, _power_supply_n900_onTimeout_gsource_func, g_object_ref (self), g_object_unref);
	result = FALSE;
	return result;
}


gboolean power_supply_n900_isBattery (PowerSupplyN900* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->typ;
	result = g_strcmp0 (_tmp0_, "battery") == 0;
	return result;
}


gboolean power_supply_n900_isPresent (PowerSupplyN900* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = TRUE;
	return result;
}


gint power_supply_n900_getCapacity (PowerSupplyN900* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->capacity;
	result = _tmp0_;
	return result;
}


static void power_supply_n900_real_get_info_data_free (gpointer _data) {
	PowerSupplyN900GetInfoData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PowerSupplyN900GetInfoData, _data_);
}


static void power_supply_n900_real_get_info (FreeSmartphoneInfo* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PowerSupplyN900 * self;
	PowerSupplyN900GetInfoData* _data_;
	PowerSupplyN900* _tmp0_;
	self = (PowerSupplyN900*) base;
	_data_ = g_slice_new0 (PowerSupplyN900GetInfoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, power_supply_n900_real_get_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, power_supply_n900_real_get_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	power_supply_n900_real_get_info_co (_data_);
}


static GHashTable* power_supply_n900_real_get_info_finish (FreeSmartphoneInfo* base, GAsyncResult* _res_, GError** error) {
	GHashTable* result;
	PowerSupplyN900GetInfoData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static gboolean power_supply_n900_real_get_info_co (PowerSupplyN900GetInfoData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_str_hash;
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, _g_free0_, __vala_GValue_free0_);
	_data_->res = _data_->_tmp2_;
	_data_->result = _data_->res;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_hash_table_unref0 (_data_->res);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void power_supply_n900_real_get_power_status_data_free (gpointer _data) {
	PowerSupplyN900GetPowerStatusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PowerSupplyN900GetPowerStatusData, _data_);
}


static void power_supply_n900_real_get_power_status (FreeSmartphoneDevicePowerSupply* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PowerSupplyN900 * self;
	PowerSupplyN900GetPowerStatusData* _data_;
	PowerSupplyN900* _tmp0_;
	self = (PowerSupplyN900*) base;
	_data_ = g_slice_new0 (PowerSupplyN900GetPowerStatusData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, power_supply_n900_real_get_power_status);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, power_supply_n900_real_get_power_status_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	power_supply_n900_real_get_power_status_co (_data_);
}


static FreeSmartphoneDevicePowerStatus power_supply_n900_real_get_power_status_finish (FreeSmartphoneDevicePowerSupply* base, GAsyncResult* _res_, GError** error) {
	FreeSmartphoneDevicePowerStatus result;
	PowerSupplyN900GetPowerStatusData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean power_supply_n900_real_get_power_status_co (PowerSupplyN900GetPowerStatusData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->status;
	_data_->result = _data_->_tmp0_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void power_supply_n900_real_get_capacity_data_free (gpointer _data) {
	PowerSupplyN900GetCapacityData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PowerSupplyN900GetCapacityData, _data_);
}


static void power_supply_n900_real_get_capacity (FreeSmartphoneDevicePowerSupply* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PowerSupplyN900 * self;
	PowerSupplyN900GetCapacityData* _data_;
	PowerSupplyN900* _tmp0_;
	self = (PowerSupplyN900*) base;
	_data_ = g_slice_new0 (PowerSupplyN900GetCapacityData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, power_supply_n900_real_get_capacity);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, power_supply_n900_real_get_capacity_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	power_supply_n900_real_get_capacity_co (_data_);
}


static gint power_supply_n900_real_get_capacity_finish (FreeSmartphoneDevicePowerSupply* base, GAsyncResult* _res_, GError** error) {
	gint result;
	PowerSupplyN900GetCapacityData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean power_supply_n900_real_get_capacity_co (PowerSupplyN900GetCapacityData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp0_ = power_supply_n900_getCapacity (_data_->self);
	_data_->result = _data_->_tmp0_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void power_supply_n900_class_init (PowerSupplyN900Class * klass) {
	power_supply_n900_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PowerSupplyN900Private));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = power_supply_n900_real_repr;
	G_OBJECT_CLASS (klass)->finalize = power_supply_n900_finalize;
}


static void power_supply_n900_free_smartphone_device_power_supply_interface_init (FreeSmartphoneDevicePowerSupplyIface * iface) {
	power_supply_n900_free_smartphone_device_power_supply_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_power_status = (FreeSmartphoneDevicePowerStatus (*)(FreeSmartphoneDevicePowerSupply*, GError**)) power_supply_n900_real_get_power_status;
	iface->get_power_status_finish = power_supply_n900_real_get_power_status_finish;
	iface->get_capacity = (gint (*)(FreeSmartphoneDevicePowerSupply*, GError**)) power_supply_n900_real_get_capacity;
	iface->get_capacity_finish = power_supply_n900_real_get_capacity_finish;
}


static void power_supply_n900_free_smartphone_info_interface_init (FreeSmartphoneInfoIface * iface) {
	power_supply_n900_free_smartphone_info_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_info = (GHashTable* (*)(FreeSmartphoneInfo*, GError**)) power_supply_n900_real_get_info;
	iface->get_info_finish = power_supply_n900_real_get_info_finish;
}


static void power_supply_n900_instance_init (PowerSupplyN900 * self) {
	self->priv = POWER_SUPPLY_N900_GET_PRIVATE (self);
	self->priv->charging_mode = (guint8) 0x08;
	self->status = FREE_SMARTPHONE_DEVICE_POWER_STATUS_UNKNOWN;
	self->fd = -1;
	self->capacity = -1;
}


static void power_supply_n900_finalize (GObject* obj) {
	PowerSupplyN900 * self;
	self = POWER_SUPPLY_N900 (obj);
	_g_object_unref0 (self->priv->subsystem);
	_g_free0 (self->priv->sysfsnode);
	_g_free0 (self->name);
	_g_free0 (self->typ);
	G_OBJECT_CLASS (power_supply_n900_parent_class)->finalize (obj);
}


/**
 * Implementation of org.freesmartphone.Device.PowerSupply for the Nokia N900 device
 **/
GType power_supply_n900_get_type (void) {
	return power_supply_n900_type_id;
}


GType power_supply_n900_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (PowerSupplyN900Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_supply_n900_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerSupplyN900), 0, (GInstanceInitFunc) power_supply_n900_instance_init, NULL };
	static const GInterfaceInfo free_smartphone_device_power_supply_info = { (GInterfaceInitFunc) power_supply_n900_free_smartphone_device_power_supply_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo free_smartphone_info_info = { (GInterfaceInitFunc) power_supply_n900_free_smartphone_info_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	power_supply_n900_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "PowerSupplyN900", &g_define_type_info, 0);
	g_type_module_add_interface (module, power_supply_n900_type_id, FREE_SMARTPHONE_DEVICE_TYPE_POWER_SUPPLY, &free_smartphone_device_power_supply_info);
	g_type_module_add_interface (module, power_supply_n900_type_id, FREE_SMARTPHONE_TYPE_INFO, &free_smartphone_info_info);
	return power_supply_n900_type_id;
}


/**
 * This function gets called on plugin initialization time.
 * @return the name of your plugin here
 * @note that it needs to be a name in the format <subsystem>.<plugin>
 * else your module will be unloaded immediately.
 **/
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error) {
	gchar* result = NULL;
	FsoFrameworkSmartKeyFile* _tmp0_;
	FsoFrameworkSmartKeyFile* _tmp1_;
	FsoFrameworkSmartKeyFile* config;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	FsoFrameworkSubsystem* _tmp5_;
	const gchar* _tmp6_;
	PowerSupplyN900* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	_tmp0_ = fso_framework_theConfig;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	config = _tmp1_;
	_tmp2_ = fso_framework_smart_key_file_stringValue (config, "cornucopia", "sysfs_root", "/sys");
	_g_free0 (sysfs_root);
	sysfs_root = _tmp2_;
	_tmp3_ = sysfs_root;
	_tmp4_ = g_strdup_printf ("%s/devices/platform/musb_hdrc", _tmp3_);
	_g_free0 (sys_devices_platform_msusb_hdrc);
	sys_devices_platform_msusb_hdrc = _tmp4_;
	_tmp5_ = subsystem;
	_tmp6_ = sys_devices_platform_msusb_hdrc;
	_tmp7_ = power_supply_n900_new (_tmp5_, _tmp6_);
	_g_object_unref0 (instance);
	instance = _tmp7_;
	_tmp8_ = g_strdup ("fsodevice.powersupply_n900");
	result = _tmp8_;
	_g_object_unref0 (config);
	return result;
}


void fso_register_function (GTypeModule* module) {
	FsoFrameworkLogger* _tmp0_;
	g_return_if_fail (module != NULL);
	power_supply_n900_register_type (module);
	_tmp0_ = fso_framework_theLogger;
	fso_framework_logger_debug (_tmp0_, "fsodevice.powersupply_n900 fso_register_function()");
}



