/**
 * Copyright (C) 2002, 2003 Billy Biggs <vektor@dumbterm.net>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef PNGOUTPUT_H_INCLUDED
#define PNGOUTPUT_H_INCLUDED

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Example usage:
 *
 * pngoutput_t *pngout = pngoutput_new( "myimage.png", width, height, 1, 1 );
 *
 * for( i = 0; i < height; i++ ) {
 *     pngoutput_scanline( pngout, myimage + (i*bytesperline) );
 * }
 *
 * pngoutput_delete( pngout );
 */

typedef struct pngoutput_s pngoutput_t;

/**
 * Creates a new PNG output file at the given width and height.  If
 * alpha is true, then the input is 32bit-per-pixel RGBA.  If
 * compression is true, the png file will be compressed.
 */
pngoutput_t *pngoutput_new( const char *filename,
                            int width, int height,
                            int alpha, int compression );

/**
 * Closes the PNG file, finishing the write.
 */
void pngoutput_delete( pngoutput_t *pngoutput );

/**
 * Writes a scanline (of the appropriate width) to the PNG file.  Scanlines
 * should be provided from top to bottom of the image.
 */
void pngoutput_scanline( pngoutput_t *pngoutput, uint8_t *scanline );

#ifdef __cplusplus
};
#endif
#endif /* PNGOUTPUT_H_INCLUDED */
