#!/usr/bin/env python
# -*- Mode: python -*-
#
# Copyright (C) 2003 Mark Ferrell <xrxgrok@yahoo.com>
#
# -----------------------------------------------------------------------
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
# -----------------------------------------------------------------------

synonyms = ['tmp']
summary  = """Command template for writting new commands"""
usage = """Usage: cscvs template [-h]
        -h              example argument"""

def template(config):
	import os, getopt
	import SCM, CVS

	catalog = SCM.Catalog.Catalog()

	check = checkConfig()

	opts, args = getopt.getopt(config.args, 'h')

	for opt, val in opts:
		if opt == '-h':
			raise CVS.Usage
		else:
			raise CVS.Usage

	catalog.open(config.cat_path)

	# DO stuff

	catalog.close()


if __name__ == '__main__':
	import sys, os
	sys.path.append('modules')
	import CVS

	config = CVS.Config(os.path.curdir())
	config.cmd = 'template'
	config.args = sys.args[1:]
	config.cat_path = os.path.join(config.topdir, "CVS/Catalog")
	try:	log(config)
	except CVS.Usage:
		sys.stderr.write("%s\n" % usage)
		sys.exit(1)

# tag: Mark Ferrell Mon Jun  2 14:28:33 CDT 2003 (cmds/template.py)
#
