/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JAXPUtils {
    private static SAXParserFactory parserFactory = null;

    public static synchronized SAXParserFactory getParserFactory() throws BuildException {
        if (parserFactory == null) {
            parserFactory = JAXPUtils.newParserFactory();
        }
        return parserFactory;
    }

    public static SAXParserFactory newParserFactory() throws BuildException {
        try {
            return SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError e) {
            throw new BuildException("XML parser factory has not been configured correctly: " + e.getMessage(), e);
        }
    }

    public static Parser getParser() throws BuildException {
        try {
            return JAXPUtils.newSAXParser().getParser();
        }
        catch (SAXException e) {
            throw JAXPUtils.convertToBuildException(e);
        }
    }

    public static XMLReader getXMLReader() throws BuildException {
        try {
            return JAXPUtils.newSAXParser().getXMLReader();
        }
        catch (SAXException e) {
            throw JAXPUtils.convertToBuildException(e);
        }
    }

    private static SAXParser newSAXParser() throws BuildException {
        try {
            return JAXPUtils.getParserFactory().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new BuildException("Cannot create parser for the given configuration: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw JAXPUtils.convertToBuildException(e);
        }
    }

    private static BuildException convertToBuildException(SAXException e) {
        Exception nested = e.getException();
        if (nested != null) {
            return new BuildException(nested);
        }
        return new BuildException(e);
    }
}

