/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Javadoc
extends Task {
    private Commandline cmd = new Commandline();
    private static boolean javadoc1 = Project.getJavaVersion() == "1.1";
    private boolean foundJavaFile = false;
    private Path sourcePath = null;
    private File destDir = null;
    private String sourceFiles = null;
    private String packageNames = null;
    private boolean author = true;
    private boolean version = true;
    private DocletInfo doclet = null;
    private Path classpath = null;
    private Path bootclasspath = null;
    private String group = null;
    private Vector compileList = new Vector(10);
    private String packageList = null;
    private Vector links = new Vector(2);
    private Vector groups = new Vector(2);

    static /* synthetic */ boolean access$0(Javadoc $0) {
        return $0.foundJavaFile;
    }

    private void add11ArgIf(boolean b, String arg) {
        if (javadoc1 && b) {
            this.cmd.createArgument().setValue(arg);
        }
    }

    private void add12ArgIf(boolean b, String arg) {
        if (!javadoc1 && b) {
            this.cmd.createArgument().setValue(arg);
        }
    }

    private void addArgIf(boolean b, String arg) {
        if (b) {
            this.cmd.createArgument().setValue(arg);
        }
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.project);
        }
        return this.bootclasspath.createPath();
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public DocletInfo createDoclet() {
        this.doclet = new DocletInfo();
        return this.doclet;
    }

    public GroupArgument createGroup() {
        GroupArgument ga = new GroupArgument();
        this.groups.addElement(ga);
        return ga;
    }

    public LinkArgument createLink() {
        LinkArgument la = new LinkArgument();
        this.links.addElement(la);
        return la;
    }

    public Path createSourcepath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(this.project);
        }
        return this.sourcePath.createPath();
    }

    private void evaluatePackages(Commandline toExecute, Path sourcePath, Vector packages) {
        this.log("Source path = " + sourcePath.toString(), 3);
        this.log("Packages = " + packages, 3);
        Vector<String> addedPackages = new Vector<String>();
        String[] list = sourcePath.list();
        int j = 0;
        while (j < list.length) {
            File source = this.project.resolveFile(list[j]);
            Vector foundPackages = this.findPackages(source);
            Enumeration e = foundPackages.elements();
            block1: while (e.hasMoreElements()) {
                String pack = (String)e.nextElement();
                int i = 0;
                while (i < packages.size()) {
                    if (this.matches(pack, (String)packages.elementAt(i))) {
                        if (addedPackages.contains(pack)) continue block1;
                        toExecute.createArgument().setValue(pack);
                        addedPackages.addElement(pack);
                        continue block1;
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public void execute() throws BuildException {
        Object var6_10;
        StringTokenizer tok;
        if ("javadoc2".equals(this.taskType)) {
            this.log("!! javadoc2 is deprecated. Use javadoc instead. !!");
        }
        if (this.sourcePath == null) {
            String msg = "sourcePath attribute must be set!";
            throw new BuildException(msg);
        }
        this.log("Generating Javadoc", 2);
        Commandline toExecute = (Commandline)this.cmd.clone();
        toExecute.setExecutable("javadoc");
        if (this.classpath == null) {
            this.classpath = Path.systemClasspath;
        }
        if (!javadoc1) {
            toExecute.createArgument().setValue("-classpath");
            toExecute.createArgument().setPath(this.classpath);
            toExecute.createArgument().setValue("-sourcepath");
            toExecute.createArgument().setPath(this.sourcePath);
        } else {
            toExecute.createArgument().setValue("-classpath");
            toExecute.createArgument().setValue(String.valueOf(this.sourcePath.toString()) + System.getProperty("path.separator") + this.classpath.toString());
        }
        if (this.version && this.doclet == null) {
            toExecute.createArgument().setValue("-version");
        }
        if (this.author && this.doclet == null) {
            toExecute.createArgument().setValue("-author");
        }
        if (javadoc1 || this.doclet == null) {
            if (this.destDir == null) {
                String msg = "destDir attribute must be set!";
                throw new BuildException(msg);
            }
            toExecute.createArgument().setValue("-d");
            toExecute.createArgument().setFile(this.destDir);
        }
        if (!javadoc1) {
            Enumeration e;
            if (this.doclet != null) {
                if (this.doclet.getName() == null) {
                    throw new BuildException("The doclet name must be specified.", this.location);
                }
                toExecute.createArgument().setValue("-doclet");
                toExecute.createArgument().setValue(this.doclet.getName());
                if (this.doclet.getPath() != null) {
                    toExecute.createArgument().setValue("-docletpath");
                    toExecute.createArgument().setPath(this.doclet.getPath());
                }
                e = this.doclet.getParams();
                while (e.hasMoreElements()) {
                    DocletParam param = (DocletParam)e.nextElement();
                    if (param.getName() == null) {
                        throw new BuildException("Doclet parameters must have a name");
                    }
                    toExecute.createArgument().setValue(param.getName());
                    if (param.getValue() == null) continue;
                    toExecute.createArgument().setValue(param.getValue());
                }
            }
            if (this.bootclasspath != null) {
                toExecute.createArgument().setValue("-bootclasspath");
                toExecute.createArgument().setPath(this.bootclasspath);
            }
            if (this.links.size() != 0) {
                e = this.links.elements();
                while (e.hasMoreElements()) {
                    LinkArgument la = (LinkArgument)e.nextElement();
                    if (la.getHref() == null) {
                        throw new BuildException("Links must provide the URL to the external class documentation.");
                    }
                    if (la.isLinkOffline()) {
                        String packageListLocation = la.getPackagelistLoc();
                        if (packageListLocation == null) {
                            throw new BuildException("The package list location for link " + la.getHref() + " must be provided because the link is offline");
                        }
                        toExecute.createArgument().setValue("-linkoffline");
                        toExecute.createArgument().setValue(la.getHref());
                        toExecute.createArgument().setValue(packageListLocation);
                        continue;
                    }
                    toExecute.createArgument().setValue("-link");
                    toExecute.createArgument().setValue(la.getHref());
                }
            }
            if (this.group != null) {
                tok = new StringTokenizer(this.group, ",", false);
                while (tok.hasMoreTokens()) {
                    String grp = tok.nextToken().trim();
                    int space = grp.indexOf(" ");
                    if (space <= 0) continue;
                    String name = grp.substring(0, space);
                    String pkgList = grp.substring(space + 1);
                    toExecute.createArgument().setValue("-group");
                    toExecute.createArgument().setValue(name);
                    toExecute.createArgument().setValue(pkgList);
                }
            }
            if (this.groups.size() != 0) {
                e = this.groups.elements();
                while (e.hasMoreElements()) {
                    GroupArgument ga = (GroupArgument)e.nextElement();
                    String title = ga.getTitle();
                    String packages = ga.getPackages();
                    if (title == null || packages == null) {
                        throw new BuildException("The title and packages must be specified for group elements.");
                    }
                    toExecute.createArgument().setValue("-group");
                    toExecute.createArgument().setValue(title);
                    toExecute.createArgument().setValue(packages);
                }
            }
        }
        if (this.packageNames != null && this.packageNames.length() > 0) {
            Vector<String> packages = new Vector<String>();
            StringTokenizer tok2 = new StringTokenizer(this.packageNames, ",", false);
            while (tok2.hasMoreTokens()) {
                String name = tok2.nextToken().trim();
                if (name.endsWith(".*")) {
                    packages.addElement(name);
                    continue;
                }
                toExecute.createArgument().setValue(name);
            }
            if (packages.size() > 0) {
                this.evaluatePackages(toExecute, this.sourcePath, packages);
            }
        }
        if (this.sourceFiles != null && this.sourceFiles.length() > 0) {
            tok = new StringTokenizer(this.sourceFiles, ",", false);
            while (tok.hasMoreTokens()) {
                toExecute.createArgument().setValue(tok.nextToken().trim());
            }
        }
        if (this.packageList != null) {
            toExecute.createArgument().setValue("@" + this.packageList);
        }
        this.log("Javadoc args: " + toExecute, 3);
        this.log("Javadoc execution", 2);
        JavadocOutputStream out = new JavadocOutputStream(2);
        JavadocOutputStream err = new JavadocOutputStream(1);
        Execute exe = new Execute(new PumpStreamHandler(out, err));
        exe.setAntRun(this.project);
        exe.setWorkingDirectory(this.project.getBaseDir());
        try {
            try {
                exe.setCommandline(toExecute.getCommandline());
                exe.execute();
            }
            catch (IOException e) {
                throw new BuildException("Javadoc failed: " + e, e, this.location);
            }
            var6_10 = null;
            out.logFlush();
            err.logFlush();
        }
        catch (Throwable throwable) {
            var6_10 = null;
            out.logFlush();
            err.logFlush();
            try {
                out.close();
                err.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            out.close();
            err.close();
        }
        catch (IOException iOException) {}
    }

    protected Vector findPackages(File srcDir) {
        Vector foundPkgs = new Vector();
        if (srcDir != null && srcDir.isDirectory()) {
            this.scan(srcDir, "", foundPkgs);
        }
        return foundPkgs;
    }

    private boolean matches(String string, String pattern) {
        return string.startsWith(pattern.substring(0, pattern.length() - 2));
    }

    protected void scan(File srcDir, String vpath, Vector pkgs) {
        String newPkg;
        this.foundJavaFile = false;
        File dir = new File(srcDir, vpath);
        if (!dir.isDirectory()) {
            return;
        }
        String[] files = dir.list(new FilenameFilter(){

            public boolean accept(File dir1, String name) {
                if (name.endsWith(".java")) {
                    Javadoc.this.foundJavaFile = true;
                    return false;
                }
                File d = new File(dir1, name);
                return d.isDirectory() && d.getName().indexOf("-") == -1;
            }
        });
        if (this.foundJavaFile && vpath.length() > 0 && !pkgs.contains(newPkg = vpath.substring(1).replace(File.separatorChar, '.'))) {
            pkgs.addElement(newPkg);
        }
        int i = 0;
        while (i < files.length) {
            this.scan(srcDir, String.valueOf(vpath) + File.separator + files[i], pkgs);
            ++i;
        }
    }

    public void setAdditionalparam(String add) {
        this.cmd.createArgument().setValue(add);
    }

    public void setAuthor(boolean src) {
        this.author = src;
    }

    public void setBootClasspathRef(Reference r) {
        this.createBootclasspath().setRefid(r);
    }

    public void setBootclasspath(Path src) {
        if (this.bootclasspath == null) {
            this.bootclasspath = src;
        } else {
            this.bootclasspath.append(src);
        }
    }

    public void setBottom(String src) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-bottom");
            this.cmd.createArgument().setValue(src);
        }
    }

    public void setCharset(String src) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-charset");
            this.cmd.createArgument().setValue(src);
        }
    }

    public void setClasspath(Path src) {
        if (this.classpath == null) {
            this.classpath = src;
        } else {
            this.classpath.append(src);
        }
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
    }

    public void setDocencoding(String enc) {
        this.cmd.createArgument().setValue("-docencoding");
        this.cmd.createArgument().setValue(enc);
    }

    public void setDoclet(String src) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
        }
        this.doclet.setName(src);
    }

    public void setDocletPath(Path src) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
        }
        this.doclet.setPath(src);
    }

    public void setDocletPathRef(Reference r) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
        }
        this.doclet.createPath().setRefid(r);
    }

    public void setDoctitle(String src) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-doctitle");
            this.cmd.createArgument().setValue(src);
        }
    }

    public void setEncoding(String enc) {
        this.cmd.createArgument().setValue("-encoding");
        this.cmd.createArgument().setValue(enc);
    }

    public void setExtdirs(String src) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-extdirs");
            this.cmd.createArgument().setValue(src);
        }
    }

    public void setFooter(String src) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-footer");
            this.cmd.createArgument().setValue(src);
        }
    }

    public void setGroup(String src) {
        this.group = src;
    }

    public void setHeader(String src) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-header");
            this.cmd.createArgument().setValue(src);
        }
    }

    public void setHelpfile(File f) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-helpfile");
            this.cmd.createArgument().setFile(f);
        }
    }

    public void setLink(String src) {
        if (!javadoc1) {
            this.createLink().setHref(src);
        }
    }

    public void setLinkoffline(String src) {
        if (!javadoc1) {
            LinkArgument le = this.createLink();
            le.setOffline(true);
            String linkOfflineError = "The linkoffline attribute must include a URL and a package-list file location separated by a space";
            if (src.trim().length() == 0) {
                throw new BuildException(linkOfflineError);
            }
            StringTokenizer tok = new StringTokenizer(src, " ", false);
            le.setHref(tok.nextToken());
            if (!tok.hasMoreTokens()) {
                throw new BuildException(linkOfflineError);
            }
            le.setPackagelistLoc(tok.nextToken());
        }
    }

    public void setLocale(String src) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-locale");
            this.cmd.createArgument().setValue(src);
        }
    }

    public void setMaxmemory(String max) {
        if (javadoc1) {
            this.cmd.createArgument().setValue("-J-mx" + max);
        } else {
            this.cmd.createArgument().setValue("-J-Xmx" + max);
        }
    }

    public void setNodeprecated(boolean b) {
        this.addArgIf(b, "-nodeprecated");
    }

    public void setNodeprecatedlist(boolean b) {
        this.add12ArgIf(b, "-nodeprecatedlist");
    }

    public void setNohelp(boolean b) {
        this.add12ArgIf(b, "-nohelp");
    }

    public void setNoindex(boolean b) {
        this.addArgIf(b, "-noindex");
    }

    public void setNonavbar(boolean b) {
        this.add12ArgIf(b, "-nonavbar");
    }

    public void setNotree(boolean b) {
        this.addArgIf(b, "-notree");
    }

    public void setOld(boolean b) {
        this.add12ArgIf(b, "-1.1");
    }

    public void setOverview(File f) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-overview");
            this.cmd.createArgument().setFile(f);
        }
    }

    public void setPackage(boolean b) {
        this.addArgIf(b, "-package");
    }

    public void setPackageList(String src) {
        this.packageList = src;
    }

    public void setPackagenames(String src) {
        this.packageNames = src;
    }

    public void setPrivate(boolean b) {
        this.addArgIf(b, "-private");
    }

    public void setProtected(boolean b) {
        this.addArgIf(b, "-protected");
    }

    public void setPublic(boolean b) {
        this.addArgIf(b, "-public");
    }

    public void setSerialwarn(boolean b) {
        this.add12ArgIf(b, "-serialwarn");
    }

    public void setSourcefiles(String src) {
        this.sourceFiles = src;
    }

    public void setSourcepath(Path src) {
        if (this.sourcePath == null) {
            this.sourcePath = src;
        } else {
            this.sourcePath.append(src);
        }
    }

    public void setSourcepathRef(Reference r) {
        this.createSourcepath().setRefid(r);
    }

    public void setSplitindex(boolean b) {
        this.add12ArgIf(b, "-splitindex");
    }

    public void setStylesheetfile(File f) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-stylesheetfile");
            this.cmd.createArgument().setFile(f);
        }
    }

    public void setUse(boolean b) {
        this.add12ArgIf(b, "-use");
    }

    public void setVerbose(boolean b) {
        this.add12ArgIf(b, "-verbose");
    }

    public void setVersion(boolean src) {
        this.version = src;
    }

    public void setWindowtitle(String src) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-windowtitle");
            this.cmd.createArgument().setValue(src);
        }
    }

    public class DocletParam {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class DocletInfo {
        private String name;
        private Path path;
        private Vector params = new Vector();

        public DocletParam createParam() {
            DocletParam param = new DocletParam();
            this.params.addElement(param);
            return param;
        }

        public Path createPath() {
            if (this.path == null) {
                this.path = new Path(Javadoc.this.getProject());
            }
            return this.path.createPath();
        }

        public String getName() {
            return this.name;
        }

        public Enumeration getParams() {
            return this.params.elements();
        }

        public Path getPath() {
            return this.path;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPath(Path path) {
            if (this.path == null) {
                this.path = path;
            } else {
                this.path.append(path);
            }
        }

        public void setPathRef(Reference r) {
            this.createPath().setRefid(r);
        }
    }

    public class LinkArgument {
        private String href;
        private boolean offline = false;
        private String packagelistLoc;

        public String getHref() {
            return this.href;
        }

        public String getPackagelistLoc() {
            return this.packagelistLoc;
        }

        public boolean isLinkOffline() {
            return this.offline;
        }

        public void setHref(String hr) {
            this.href = hr;
        }

        public void setOffline(boolean offline) {
            this.offline = offline;
        }

        public void setPackagelistLoc(String src) {
            this.packagelistLoc = src;
        }
    }

    public class GroupArgument {
        private String title;
        private String packages;

        public String getPackages() {
            return this.packages;
        }

        public String getTitle() {
            return this.title;
        }

        public void setPackages(String src) {
            this.packages = src;
        }

        public void setTitle(String src) {
            this.title = src;
        }
    }

    private class JavadocOutputStream
    extends LogOutputStream {
        private String queuedLine = null;

        JavadocOutputStream(int level) {
            super(Javadoc.this, level);
        }

        protected void logFlush() {
            if (this.queuedLine != null) {
                super.processLine(this.queuedLine, 3);
                this.queuedLine = null;
            }
        }

        protected void processLine(String line, int messageLevel) {
            if (messageLevel == 2 && line.startsWith("Generating ")) {
                if (this.queuedLine != null) {
                    super.processLine(this.queuedLine, 3);
                }
                this.queuedLine = line;
            } else {
                if (this.queuedLine != null) {
                    if (line.startsWith("Building ")) {
                        super.processLine(this.queuedLine, 3);
                    } else {
                        super.processLine(this.queuedLine, 2);
                    }
                    this.queuedLine = null;
                }
                super.processLine(line, messageLevel);
            }
        }
    }
}

