package com.ibm.bsf.util;

import java.util.Hashtable;

/**
 * An <code>ScriptSymbolTable</code> object is used by a <code>CodeBuffer</code>
 * object to implement nested scopes.
 * 
 * @author   Matthew J. Duftler
 */
class ScriptSymbolTable extends Hashtable
{
	private Hashtable parentTable;

	ScriptSymbolTable(Hashtable parentTable)
  {
  	this.parentTable = parentTable;
  }

  public synchronized Object get(Object key)
  {
  	Object ret = super.get(key);

  	if (ret == null && parentTable != null)
  	  ret = parentTable.get(key);

  	return ret;
  }
}