package org.biojava.utils.bytecode;

/**
 * Instructions which load float constants
 *
 * @author Thomas Down
 * @author Matthew Pocock
 */

class FloatConstantInstruction implements Instruction {
  private final float val;
  
  FloatConstantInstruction(float val) {
    this.val = val;
  }
  
  public void writeCode(CodeContext ctx) throws CodeException {
    int i_indx = ctx.getConstants().resolveFloat(val);
    if (i_indx < 256) {
      ctx.writeByte(ByteCode.op_ldc);
      ctx.writeByte((byte) i_indx);
    } else {
      ctx.writeByte(ByteCode.op_ldc_w);
      ctx.writeShort(i_indx);
    }
  }
  
  public int stackDepth() {
    return stackDelta();
  }
  
  public int stackDelta() {
    return 1;
  }
}
