package org.biojava.utils.bytecode;

/**
 * Instructions which act on fields.
 *
 * @author Thomas Down
 * @author Matthew Pocock
 */

class FieldInstruction implements Instruction {
  private final CodeField field;
  private final byte opcode;
  
  FieldInstruction(byte op, CodeField f) {
    if(f == null) {
      throw new NullPointerException("CodeField can not be null");
    }
    this.opcode = op;
    this.field = f;
  }
  
  public void writeCode(CodeContext ctx) throws CodeException {
    ctx.writeByte(opcode);
    ctx.writeShort(ctx.getConstants().resolveField(field));
  }
  
  public int stackDepth() {
    return stackDelta();
  }
  
  public int stackDelta() {
    return 1;
  }
}
