package org.biojava.utils.bytecode;

/**
 * Instructions which use a Class.
 *
 * @author Matthew Pocock
 */

class ClassInstruction implements Instruction {
  private final CodeClass clazz;
  private final byte opcode;
  private final int delta;
  
  ClassInstruction(byte op, CodeClass c, int delta) {
    if(c == null) {
      throw new NullPointerException("CodeClass can not be null");
    }
    this.opcode = op;
    this.clazz = c;
    this.delta = delta;
  }
  
  public void writeCode(CodeContext ctx) throws CodeException {
    ctx.writeByte(opcode);
    ctx.writeShort(ctx.getConstants().resolveClass(clazz));
  }
  
  public int stackDepth() {
    return Math.max(delta, 0);
  }
  
  public int stackDelta() {
    return delta;
  }
}
