/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***********************************************************************/
/* $Id: read_file_utils.c,v 1.1 1998/02/28 18:09:06 lance Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "data.h"

#define DEBUG 0

#if(DEBUG)
static Data **d = NULL;
#endif

/* realloc this many points at a time */
#define DELTA_NUM_POINTS 10000 /* must be > 1 */

void check_data_size(Plot *plot,int num_fields,
			    unsigned long num_points)
{
  int i;
  unsigned long k;
  Data *D;/* dummy data pointer */

  for(i=plot->dim - num_fields;i<plot->dim;i++)
    { 
      assert((D =plot->data[i] = (Data *) realloc((void*) plot->data[i],
	      sizeof(Data)*num_points)) != NULL);
      /* rebuild linked list because addresses 
       * may have changed and add the new links
       */
      D[0].prev = NULL;
      D[0].next = &(D[1]);
      for(k=1;k<num_points-1;k++)
	{
	  D[k].next = &(D[k+1]);
	  D[k].prev = &(D[k-1]);
	}
      D[k].prev = &(D[k-1]);
      D[k].next = NULL;
    }

#if(DEBUG)
  if(d == NULL)
    assert(NULL != (d = (Data **) malloc(sizeof(Data *)*num_fields)));
 printf("*num_points = %d\n",*num_points);
  for(i=0;i<num_fields;i++)
    d[i] = plot->data[plot->dim-num_fields +i];
  while(d[0]!=NULL)
    {
      for(i=0;i<num_fields;i++)
	{
	  printf("%g %d    ",d[i]->val,&(d[i]->val));
	  d[i] = d[i]->next;
	}
      printf("\n");
    }
  free(d);
  d = NULL;
#endif
}

void add_data_size(Plot *plot, Data **currentdata,
		     int num_fields,unsigned long *num_points)
{
  int i;
  unsigned long k,n;
  Data *D;/* dummy data pointer */

  n = *num_points + DELTA_NUM_POINTS/num_fields;

  for(i=plot->dim - num_fields;i<plot->dim;i++)
    { 
      assert((D =plot->data[i] = (Data *) realloc((void*) plot->data[i],
	      sizeof(Data)*n)) != NULL);
      /* rebuild linked list because addresses 
       * may have changed and add the new links
       */
      D[0].prev = NULL;
      D[0].next = &(D[1]);
      for(k=1;k<n-1;k++)
	{
	  D[k].next = &(D[k+1]);
	  D[k].prev = &(D[k-1]);
	}
      D[k].prev = &(D[k-1]);
      D[k].next = NULL;
      currentdata[i-plot->dim+num_fields] = &(D[*num_points]);
    }
  *num_points = n;
#if(DEBUG)
  if(d == NULL)
    assert(NULL != (d = (Data **) malloc(sizeof(Data *)*num_fields)));
 printf("*num_points = %d\n",*num_points);
  for(i=0;i<num_fields;i++)
    d[i] = plot->data[plot->dim-num_fields +i];
  while(d[0]!=NULL)
    {
      for(i=0;i<num_fields;i++)
	{
	  printf("%g %d    ",d[i]->val,&(d[i]->val));
	  d[i] = d[i]->next;
	}
      printf("\n");
    }
  free(d);
  d = NULL;
#endif
}

void read_report(Plot *plot, unsigned long num_points, int num_fields, const char *file)
{
  if(plot->flag & VERBOSE)
    fprintf(stderr,
	    "quickplot Info: read in (%d lines) x (%d values/line) = (%d values) from file: %s\n",
	    num_points,num_fields,num_points*num_fields,file);

}

void realloc_plot_data_and_max_min(Plot *plot, int num_fields)
{
  int i;
  /** setup plot->data,plot->max and plot->min */
  assert((plot->data = (Data **) realloc(
           (void *)plot->data,
	   sizeof(Data *)*plot->dim)) != NULL);
  for(i=plot->dim-num_fields;i<plot->dim;i++)
    plot->data[i] = NULL;

  /* realloc max and min */
  assert((plot->max = (double *) realloc(
           (void *)plot->max,
	   sizeof(double)*plot->dim)) != NULL);
  assert((plot->min = (double *) realloc(
           (void *)plot->min,
	   sizeof(double)*plot->dim)) != NULL);
}
