/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***********************************************************************/
/* $Id: malloc_scale_and_stuff.c,v 1.1 1998/02/28 18:09:06 lance Exp $ */
#include <stdio.h>
#include <assert.h>

#include "data.h"

void malloc_scale_and_stuff(Plot *plot)
{
  int i,j,k;

  assert((plot->scale=(double **)malloc(sizeof(double *)*plot->num_plots))!=NULL);
  assert((plot->shift=(double **)malloc(sizeof(double *)*plot->num_plots))!=NULL);
  for(i=0;i<plot->num_plots;i++)
    {
      assert((plot->scale[i]=(double *)malloc(sizeof(double)*2))!=NULL);
      assert((plot->shift[i]=(double *)malloc(sizeof(double)*2))!=NULL);
    }
  plot->num_zoom = DEFAULT_NUM_ZOOM; /* we'll realloc more if needed */
  plot->zoom_count = 0;
  assert((plot->z_scale=(double **)malloc(sizeof(double *)*plot->num_zoom))!=NULL);
  assert((plot->z_shift=(double **)malloc(sizeof(double *)*plot->num_zoom))!=NULL);
  for(i=0;i<plot->num_zoom;i++)
    {
      assert((plot->z_scale[i]=(double *)malloc(sizeof(double)*2))!=NULL);
      assert((plot->z_shift[i]=(double *)malloc(sizeof(double)*2))!=NULL);
    }

  assert((plot->start=(Data ****)malloc(sizeof(Data ***)*plot->num_zoom))!=NULL);
  assert((plot->end  =(Data ****)malloc(sizeof(Data ***)*plot->num_zoom))!=NULL);
  for(i=0;i<plot->num_zoom;i++)
    {
      assert((plot->start[i]=(Data ***)malloc(sizeof(Data **)*plot->num_plots))!=NULL);
      assert((plot->end[i]  =(Data ***)malloc(sizeof(Data **)*plot->num_plots))!=NULL);
      for(j=0;j<plot->num_plots;j++)
	{
	  assert((plot->start[i][j]=(Data **)malloc(
                 sizeof(Data *)*2))!=NULL);
	  assert((plot->end[i][j]  =(Data **)malloc(
                 sizeof(Data *)*2))!=NULL);
	}
    }  
  for(i=0;i<plot->num_zoom;i++)
    {
      for(j=0;j<plot->num_plots;j++)
	{
	  for(k=0;k<2;k++)
	    {      
	      Data *dd;
	      plot->start[i][j][k] = plot->data[plot->list[j][k]];
	      for(dd = plot->data[plot->list[j][k]];dd->next != NULL;dd = dd->next);
	      plot->end[i][j][k] = dd;
	    }
	}
    }   
}
