/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***********************************************************************/
/* $Id: add_plots_list.c,v 1.1 1998/02/28 18:09:06 lance Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "data.h"

static int is_it_seperater_char(char c)
{
  return (c == ' ' || c == '\t' || c == ',');
}

/* put in ' ' in place of the first num strings
 * that are seperated by  seperater_char
 * i.e. is_it_seperater_char()=TRUE
 */
static void strip_strings(char *str, int num)
{
  int i,j;
  
  for(j=0;is_it_seperater_char(str[j])
	&& str[j] != '\0';j++)
    str[j] = ' ';
  for(i=0;i<num && str[j] != '\0';i++)
    {
      while(!is_it_seperater_char(str[j])
	    && str[j] != '\0')
	str[j++] = ' ';
      while(is_it_seperater_char(str[j])
	    && str[j] != '\0')
	  str[j++] = ' ';
    }
}

int add_plots_list(Plot *plot, const char *list, int plot_Options)
{
  int i,j,x,y;
  char *local_list;

  assert(NULL != (local_list = (char *) malloc(
		    (strlen(list)+1)*sizeof(char)
		                           )));
  strcpy(local_list,list);
  while(2 == (j = sscanf(local_list,"%d %d",&y,&x)))
    {  
#if(0)
      fprintf(stderr,"%s\n",local_list);
#endif
      strip_strings(local_list,2);/* remove 2 strings from the list */
      if(x < 0 || y < 0)
	{
	  free(local_list);
	  return 1;
	}
      plot->num_plots++;

      assert(NULL != (plot->plot_opt = (int *) realloc(
		    (void *)plot->plot_opt,sizeof(int)*plot->num_plots)));
      assert(NULL != (plot->list = (int **) realloc(
		    (void *)plot->list,sizeof(int *)*plot->num_plots)));
      assert(NULL != (plot->list[plot->num_plots-1] = (int *) malloc(
				    sizeof(int)*2)));
      plot->list[plot->num_plots-1][X] = x;/* list what fields to plot */
      plot->list[plot->num_plots-1][Y] = y;
      plot->plot_opt[plot->num_plots-1] = plot_Options;
    }
  free(local_list);
  /* if you got an odd number of field indexes in list */
  if(j == 1 || plot->num_plots == 0)
    return 1;
  return 0;
}

