/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * load_int.c
 *
 * code to setup a new integrator
 */

#include <stdio.h>

#include "prop.h"
#include "pm.h"
#include "flow.h"

void
load_int()
{
  int n = *((int *) pm(GET, "Prop.Int_Num", NULL));
  
  if (*((int *) pm(GET, "Model.Mapping_Flag", NULL)))
    {
      pm(EXEC, "Model.Load_Iter", NULL);
      return;
    }

  Int_Algol = Int_Sel[n];
  Int_Algol.Int_Init();
  Int_Algol.Panel_Sel_Value = Int_Cur_Choice = n;

  prop_to_pm();

#ifdef PVM
  /* make sure correct integrator gets loaded on slaves ! */
  if (*(int *) pm(GET, "Control.Pvm_Host", NULL) == TRUE)
    {
      void pvm_put_all(), pvm_pm_exec_all();
      pvm_pm_put_all("Flow.Int_Num");
      pvm_pm_exec_all("Flow.Load_Int");
    }
#endif
/* PVM */

}


void
prop_to_pm(void)
{
  int i, j, k;

  pm(PUT, "Prop.Name", Int_Algol.Int_Name,
     PUT, "Prop.N_Ifields", Int_Algol.Num_Ifields,
     PUT, "Prop.N_Dfields", Int_Algol.Num_Dfields,
     PUT, "Prop.N_Cfields", Int_Algol.Num_Sel_Items,
     INIT, "Prop.Ifields", Int_Algol.Num_Ifields,
     INIT, "Prop.Dfields", Int_Algol.Num_Dfields,
     INIT, "Prop.Cfields", Int_Algol.Num_Sel_Items,
     INIT, "Prop.Cfields_Num_Choices", Int_Algol.Num_Sel_Items,
     INIT, "Prop.Ifields_Names", Int_Algol.Num_Ifields, MAX_LONG_STR,
     INIT, "Prop.Dfields_Names", Int_Algol.Num_Dfields, MAX_LONG_STR,
     INIT, "Prop.Cfields_Names", Int_Algol.Num_Sel_Items, MAX_LONG_STR,
     PUT_LIST, "Prop.Ifields", 0, Int_Algol.Num_Ifields-1, Int_Algol.Ifields,
     PUT_LIST, "Prop.Dfields", 0, Int_Algol.Num_Dfields-1, Int_Algol.Dfields,
     PUT_LIST, "Prop.Cfields", 0, Int_Algol.Num_Sel_Items-1, Int_Algol.Sel_Values,
     PUT_LIST, "Prop.Cfields_Num_Choices", 0, Int_Algol.Num_Sel_Items-1,
               Int_Algol.Num_Sel_Choices,
     NULL);

  for (i=0; i<Int_Algol.Num_Ifields; i++)
    pm(PUT, "Prop.Ifields_Names", i, Int_Algol.Ifield_Names[i], NULL);
  for (i=0; i<Int_Algol.Num_Dfields; i++)
    pm(PUT, "Prop.Dfields_Names", i, Int_Algol.Dfield_Names[i], NULL);
  for (i=0; i<Int_Algol.Num_Sel_Items; i++)
    pm(PUT, "Prop.Cfields_Names", i, Int_Algol.Sel_Labels[i], NULL);

  j = 0;
  for (i=0; i<Int_Algol.Num_Sel_Items; i++)
    j += Int_Algol.Num_Sel_Choices[i];
  pm(INIT, "Prop.Cfields_All_Choices", j, MAX_LONG_STR, NULL);
  j = 0;
  for (i=0; i<Int_Algol.Num_Sel_Items; i++) {
    for (k=0; k<Int_Algol.Num_Sel_Choices[i]; k++)
      pm(PUT, "Prop.Cfields_All_Choices", j+k, Int_Algol.Sel_Choices[i][k],
	 NULL);
    j += k;
  }
  
}
