""" Demonstration of the Pmw MenuBar megawidget.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import Tkinter
import Pmw

def printme(text):
    print text

class Demo:
    def __init__(self, parent):
	# Create the Balloon.
	self.balloon = Pmw.Balloon(parent)

	# Create and pack the MenuBar.
	menuBar = Pmw.MenuBar(parent,
		hull_relief = 'raised',
		hull_borderwidth = 1,
		balloon = self.balloon)
	menuBar.pack(fill = 'x')
	self.menuBar = menuBar

	# Add some buttons to the MenuBar.
	menuBar.addmenu('File', 'Close this window or exit')
	menuBar.addmenuitem('File', 'command', 'Close this window',
		command = lambda: printme('Action: close'),
		label = 'Close')
	menuBar.addmenuitem('File', 'separator')
	menuBar.addmenuitem('File', 'command', 'Exit the application',
		command = lambda: printme('Action: exit'),
		label = 'Exit')

	menuBar.addmenu('Edit', 'Cut, copy or paste')
	menuBar.addmenuitem('Edit', 'command', 'Delete the current selection',
		command = lambda: printme('Action: delete'),
		label = 'Delete')

	menuBar.addmenu('Options', 'Set user preferences')
	menuBar.addmenuitem('Options', 'command', 'Set general preferences',
		command = lambda: printme('Action: general options'),
		label = 'General...')

	# Create a checkbutton menu item.
        self.toggleVar = Tkinter.IntVar()
	# Initialise the checkbutton to 1:
        self.toggleVar.set(1)
        menuBar.addmenuitem('Options', 'checkbutton', 'Toggle me on/off',
                label = 'Toggle',
                command = self._toggleMe,
                variable = self.toggleVar)
        self._toggleMe()

	menuBar.addcascademenu('Options', 'Size',
		'Set some other preferences', traverseSpec = 'z')
	for size in ('tiny', 'small', 'average', 'big', 'huge'):
	    menuBar.addmenuitem('Size', 'command', 'Set size to ' + size,
		    command = lambda text = size:
			    printme('Action: size ' + text),
		    label = size)

	menuBar.addmenu('Help', 'User manuals', side = 'right')
	menuBar.addmenuitem('Help', 'command', 'About this application',
		command = lambda: printme('Action: about'),
		label = 'About...')

	# Create and pack the main part of the window.
	self.mainPart = Tkinter.Label(parent,
		text = 'This is the\nmain part of\nthe window',
		background = 'black',
		foreground = 'white',
		padx = 30,
		pady = 30)
	self.mainPart.pack(fill = 'both', expand = 1)

	# Create and pack the MessageBar.
	self.messageBar = Pmw.MessageBar(parent,
		entry_width = 40,
		entry_relief='groove',
		labelpos = 'w',
	        label_text = 'Status:')
	self.messageBar.pack(fill = 'x', padx = 10, pady = 10)

	buttonBox = Pmw.ButtonBox(parent)
	buttonBox.pack(fill = 'x', expand = 1)
	buttonBox.add('Disable all', command = menuBar.disableall)
	buttonBox.add('Enable all', command = menuBar.enableall)
	buttonBox.add('Create menu', command = self.add)
	buttonBox.add('Delete menu', command = self.remove)

	# Configure the balloon to displays its status messages in the
	# message bar.
	self.balloon.configure(statuscommand = self.messageBar.helpmessage)

	self.testMenuList = []

    def _toggleMe(self):
        print 'Toggle value:', self.toggleVar.get()

    def add(self):
	if len(self.testMenuList) == 0:
	    num = 0
	else:
	    num = self.testMenuList[-1]
	num = num + 1
	name = 'Menu%d' % num
	self.testMenuList.append(num)

	self.menuBar.addmenu(name, 'This is ' + name)
	self.menuBar.addmenuitem(name, 'command', 'Some help',
		command = lambda text = name:
			printme('Action: new menu ' + text),
		label = 'Item1')

    def remove(self):
	if len(self.testMenuList) == 0:
	    self.menuBar.bell()
	else:
	    num = self.testMenuList[0]
	    name = 'Menu%d' % num
	    self.testMenuList[:1] = []
	    self.menuBar.deletemenu(name)

######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Pmw MenuBar demonstration')

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
