%module _gnomeui

%{
#include "gnome.h"
#include "sysmodule.h"
%}

%include "glue.i"
%include "gnomeenums.i"
%include "obj_typemap.i"

// This holds all the GnomeUIInfo handling stuff
%include "gnomeui-info.i"

// This is the gtk_dialog_cauldron code.
%include "gtkcauldron.i"

// this is the gnome-canvas set of objects.
%include "gnome-canvas.i"

%{
  /* I can't wrap argp, since there are no hooks.  So instead I just collect
     any unclaimed arguments and stick them into a new argv list */
static PyObject *newargv = NULL;
static error_t collectArg(int key, char *arg, struct argp_state *state) {
  int i;
  if (key == ARGP_KEY_FINI)
    for (i = state->next; i < state->argc; i++)
      PyList_Append(newargv, PyString_FromString(state->argv[i]));
  else if (key == ARGP_KEY_ARG)
    PyList_Append(newargv, PyString_FromString(arg));
  else
    return ARGP_ERR_UNKNOWN;
  return 0;
}
static struct argp_option options[] = {
  { NULL, 0, NULL, 0, NULL, 0 }
};
static struct argp parser = {
  options, collectArg, "[Python]", NULL, NULL, NULL, NULL
};
  
static PyObject *gnome__init(PyObject *self, PyObject *args) {
  char *app_id;
  int argc, i;
  char **argv;
  PyObject *av;

  if (!PyArg_ParseTuple(args, "s:gnome_init", &app_id))
    return NULL;

  av = PySys_GetObject("argv");
  argc = PyList_Size(av);
  argv = g_new(char *, argc);
  for (i = 0; i < argc; i++)
    argv[i] = g_strdup(PyString_AsString(PyList_GetItem(av, i)));

  /* set up argv collector */
  newargv = PyList_New(1);
  PyList_SetItem(newargv, 0, PyString_FromString(argv[0]));

  if (gnome_user_dir) g_free(gnome_user_dir);
  gnome_init(app_id, &parser, argc, argv, ARGP_SILENT | ARGP_IN_ORDER, NULL);
  for (i = 0; i < argc; i++)
    g_free(argv[i]);
  g_free(argv);

  /* install new argv */
  PySys_SetObject("argv", newargv);
  newargv = NULL;

  /* setup python types for this module */
  pygtk_init();

  Py_INCREF(Py_None);
  return Py_None;
}
%}
%native(gnome_init) PyObject *gnome__init(PyObject *self, PyObject *args);

/* gnome-about.h */
int gnome_about_get_type();
%{
static PyObject *gnome__about_new(PyObject *self, PyObject *args) {
  char *title, *version, *copyright, **authors, *comments, *logo;
  PyObject *list, *item, *ret;
  int len, i;

  if (!PyArg_ParseTuple(args, "zzzOzz", &title, &version, &copyright,
			&list, &comments, &logo))
    return NULL;
  if (!PySequence_Check(list)) {
    PyErr_SetString(PyExc_TypeError, "forth argument not a sequence");
    return NULL;
  }
  len = PySequence_Length(list);
  authors = g_new(char *, len+1);
  authors[len] = NULL;
  for (i = 0; i < len; i++) {
    item = PySequence_GetItem(list, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "sequence member is not a string");
      g_free(authors);
      return NULL;
    }
    authors[i] = PyString_AsString(item);
  }
  ret= PyGtk_New((GtkObject *)gnome_about_new(title, version, copyright,
					      (const char **)authors,
					      comments, logo));
  g_free(authors);
  return ret;
}
%}
%native(gnome_about_new) PyObject *gnome__about_new(PyObject *self,
						    PyObject *args);

/* gnome-actionarea.h */
// XXX fixme

/* gnome-app.h */
int gnome_app_get_type();
GtkWidget *gnome_app_new(char *appname, char *title);
void gnome_app_set_menus(GnomeApp *app, GtkMenuBar *menubar);
void gnome_app_set_toolbar(GnomeApp *app, GtkToolbar *toolbar);
void gnome_app_set_statusbar(GnomeApp *app, GtkWidget *statusbar);
void gnome_app_set_contents(GnomeApp *app, GtkWidget *contents);
void gnome_app_toolbar_set_position(GnomeApp *app,
				    GnomeAppWidgetPositionType pos_toolbar);
void gnome_app_menu_set_position(GnomeApp *app,
				 GnomeAppWidgetPositionType pos_menu);

/* gnome-app-helper.h */
void gnome_app_create_menus(GnomeApp *app, GnomeUIInfo *menuinfo);
void gnome_app_create_toolbar(GnomeApp *app, GnomeUIInfo *toolbarinfo);
void gnome_app_insert_menus(GnomeApp *app, char *path, GnomeUIInfo *menuinfo);
void gnome_app_remove_menus(GnomeApp *app, char *path, int items);

/* gnome-popup-menu.h */
%{
#define pygnome_popup_menu_attach(pop,child) gnome_popup_menu_attach(pop,child,NULL)
%}
GtkWidget *gnome_popup_menu_new(GnomeUIInfo *uiinfo);
%name(gnome_popup_menu_attach) void pygnome_popup_menu_attach(
			GtkWidget *pop, GtkWidget *child);

/* gnome-appbar.h */
int gnome_appbar_get_type();
int GNOME_APPBAR_INTERACTIVE(GnomeAppBar *ab);
GtkWidget *gnome_appbar_new(int has_progress, int has_status,
			    GnomePreferencesType interactivity);
void gnome_appbar_set_status(GnomeAppBar *ab, char *status);
void gnome_appbar_set_default(GnomeAppBar *ab, char *default_status);
void gnome_appbar_push(GnomeAppBar *ab, char *status);
void gnome_appbar_pop(GnomeAppBar *ab);
void gnome_appbar_clear_stack(GnomeAppBar *ab);
void gnome_appbar_set_progress(GnomeAppBar *ab, double percentage);
void gnome_appbar_refresh(GnomeAppBar *ab);
void gnome_appbar_set_prompt(GnomeAppBar *ab, char *prompt, int modal);
void gnome_appbar_clear_prompt(GnomeAppBar *ab);
char *gnome_appbar_get_response(GnomeAppBar *ab);

/* gnome-calculator.h */
int gnome_calculator_get_type();
GtkWidget *gnome_calculator_new();
void gnome_calculator_clear(GnomeCalculator *c, int reset);
void gnome_calculator_set(GnomeCalculator *c, double result);
double gnome_calculator_get_result(GnomeCalculator *c);

/* gnome-client.h */
int gnome_client_get_type();
//GnomeClient *gnome_client_new_default(void);
void gnome_client_disable_master_connection();
GnomeClient *gnome_master_client();
GnomeClient *gnome_cloned_client();
GnomeClient *gnome_client_new();
GnomeClient *gnome_client_new_without_connection();
void gnome_client_connect(GnomeClient *client);
void gnome_client_disconnect(GnomeClient *client);
void gnome_client_set_id(GnomeClient *client, char *client_id);
char *gnome_client_get_id(GnomeClient *client);
char *gnome_client_get_previous_id(GnomeClient *client);
char *gnome_client_get_config_prefix(GnomeClient *client);
char *gnome_client_get_global_config_prefix(GnomeClient *client);
%{
#define client_set_cmd(name,py_name)                                          \
  static PyObject *py_name(PyObject *self, PyObject *args) {                  \
    PyObject *ob, *av = Py_None, *item;                                       \
    int argc = 0, i;                                                          \
    char **argv = NULL;                                                       \
    if (!PyArg_ParseTuple(args, "O!|O:" #name, PyGtk_Type, &ob, &av))         \
      return NULL;                                                            \
    if (av != Py_None && !PySequence_Check(av)) {                             \
      PyErr_SetString(PyExc_TypeError, "2nd argument not None or a sequence");\
      return NULL;                                                            \
    }                                                                         \
    if (av != Py_None) {                                                      \
      argc = PySequence_Length(av);                                           \
      argv = g_new(char *, argc);                                             \
      for (i = 0; i < argc; i++) {                                            \
        item = PySequence_GetItem(av, i);                                     \
        if (!PyString_Check(item)) {                                          \
          PyErr_SetString(PyExc_TypeError, "sequence member not a string");   \
          g_free(argv);                                                       \
          return NULL;                                                        \
        }                                                                     \
        argv[i] = PyString_AsString(item);                                    \
      }                                                                       \
    }                                                                         \
    name(GNOME_CLIENT(PyGtk_Get(ob)), argc, argv);                            \
    if (argv) g_free(argv);                                                   \
    Py_INCREF(Py_None);                                                       \
    return Py_None;                                                           \
  }
client_set_cmd(gnome_client_set_clone_command,
	       gnome__client_set_clone_command)
client_set_cmd(gnome_client_set_discard_command,
	       gnome__client_set_discard_command)
client_set_cmd(gnome_client_set_restart_command,
	       gnome__client_set_restart_command)
client_set_cmd(gnome_client_set_resign_command,
	       gnome__client_set_resign_command)
client_set_cmd(gnome_client_set_shutdown_command,
	       gnome__client_set_shutdown_command)
#undef client_set_cmd
%}
%native(gnome_client_set_clone_command)
  PyObject *gnome__client_set_clone_command(PyObject *self, PyObject *args);
%native(gnome_client_set_discard_command)
  PyObject *gnome__client_set_discard_command(PyObject *self, PyObject *args);
%native(gnome_client_set_restart_command)
  PyObject *gnome__client_set_restart_command(PyObject *self, PyObject *args);
%native(gnome_client_set_resign_command)
  PyObject *gnome__client_set_resign_command(PyObject *self, PyObject *args);
%native(gnome_client_set_shutdown_command)
  PyObject *gnome__client_set_shutdown_command(PyObject *self, PyObject *args);
void gnome_client_set_environment(GnomeClient *client, char *name,char *value);
void gnome_client_set_current_directory(GnomeClient *client, char *dir);
void gnome_client_set_process_id(GnomeClient *client, int pid);
void gnome_client_set_program(GnomeClient *client, char *program);
void gnome_client_set_restart_style(GnomeClient *client,
				    GnomeRestartStyle style);
void gnome_client_set_user_id(GnomeClient *client, char *user_id);
void gnome_client_request_phase_2(GnomeClient *client);
%{
static void PyGnome_interact_function(gpointer a, PyObject *func, int nargs,
				      GtkArg *args) {
  PyObject *ret;
  /* this is the correct implementation, but gnome_client is done wrong */
  /*ret = PyObject_CallFunction(func, "(Oii)",
			      PyGtk_New(GTK_VALUE_OBJECT(args[1])),
			      GTK_VALUE_INT(args[2]),
			      GTK_VALUE_ENUM(args[3])); */
  ret = PyObject_CallFunction(func, "(Oii)",
			      PyGtk_New(*GTK_RETLOC_OBJECT(args[1])),
			      *GTK_RETLOC_INT(args[2]),
			      *GTK_RETLOC_ENUM(args[3]));
  if (ret == NULL) {
    PyErr_Print();
    PyErr_Clear();
    return;
  }
  Py_DECREF(ret);
}
static void PyGnome_destroy_notify(PyObject *data) {
  Py_DECREF(data);
}
static PyObject *gnome__client_request_interaction(PyObject *self,
						   PyObject *args) {
  PyObject *client, *func, *py_dialog;
  GnomeDialogType dialog;
  if (!PyArg_ParseTuple(args, "O!OO", PyGtk_Type, &client, &py_dialog, &func))
    return NULL;
  if (PyGtkEnum_get_value(GTK_TYPE_GNOME_DIALOG_TYPE, py_dialog,(gint*)dialog))
    return NULL;
  if (!PyCallable_Check(func)) {
    PyErr_SetString(PyExc_TypeError, "third argument not callbable");
    return NULL;
  }
  Py_INCREF(func);
  gnome_client_request_interaction_interp(GNOME_CLIENT(PyGtk_Get(client)),
			dialog,
			(GtkCallbackMarshal) PyGnome_interact_function,
			func,
			(GtkDestroyNotify) PyGnome_destroy_notify);
  Py_INCREF(Py_None);
  return Py_None;
}
%}
%native(gnome_client_request_interaction) PyObject *
  gnome__client_request_interaction(PyObject *self, PyObject *args);
void gnome_interaction_key_return(int key, int cancel_shutdown);
void gnome_client_request_save(GnomeClient *client, GnomeSaveStyle save_style,
			       int shutdown, GnomeInteractStyle interact_style,
			       int fast, int global);
void gnome_client_flush(GnomeClient *client);

/* gnome-color-picker.h */
int gnome_color_picker_get_type();
GtkWidget *gnome_color_picker_new();
void gnome_color_picker_set_d(GnomeColorPicker *cp, double r, double g,
			      double b, double a);
void gnome_color_picker_set_i8(GnomeColorPicker *cp, int r, int g,
			       int b, int a);
void gnome_color_picker_set_i16(GnomeColorPicker *cp, int r, int g,
				int b, int a);
%{
static PyObject *gnome__color_picker_get_d(PyObject *self, PyObject *args) {
  PyObject *obj;
  double r, g, b, a;
  if (!PyArg_ParseTuple(args, "O!:gnome_color_picker_get_d", PyGtk_Type, &obj))
    return NULL;
  gnome_color_picker_get_d(GNOME_COLOR_PICKER(PyGtk_Get(obj)), &r, &g, &b, &a);
  return Py_BuildValue("(dddd)", r, g, b, a);
}
static PyObject *gnome__color_picker_get_i8(PyObject *self, PyObject *args) {
  PyObject *obj;
  int r, g, b, a;
  if (!PyArg_ParseTuple(args, "O!:gnome_color_picker_get_i8", PyGtk_Type,&obj))
    return NULL;
  gnome_color_picker_get_i8(GNOME_COLOR_PICKER(PyGtk_Get(obj)), &r, &g, &b,&a);
  return Py_BuildValue("(iiii)", r, g, b, a);
}
static PyObject *gnome__color_picker_get_i16(PyObject *self, PyObject *args) {
  PyObject *obj;
  int r, g, b, a;
  if (!PyArg_ParseTuple(args, "O!:gnome_color_picker_get_i16",PyGtk_Type,&obj))
    return NULL;
  gnome_color_picker_get_i16(GNOME_COLOR_PICKER(PyGtk_Get(obj)), &r, &g,&b,&a);
  return Py_BuildValue("(iiii)", r, g, b, a);
}
%}
%native(gnome_color_picker_get_d) PyObject *gnome__color_picker_get_d(
					PyObject *self, PyObject *args);
%native(gnome_color_picker_get_i8) PyObject *gnome__color_picker_get_i8(
					PyObject *self, PyObject *args);
%native(gnome_color_picker_get_i16) PyObject *gnome__color_picker_get_i16(
					PyObject *self, PyObject *args);
void gnome_color_picker_set_dither(GnomeColorPicker *cp, int dither);
void gnome_color_picker_set_use_alpha(GnomeColorPicker *cp, int use_alpha);
void gnome_color_picker_set_title(GnomeColorPicker *cp, char *title);

/* gnome-dateedit.h */
int gnome_date_edit_get_type();
GtkWidget *gnome_date_edit_new(int the_time, int show_time, int use_24);
void gnome_date_edit_set_time(GnomeDateEdit *gde, int the_time);
void gnome_date_edit_set_popup_range(GnomeDateEdit *gde, int low_hour,
				     int up_hour);
int gnome_date_edit_get_date(GnomeDateEdit *gde);

/* gnome-dentry-edit.h */
int gnome_dentry_edit_get_type();
GtkObject *gnome_dentry_edit_new(GtkNotebook *notebook);
void gnome_dentry_edit_clear(GnomeDEntryEdit *dee);
void gnome_dentry_edit_load_file(GnomeDEntryEdit *dee, char *filename);
%{
static PyObject *gnome__dentry_edit_save_file(PyObject *self, PyObject *args) {
  PyObject *obj;
  char *fname;
  GnomeDesktopEntry *de;
  if (!PyArg_ParseTuple(args, "O!s:gnome_dentry_edit_save_file", PyGtk_Type,
			&obj, &fname))
    return NULL;
  de = gnome_dentry_get_dentry(GNOME_DENTRY_EDIT(PyGtk_Get(obj)));
  de->location = g_strdup(fname);
  gnome_desktop_entry_save(de);
  gnome_desktop_entry_free(de);
  Py_INCREF(Py_None);
  return Py_None;
}
%}
%native(gnome_dentry_edit_save_file) PyObject *gnome__dentry_edit_save_file(
					PyObject *self, PyObject *args);
char *gnome_dentry_edit_get_icon(GnomeDEntryEdit *dee);
char *gnome_dentry_edit_get_name(GnomeDEntryEdit *dee);

/* gnome-dialog.h */
int gnome_dialog_get_type();
GtkWidget *gnome_dialog_new(char *title,
			    char *b1 = NULL, char *b2 = NULL,
			    char *b3 = NULL, char *b4 = NULL,
			    char *b5 = NULL, char *b6 = NULL,
			    char *b7 = NULL, char *b8 = NULL,
			    char *b9 = NULL, char *b10 = NULL,
			    char *b11 = NULL);
%{
#define gnome_dialog_get_vbox(o) ((o)->vbox)
static PyObject *gnome__dialog_button_connect(PyObject *self, PyObject *args) {
  PyObject *obj, *callback;
  int button;

  if (!PyArg_ParseTuple(args, "O!iO:gnome_dialog_button_connect", PyGtk_Type,
			&obj, &button, &callback))
    return NULL;
  if (!PyCallable_Check(callback)) {
    PyErr_SetString(PyExc_TypeError, "third argument not callable");
    return NULL;
  }
  gnome_dialog_button_connect(GNOME_DIALOG(PyGtk_Get(obj)), button, NULL,
			      callback);
  Py_INCREF(Py_None);
  return Py_None;
}
%}
GtkWidget *gnome_dialog_get_vbox(GnomeDialog *o);
void gnome_dialog_set_parent(GnomeDialog *o, GtkWindow *parent);
%native(gnome_dialog_button_connect) PyObject *gnome__dialog_button_connect(
					PyObject *self, PyObject *args);
void gnome_dialog_set_modal(GnomeDialog *dialog);
int gnome_dialog_run(GnomeDialog *dialog);
int gnome_dialog_run_modal(GnomeDialog *dialog);
int gnome_dialog_run_and_hide(GnomeDialog *dialog);
int gnome_dialog_run_and_destroy(GnomeDialog *dialog);
void gnome_dialog_set_default(GnomeDialog *dialog, int button);
void gnome_dialog_set_sensitive(GnomeDialog *dialog, int button, int setting);
void gnome_dialog_set_accelerator(GnomeDialog *dialog, int button, char ac_key,
				  int ac_mods);
void gnome_dialog_close(GnomeDialog *dialog);
void gnome_dialog_close_hides(GnomeDialog *dialog, int just_hide);
void gnome_dialog_set_close(GnomeDialog *dialog, int click_closes);
void gnome_dialog_editable_enters(GnomeDialog *dialog, GtkEditable *editable);
void gnome_dialog_set_destroy(GnomeDialog *dialog, int self_destruct);
void gnome_dialog_append_buttons(GnomeDialog *dialog,
				 char *b1 = NULL, char *b2 = NULL,
				 char *b3 = NULL, char *b4 = NULL,
				 char *b5 = NULL, char *b6 = NULL,
				 char *b7 = NULL, char *b8 = NULL,
				 char *b9 = NULL, char *b10 = NULL,
				 char *b11 = NULL);
void gnome_dialog_append_button(GnomeDialog *dialog, char *name);

/*gnome-dialog-util.h */
GtkWidget *gnome_ok_dialog(char *message);
GtkWidget *gnome_error_dialog(char *error);
GtkWidget *gnome_warning_dialog(char *error);
%{
static void PyGnome_reply(gint reply, gpointer data) {
  PyObject *ret = PyObject_CallFunction((PyObject *)data, "i", reply);
  if (ret == NULL) {
    PyErr_Print();
    PyErr_Clear();
  } else
    Py_DECREF(ret);
}
static void PyGnome_string(gchar *string, gpointer data) {
  PyObject *ret = PyObject_CallFunction((PyObject *)data, "s", string);
  if (ret == NULL) {
    PyErr_Print();
    PyErr_Clear();
  } else
    Py_DECREF(ret);
  g_free(string);
}
#define create_func(name, py_name, cbh) static PyObject *name(PyObject *self, \
                                                       PyObject *args) { \
  PyObject *cb; \
  char *msg; \
  if (!PyArg_ParseTuple(args, "sO:" # py_name, &msg, &cb)) \
    return NULL; \
  if (!PyCallable_Check(cb)) { \
    PyErr_SetString(PyExc_TypeError, "second argument not callable"); \
    return NULL; \
  } \
  return PyGtk_New((GtkObject *)py_name(msg, cbh, cb)); \
}
create_func(gnome__question_dialog, gnome_question_dialog, PyGnome_reply)
create_func(gnome__question_dialog_modal, gnome_question_dialog_modal,
	    PyGnome_reply)
create_func(gnome__ok_cancel_dialog, gnome_ok_cancel_dialog, PyGnome_reply)
create_func(gnome__ok_cancel_dialog_modal, gnome_ok_cancel_dialog_modal,
	    PyGnome_reply)
create_func(gnome__request_string_dialog, gnome_request_string_dialog,
	    PyGnome_string)
create_func(gnome__request_password_dialog, gnome_request_password_dialog,
	    PyGnome_string)
%}
%native(gnome_question_dialog) PyObject *gnome__question_dialog(
					PyObject *self, PyObject *args);
%native(gnome_question_dialog_modal) PyObject *gnome__question_dialog_modal(
					PyObject *self, PyObject *args);
%native(gnome_ok_cancel_dialog) PyObject *gnome__ok_cancel_dialog(
					PyObject *self, PyObject *args);
%native(gnome_ok_cancel_dialog_modal) PyObject *gnome__ok_cancel_dialog_modal(
					PyObject *self, PyObject *args);
%native(gnome_request_string_dialog) PyObject *gnome__request_string_dialog(
					PyObject *self, PyObject *args);
%native(gnome_request_password_dialog) PyObject *gnome__request_password_dialog
					(PyObject *self, PyObject *args);
/* gnome-entry.h */
int gnome_entry_get_type();
GtkWidget *gnome_entry_new(char *history_id);
GtkWidget *gnome_entry_gtk_entry(GnomeEntry *gentry);
void gnome_entry_set_history_id(GnomeEntry *gentry, char *history_id);
void gnome_entry_prepend_history(GnomeEntry *gentry, int save, char *text);
void gnome_entry_append_history(GnomeEntry *gentry, int save, char *text);
void gnome_entry_load_history(GnomeEntry *gentry);
void gnome_entry_save_history(GnomeEntry *gentry);

/* gnome-file-entry.h */
int gnome_file_entry_get_type();
GtkWidget *gnome_file_entry_new(char *history_id, char *browse_dialog_title);
GtkWidget *gnome_file_entry_gnome_entry(GnomeFileEntry *fentry);
GtkWidget *gnome_file_entry_gtk_entry(GnomeFileEntry *fentry);
void gnome_file_entry_set_title(GnomeFileEntry *fentry,
				char *browse_dialog_title);

/* gnome-font-selector.h */
int gnome_font_selector_get_type();
GtkWidget *gnome_font_selector_new();
%{
  /* these functions coded explicitly to prevent memory leak */
static PyObject *gnome__font_selector_get_selected(PyObject *self,
						   PyObject *args) {
  PyObject *ob, *ret;
  char *font;
  if (!PyArg_ParseTuple(args, "O!:gnome_font_selector_get_selected",
			PyGtk_Type, &ob))
    return NULL;
  font = gnome_font_selector_get_selected(GNOME_FONT_SELECTOR(PyGtk_Get(ob)));
  ret = PyString_FromString(font);
  g_free(font);
  return ret;
}
static PyObject *gnome__font_select(PyObject *self, PyObject *args) {
  PyObject *ret;
  char *font;
  if (!PyArg_ParseTuple(args, ":gnome_font_select"))
    return NULL;
  font = gnome_font_select();
  ret = PyString_FromString(font);
  g_free(font);
  return ret;
}
static PyObject *gnome__font_select_with_default(PyObject *self,
						 PyObject *args) {
  PyObject *ret;
  char *font, *dflt;
  if (!PyArg_ParseTuple(args, "s:gnome_font_select", &dflt))
    return NULL;
  font = gnome_font_select_with_default(dflt);
  ret = PyString_FromString(font);
  g_free(font);
  return ret;
}
%}
%native(gnome_font_selector_get_selected) PyObject *
  gnome__font_selector_get_selected(PyObject *self, PyObject *args);
%native(gnome_font_select) PyObject *gnome__font_select(PyObject *self,
							PyObject *args);
%native(gnome_font_select_with_default)
     PyObject *gnome__font_select_with_default(PyObject *self, PyObject *args);

/* gnome-ice.h */
void gnome_ice_init();

/* gnome-icon-list.h */
int gnome_icon_list_get_type();
GtkWidget *gnome_icon_list_new();
void gnome_icon_list_set_selection_mode(GnomeIconList *ilist,
					GtkSelectionMode mode);
void gnome_icon_list_set_policy(GnomeIconList *ilist,
				GtkPolicyType vscrollbar_policy,
				GtkPolicyType hscrollbar_policy);
void gnome_icon_list_append(GnomeIconList *ilist, char *icon_filename,
			    char *text);
void gnome_icon_list_insert(GnomeIconList *ilist, int position,
			    char *icon_filename, char *text);
void gnome_icon_list_remove(GnomeIconList *ilist, int position);
void gnome_icon_list_clear(GnomeIconList *ilist);
%{
static PyObject *gnome__icon_list_set_icon_data(PyObject *self,
						PyObject *args) {
  PyObject *ilist, *data;
  int pos;
  if (!PyArg_ParseTuple(args, "O!iO:gnome_icon_list_set_icon_data", PyGtk_Type,
			&ilist, &pos, &data))
    return NULL;
  Py_INCREF(data);
  gnome_icon_list_set_icon_data_full(GNOME_ICON_LIST(PyGtk_Get(ilist)), pos,
				     data, (GtkDestroyNotify)
				     PyGnome_destroy_notify);
  Py_INCREF(Py_None);
  return Py_None;
}
%}
%native(gnome_icon_list_set_icon_data) PyObject *
  gnome__icon_list_set_icon_data(PyObject *self, PyObject *args);
%typemap(python,in) PyObject * { $target = $source; }
%typemap(python,out) PyObject * { Py_INCREF($source); $target = $source; }
PyObject *gnome_icon_list_get_icon_data(GnomeIconList *ilist, int pos);
int gnome_icon_list_find_icon_from_data(GnomeIconList *ilist, PyObject *data);
void gnome_icon_list_select_icon(GnomeIconList *ilist, int pos);
void gnome_icon_list_unselect_icon(GnomeIconList *ilist, int pos);
void gnome_icon_list_freeze(GnomeIconList *ilist);
void gnome_icon_list_thaw(GnomeIconList *ilist);
void gnome_icon_list_moveto(GnomeIconList *ilist, int pos, double yalign);
int gnome_icon_list_icon_is_visible(GnomeIconList *ilist, int pos);
void gnome_icon_list_set_foreground(GnomeIconList *ilist, int pos,
				    GdkColor *color);
void gnome_icon_list_set_background(GnomeIconList *ilist, int pos,
				    GdkColor *color);
void gnome_icon_list_set_row_spacing(GnomeIconList *ilist, int spacing);
void gnome_icon_list_set_col_spacing(GnomeIconList *ilist, int spacing);
void gnome_icon_list_set_text_spacing(GnomeIconList *ilist, int spacing);
void gnome_icon_list_set_icon_border(GnomeIconList *ilist, int spacing);
void gnome_icon_list_set_separators(GnomeIconList *ilist, char *separators);
void gnome_icon_list_set_mode(GnomeIconList *ilist, GnomeIconListMode mode);
void gnome_icon_list_set_border(GnomeIconList *ilist, GtkShadowType border);
int gnome_icon_list_get_icon_at(GnomeIconList *ilist, int x, int y);
//void gnome_icon_list_unselect_all(GnomeIconList *ilist, GdkEvent *event,

/* gnome-icon-sel.h */
int gnome_icon_selection_get_type();
GtkWidget *gnome_icon_selection_new();
void gnome_icon_selection_add_defaults(GnomeIconSelection *gis);
void gnome_icon_selection_add_directory(GnomeIconSelection *gis, char *dir);
void gnome_icon_selection_show_icons(GnomeIconSelection *gis);
void gnome_icon_selection_clear(GnomeIconSelection *gis);
char *gnome_icon_selection_get_icon(GnomeIconSelection *gis, int full_path);
void gnome_icon_selection_select_icon(GnomeIconSelection *gis, char *filename);

/* gnome-lamp.h */
int gnome_lamp_get_type();
GtkWidget *gnome_lamp_new();
GtkWidget *gnome_lamp_new_with_color(GdkColor *color);
GtkWidget *gnome_lamp_new_with_type(char *type);
void gnome_lamp_set_color(GnomeLamp *lamp, GdkColor *color);
void gnome_lamp_set_sequence(GnomeLamp *lamp, char *seq);
void gnome_lamp_set_type(GnomeLamp *lamp, char *type);

void gnome_lamp_set_window_type(GtkWindow *window, char *type);

/* gnome-less.h */
%typemap(python,in) FILE * {
  if (PyFile_Check($source))
    $target = PyFile_AsFile($source);
  else {
    PyErr_SetString(PyExc_TypeError, "argument not a file stream");
    return NULL;
  }
}
int gnome_less_get_type();
GtkWidget *gnome_less_new();
void gnome_less_clear(GnomeLess *gl);
void gnome_less_show_file(GnomeLess *gl, char *path);
void gnome_less_show_command(GnomeLess *gl, char *command_line);
void gnome_less_show_string(GnomeLess *gl, char *string);
int gnome_less_show_filestream(GnomeLess *gl, FILE *f);
void gnome_less_set_font(GnomeLess *gl, GdkFont *font);
void gnome_less_set_fixed_font(GnomeLess *gl, int fixed);
void gnome_less_reshow(GnomeLess *gl);
void gnome_less_fixed_font(GnomeLess *pl);

/* gnome-mdi.h */
int gnome_mdi_get_type();
GtkObject *gnome_mdi_new(char *appname, char *title);
void gnome_mdi_set_mode(GnomeMDI *mdi, GnomeMDIMode mode);
void gnome_mdi_set_tab_pos(GnomeMDI *mdi, GtkPositionType pos);
void gnome_mdi_set_menu_template(GnomeMDI *mdi, GnomeUIInfo *nofree);
void gnome_mdi_set_toolbar_template(GnomeMDI *mdi, GnomeUIInfo *nofree);
void gnome_mdi_set_child_menu_path(GnomeMDI *mdi, char *path);
//void gnome_mdi_set_child_menu_label(GnomeMDI *mdi, char *label);
void gnome_mdi_set_child_list_path(GnomeMDI *mdi, char *path);
GnomeMDIChild *gnome_mdi_active_child(GnomeMDI *mdi);
int gnome_mdi_add_view(GnomeMDI *mdi, GnomeMDIChild *child);
int gnome_mdi_remove_view(GnomeMDI *mdi, GtkWidget *wid, int force);
GtkWidget *gnome_mdi_active_view(GnomeMDI *mdi);
void gnome_mdi_set_active_view(GnomeMDI *mdi, GtkWidget *view);
int gnome_mdi_add_child(GnomeMDI *mdi, GnomeMDIChild *child);
int gnome_mdi_remove_child(GnomeMDI *mdi, GnomeMDIChild *child, int force);
int gnome_mdi_remove_all(GnomeMDI *mdi, int force);
void gnome_mdi_update_child(GnomeMDI *mdi, GnomeMDIChild *child);
GnomeMDIChild *gnome_mdi_find_child(GnomeMDI *mdi, char *name);
void gnome_mdi_register(GnomeMDI *mdi, GtkWidget *wid);
void gnome_mdi_unregister(GnomeMDI *mdi, GtkWidget *wid);
GnomeApp *gnome_mdi_get_app_from_view(GtkWidget *view);
GnomeMDIChild *gnome_mdi_get_child_from_view(GtkWidget *view);

/* gnome-mdi-child.h */
int gnome_mdi_child_get_type();
GnomeMDIChild *gnome_mdi_child_new();
//gnome_mdi_child_get_views
GtkWidget *gnome_mdi_child_add_view(GnomeMDIChild *child);
void gnome_mdi_child_remove_view(GnomeMDIChild *child, GtkWidget *view);
void gnome_mdi_child_set_name(GnomeMDIChild *child, char *name);
void gnome_mdi_child_set_menu_template(GnomeMDIChild *child,
				       GnomeUIInfo *nofree);

/* gnome-messagebox.h */
int gnome_message_box_get_type();
/*simulate varargs ... */
GtkWidget *gnome_message_box_new(char *message, char *messagebox_type,
				 char *b1 = NULL, char *b2 = NULL,
				 char *b3 = NULL, char *b4 = NULL,
				 char *b5 = NULL, char *b6 = NULL,
				 char *b7 = NULL, char *b8 = NULL,
				 char *b9 = NULL, char *b10 = NULL,
				 char *b11 = NULL);

/* gnome-net.h */
// XXX fixme

/* gnome-number-entry.h */
int gnome_number_entry_get_type();
GtkWidget *gnome_number_entry_new(char *history_id, char *calc_dlg_title);
GtkWidget *gnome_number_entry_gnome_entry(GnomeNumberEntry *nentry);
GtkWidget *gnome_number_entry_gtk_entry(GnomeNumberEntry *nentry);
void gnome_number_entry_set_title(GnomeNumberEntry *nentry, char *calc_title);
double gnome_number_entry_get_number(GnomeNumberEntry *nentry);

/* gnome-pixmap.h */
int gnome_pixmap_get_type();
GtkWidget *gnome_pixmap_new_from_file(char *filename);
GtkWidget *gnome_pixmap_new_from_file_at_size(char *filename, int width,
					      int height);
void gnome_pixmap_load_file(GnomePixmap *gpixmap, char *filename);
void gnome_pixmap_load_file_at_size(GnomePixmap *gpixmap, char *filename,
				    int width, int height);

/* gnome-propertybox.h */
int gnome_property_box_get_type();
GtkWidget *gnome_property_box_new();
void gnome_property_box_changed(GnomePropertyBox *property_box);
void gnome_property_box_append_page(GnomePropertyBox *property_box,
				    GtkWidget *child, GtkWidget *tab_label);

/* gnome-rootwin.h */
int gnome_rootwin_get_type();
GtkWidget *gnome_rootwin_new();

/* gnome-scores.h */
int gnome_scores_get_type();

%typemap(python,in) char *str_or_none {
  if ($source == Py_None)
    $target = NULL;
  else if (PyString_Check($source))
    $target = PyString_AsString($source);
  else {
    PyErr_SetString(PyExc_TypeError, "argument not a string or None");
    return NULL;
  }
}
void gnome_scores_display(char *title, char *app_name, char *str_or_none,
			  int pos);
%{
static PyObject *gnome__scores_new(PyObject *self, PyObject *args) {
  PyObject *list, *item;
  guint num, i, clear;
  gchar **names;
  gfloat *scores;
  time_t *times;
  GtkWidget *ret;
  if (!PyArg_ParseTuple(args, "O!i:gnome_scores_new", &PyList_Type, &list,
			&clear))
    return NULL;
  num = PyList_Size(list);
  names = g_new(gchar *, num);
  scores = g_new(gfloat, num);
  times = g_new(time_t, num);
  for (i = 0; i < num; i++) {
    item = PyList_GetItem(list, i);
    if (!PyArg_ParseTuple(item, "sfi", &names[i], &scores[i], &times[i])) {
      PyErr_Clear();
      g_free(names);
      g_free(scores);
      g_free(times);
      PyErr_SetString(PyExc_TypeError,"list items should be (name,score,time");
      return NULL;
    }
  }
  ret = gnome_scores_new(num, names, scores, times, clear);
  g_free(names);
  g_free(scores);
  g_free(times);
  return PyGtk_New((GtkObject *)ret);
}
%}
%native(gnome_scores_new) PyObject *gnome__scores_new(PyObject *self,
						     PyObject *args);
void gnome_scores_set_logo_label(GnomeScores *gs, char *txt, char *font,
				  GdkColor *color);
void gnome_scores_set_logo_pixmap(GnomeScores *gs, char *logo);
void gnome_scores_set_logo_widget(GnomeScores *gs, GtkWidget *w);
void gnome_scores_set_color(GnomeScores *gs, int pos, GdkColor *col);
void gnome_scores_set_def_color(GnomeScores *gs, GdkColor *col);
// gnome_scores_set_colors
void gnome_scores_set_logo_label_title(GnomeScores *gs, char *txt);
void gnome_scores_set_current_player(GnomeScores *gs, int i);

/* gnome-startup */
int gnome_startup_acquire_token(char *property_name, char *sm_id);

/* gnome-stock.h */
int gnome_stock_get_type();
GtkWidget *gnome_stock_new();
GtkWidget *gnome_stock_new_with_icon(char *icon);
void gnome_stock_set_icon(GnomeStock *widget, char *icon);
GtkWidget *gnome_stock_button(char *type);
GtkWidget *gnome_stock_or_ordinary_button(char *type);
GtkWidget *gnome_stock_menu_item(char *type, char *text);
%{
static PyObject *gnome__stock_menu_accel(PyObject *self, PyObject *args) {
  char *type;
  guchar key;
  guint8 mod;
  gboolean ret;

  if (!PyArg_ParseTuple(args, "s:gnome_stock_menu_accel", &type))
    return NULL;
  ret = gnome_stock_menu_accel(type, &key, &mod);
  if (!ret) {
    PyErr_SetString(PyExc_KeyError, type);
    return NULL;
  }
  return Py_BuildValue("(ci)", key, mod);
}
%}
%native(gnome_stock_menu_accel) PyObject *gnome__stock_menu_accel(
					PyObject *self, PyObject *args);
void gnome_stock_menu_accel_parse(char *section);
GtkWidget *gnome_stock_transparent_window(char *icon, char *subtype);

/* gtkcalendar.h */
int gtk_calendar_get_type();
GtkWidget *gtk_calendar_new();
int gtk_calendar_select_month(GtkCalendar *cal, int month, int year);
void gtk_calendar_select_day(GtkCalendar *cal, int day);
int gtk_calendar_mark_day(GtkCalendar *cal, int day);
int gtk_calendar_unmark_day(GtkCalendar *cal, int day);
void gtk_calendar_clear_marks(GtkCalendar *cal);
void gtk_calendar_display_options(GtkCalendar *cal,
				  GtkCalendarDisplayOptions flags);
%{
static PyObject *gtk__calendar_get_date(PyObject *self, PyObject *args) {
  PyObject *cal;
  int year, month, day;
  if (!PyArg_ParseTuple(args, "O!:gtk_calendar_get_date", PyGtk_Type, &cal))
    return NULL;
  gtk_calendar_get_date(GTK_CALENDAR(PyGtk_Get(cal)), &year, &month, &day);
  return Py_BuildValue("(iii)", year, month, day);
}
%}
%native(gtk_calendar_get_date) PyObject *gtk__calendar_get_date(PyObject *self,
							PyObject *args);
void gtk_calendar_freeze(GtkCalendar *calendar);
void gtk_calendar_thaw(GtkCalendar *calendar);

/* gtk-clock.h */
int gtk_clock_get_type();
GtkWidget *gtk_clock_new(GtkClockType type);
void gtk_clock_set_format(GtkClock *gclock, char *fmt);
void gtk_clock_set_seconds(GtkClock *gclock, long seconds);
void gtk_clock_set_update_interval(GtkClock *gclock, int seconds);
void gtk_clock_start(GtkClock *gclock);
void gtk_clock_stop(GtkClock *gclock);

/* gdkdial.h */
int gtk_dial_get_type();
GtkWidget *gtk_dial_new(GtkAdjustment *adj=NULL);
GtkAdjustment *gtk_dial_get_adjustment(GtkDial *dial);
void gtk_dial_set_update_policy(GtkDial *dial, GtkUpdateType policy);
void gtk_dial_set_adjustment(GtkDial *dial, GtkAdjustment *adj);
float gtk_dial_set_percentage(GtkDial *dial, float pcnt);
float gtk_dial_get_percentage(GtkDial *dial);
float gtk_dial_set_value(GtkDial *dial, float value);
float gtk_dial_get_value(GtkDial *dial);
void gtk_dial_set_view_only(GtkDial *dial, int view_only);

/* gtklayout.h */
int gtk_layout_get_type();
GtkWidget *gtk_layout_new(GtkAdjustment *hadj = NULL,
			  GtkAdjustment *vadj = NULL);
void gtk_layout_put(GtkLayout *layout, GtkWidget *widget, int x, int y);
void gtk_layout_move(GtkLayout *layout, GtkWidget *widget, int x, int y);
void gtk_layout_set_size(GtkLayout *layout, int width, int height);
void gtk_layout_freeze(GtkLayout *layout);
void gtk_layout_thaw(GtkLayout *layout);
GtkAdjustment *gtk_layout_get_hadjustment(GtkLayout *layout);
GtkAdjustment *gtk_layout_get_vadjustment(GtkLayout *layout);
void gtk_layout_set_hadjustment(GtkLayout *layout, GtkAdjustment *adj);
void gtk_layout_set_vadjustment(GtkLayout *layout, GtkAdjustment *adj);

/* gtk-plug.h */
int gtk_plug_get_type();
GtkWidget *gtk_plug_new(unsigned int socket_id);

/* gtk-socket.h */
int gtk_socket_get_type();
GtkWidget *gtk_socket_new();
void gtk_socket_steal(GtkSocket *gsocket, unsigned int wid);

/* gtkspell.h */
int gtk_spell_get_type();
GtkWidget *gtk_spell_new();
int gtk_spell_check(GtkSpell *spell, char *str);
void gtk_spell_accept(GtkSpell *spell, char *word);
void gtk_spell_insert(GtkSpell *spell, char *word, int lowercase);
void gtk_spell_next(GtkSpell *spell);
void gtk_spell_kill(GtkSpell *spell);

/* gtk-ted.h */
int gtk_ted_get_type();
void gtk_ted_set_app_name(char *str);
void gtk_ted_prepare(GtkTed *ted);
GtkWidget *gtk_ted_new(char *dialog_name);
GtkWidget *gtk_ted_new_layout(char *dialog_name, char *layout);
void gtk_ted_add(GtkTed *ted, GtkWidget *widget, char *name);
