#
# The Python Imaging Library.
# $Id: ContainerIO.py,v 1.2 1996/11/10 17:52:14 fredrik Exp $
#
# a class to read from a container file
#
# History:
#	95-06-18 fl	Created
#	95-09-07 fl	Added readline(), readlines()
#
# Copyright (c) Secret Labs AB 1997.
# Copyright (c) Fredrik Lundh 1995.
#
# See the README file for information on usage and redistribution.
#

# --------------------------------------------------------------------
# Return a restricted file object allowing a user to read and
# seek/tell an individual file within a container file (for example
# a TAR file).

class ContainerIO:

    def __init__(self, fh, offset, length):
	self.fh = fh
	self.pos = 0
	self.offset = offset
	self.length = length
	self.fh.seek(offset)

    def isatty(self):
        return 0

    def seek(self, offset, mode = 0):
	if mode == 1:
	    self.pos = self.pos + offset
	elif mode == 2:
	    self.pos = self.length + offset
	else:
	    self.pos = offset
	# clamp
	self.pos = max(0, min(self.pos, self.length))
	self.fh.seek(self.offset + self.pos)

    def tell(self):
	return self.pos

    def read(self, n = 0):
	if n:
	    n = min(n, self.length - self.pos)
	else:
	    n = self.length - self.pos
	if not n: # EOF
	    return ""
	self.pos = self.pos + n
	return self.fh.read(n)

    def readline(self):
	s = ""
	while 1:
	    c = self.read(1)
	    if not c:
		break
	    s = s + c
	    if c == "\n":
		break
	return s

    def readlines(self):
	l = []
	while 1:
	    s = self.readline(self)
	    if not s:
		break
	    l.append(s)
	return l
