#include "pscol.h"

/*********************************************************************/
/*                                                                   */
/* convline: Takes a string and converts everything.  The Type, uid, */
/*           and the color.  See bugs for username problem           */
/*                                                                   */
/*********************************************************************/

char *convline(char *col, char *filename, int lineno)
{
 char *nametype[] = {"unk", "user", "state", "mem", "cpu", "size", "tty", 0};
 char *colors[] = {"non", "bla", "red", "gre", "yel", "blu", "mag", "cya",
                   "whi", 0};
 char *other[] = {"bri", "bli", "on", "", 0};
 char *markup, *data, *color, *y, **users;
 struct passwd *pw;
 int x, c, bri, bli, fg, bg;

 if (*col == '=') return col;
 if (count(col, ',') != 2)
 {
  error("%s: %d: parse error on '%s'", filename, lineno, col);
  return NULL;
 }
 markup = strtok(strdup(col), ",");
 data = strtok(NULL, ",");
 color = strtok(NULL, ",");
 if (markup == NULL || data == NULL || color == NULL)
 {
  error("%s: %d: parse error on '%s'", filename, lineno, col);
  return NULL;
 }
 if (!needconv(markup, data, color)) return col;

 /* check markup range and name */
 if (allnum(markup))
 {
  x = atoi(markup);
  if (x == 0 || x > 7)
  {
   error("%s: %d: markup out of range '%s'", filename, lineno, markup);
   return NULL;
  }  
 }
 else
 {
  x = strarraycmp(markup, nametype);
  if (x == -1)
  {
   error("%s: %d: invalid markup name '%s'", filename, lineno, markup);
   return NULL;
  }
  markup[0] = x + '1';
  markup[1] = 0;
 }

 /* if markup is 2 and data is not all numbers, convert to UID */
 x = 0;
 if (*markup == '2')
 {
  /* allocate a user array to hold multi users. */
  users = malloc((count(data, ':') + 2) * 4);
  bzero(users, (count(data, ':') + 2) * 4);
  for (y = strtok(strdup(data), ":");y;y = strtok(NULL, ":"), x++)
   if (!allnum(y))
   {
    if (!strcmp(y, "+"))
    {
     users[x] = malloc(6);
     bzero(users[x], 6);
     sprintf(users[x], "%d", getuid());
    }
    else
    {
     pw = getpwnam(y);
     if (!pw)
     {
      warn("%s: %d: username not found '%s'", filename, lineno, y);
      continue;
     }
     users[x] = malloc(6); /* put UID in data */
     bzero(users[x], 6);
     sprintf(users[x], "%d", pw->pw_uid);
    }
   }
   else
    users[x] = strdup(y);
 }

 /* if not in ansi form, convert to ansi */
 if (!isansi(color))
 {
  x = 0;  /* 0 means working in foreground, 1 means "on" has been found */
  bri = bli = 0;
  fg = bg = -1;
  for(y = strtok(strdup(color), " ");y;y = strtok(NULL, " "))
  {
   if (strlen(y) > 3) y[3] = 0;  /* only first 3 characters recognized    */
                                 /* you could do this:                    */
                                 /* briliant greif on redspots            */
                                 /* would become:                         */
                                 /* bri gre on red  (bright green on red) */
   switch (strarraycmp(y, other))
   {
    case -1: c = strarraycmp(y, colors);
             if (c == -1)
             {
              error("%s: %d: color data invalid '%s'", filename, lineno,
                    color);
              return NULL;
             }
             if (x == 0)
             {
              if (fg != -1)
              {
               error("%s: %d: foreground specified more than once '%s'",
                     filename, lineno, color);
               return NULL;
              }
              fg = c;
             }
             else
             {
              if (bg != -1)
              {
               error("%s: %d: background specified more than once '%s'",
                     filename, lineno, color);
               return NULL;
              }
              bg = c;
             }
             break;
    case  0: if (x == 0)
             {
              if (bri)
              {
               warn("%s: %d: bright specified more than once '%s'", filename,
                    lineno, color);
              }              
              bri = 1;
             }
             else
             {
              error("%s: %d: bright specified in background '%s'", filename,
                    lineno, color);
              return NULL;
             }
             break;
    case  1: if (x == 0)
             {
              if (bli)
              {
               warn("%s: %d: blinking specified more than once '%s'", filename,
                    lineno, color);
              }              
              bli = 1;
             }
             else
             {
              error("%s: %d: blinking specified in background '%s'", filename,
                    lineno, color);
              return NULL;
             }
             break;
    case  2: if (x == 0)  /* shift to background colors */
              x = 1;
             else
             {
              error("%s: %d: 'on' specified more than once '%s'", filename,
                    lineno, color);
              return NULL;
             }
   }
  }
  /* if "on" was on the line, but no BG color selected, complain */
  if (x == 1 && bg == -1)
   warn("%s: %d: 'on' specified, but no background color specified '%s'",
        filename, lineno, color);

  /* if they weren't specified, set to none */
  if (bg == -1) bg = 0;
  if (fg == -1) fg = 0;
  color = malloc(12);  /* max length of any of our ansi strings is 12 */
                       /* including terminator */
  bzero(color, 12);
  if (bri) strcat(color, "01");
  if (bli)
  {
   if (*color) strcat(color, ";");
   strcat(color, "05");
  }
  if (fg)  /* 0 means don't do anything. */
  {
   fg += '0' - 1;
   y = malloc(3); /* temp space */
   y[0] = '3';
   y[1] = fg;
   y[2] = 0;
   if (*color) strcat(color, ";");
   strcat(color, y);
   free(y);
  }
  if (bg)  /* 0 means don't do anything. */
  {
   bg += '0' - 1;
   y = malloc(3); /* temp space */
   y[0] = '4';
   y[1] = bg;
   y[2] = 0;
   if (*color) strcat(color, ";");
   strcat(color, y);
   free(y);
  } 
 }
 if (*markup == '2')
 {
  x = 0;
  for (c = 0;users[c];c++)
   x += strlen(markup) + strlen(users[c]) + strlen(color) + 3;
  y = malloc(x);
  bzero(y, x);
  for (c = 0;users[c];c++)
  {
   /* get around original limitation of the program */
   if (*y) strcat(y, "%");
   sprintf(y + strlen(y), "%s,%s,%s", markup, users[c], color);
  }
 }
 else
 {
  y = malloc(strlen(markup) + strlen(data) + strlen(color) + 3);
  sprintf(y, "%s,%s,%s", markup, data, color);
 }
 return y;
}
