### Copyright (C) 1995-1997 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


############################################################
# function to parse input file.
############################################################
proc parseFile {} {
  global __subPath __progList __saveInfo argv argv0 __pathProgsNames 
  global __files __menu2funk __progGenList module

  set __progList {}
  foreach fileName $__files {
    set IN [open [lindex $argv 1]/$fileName]
    set function 0
    
    while {![eof $IN]} {
      gets $IN line
      if {$function} {
        # read the info line
        if {![regexp {^ *\#(.*)$} $line all line]} {
          puts "Error in template file \"$fileName\", near function $funkName"
          puts "Type path must be the first line in the function"
          exit -1
        }
        set lastPath "/"
        while {[regexp {^([^/]*)/(.*)$} $line all elm line]} {
          set elm [string trim $elm]
          if {[info exists __menu2funk($lastPath$elm)]} {
            error [concat "Both a submenu and a menupage exists which" \
                       "is called \"$lastPath$elm\""]
          }
          uniqAppend __subPath($lastPath) $elm
          append lastPath "$elm/"
        }
        set line [string trim $line]
        if {$line == ""} {
          set line $funkName
        }
        set __pathProgsNames($funkName) "$lastPath$line"
        if {[info exists __subPath($lastPath)] &&
            [lsearch -exact $__subPath($lastPath) $line] != -1} {
          error "page with path \"$lastPath$line\" defined more than once"
        }
        uniqAppend __subPath($lastPath) $line
        set __menu2funk($lastPath$line) $funkName
        if {[info exists __subPath($lastPath$line/)]} {
          error [concat "Both a submenu and a menupage exists which" \
                     "is called \"$lastPath$line\""]
        }
        set function 0
      } elseif {[regexp {^proc ([^\{]+) \{} $line all funk]} {
        set funkName $funk
        if {[lsearch -exact $__progList $funk] != -1} {
          error "function \"$funk\" found more than once."
        }
        lappend __progList $funk
        set __saveInfo($funk) 0
        set function 1
        set lastPath "/"
      }
    }
    close $IN
  }
  if {[info exists module(generationOrder)]} {
    set __progGenList $module(generationOrder)
    foreach pr $__progList {
      if {[lsearch -exact $__progGenList $pr] == -1} {
        lappend __progGenList $pr
      }
    }
  } else {
    set __progGenList $__progList
  }
}
