#!/usr/local/bin/perl 

@order = ("Symbol.*", "Courier.*", "Times.*", ".*");

# Print header.
print <<'EOF';
%!

% ReEncodeSmall from Adobe Postscript Tutorial and Cookbook
/reencsmalldict 12 dict def
/ReEncodeSmall
 {reencsmalldict begin
  /newcodesandnames exch def
  /newfontname exch def
  /basefontname exch def

  /basefontdict basefontname findfont def
  /newfont basefontdict maxlength dict def

  basefontdict
   {exch dup /FID ne
     {dup /Encoding eq
       {exch dup length array copy
	 newfont 3 1 roll put}
       {exch newfont 3 1 roll put}
       ifelse
     }
     {pop pop}
     ifelse
   }forall

  newfont /FontName newfontname put
  newcodesandnames aload pop

  newcodesandnames length 2 idiv
   {newfont /Encoding get 3 1 roll put}
   repeat

  newfontname newfont definefont pop
  end
}def

/do_show { % encvect fontname charstr fontstr -> -
  /fontstr exch def
  /charstr exch def
  /fontname exch def
  /vect exch def

  bodyfont setfont
  x y moveto charstr show    
  x 200 add y moveto fontstr show

  fontname /Foo-font vect ReEncodeSmall
  /Foo-font findfont ptsize scalefont setfont
  x 400 add y moveto (\0) show

  /y y ptsize sub baselineskip sub def
  
  y 17 lt {
    showpage
    /y height ptsize sub def
  } if
} def

/height 822 def
/ptsize 12 def
/baselineskip 1 def

/x 50 def
/y height ptsize sub baselineskip sub def

/bodyfont /Courier findfont ptsize scalefont def

EOF

# Print body.

$first = 1;
main: while (1) {
    @stack = ();
    $last = "";

    if ($first) {
	$_ = <>;
	if (!$_) {
	    last;
	}
	chop;
	$first = 0;
    }
    while (1) {
	@fields = split;
	$item = @fields[0];

	if ($last EQ "") {
	    $last = $item;
	    # printf("* first: %s\n", $item);
	    push(@stack, $_);
	    $_ = <>;
	    if (!$_) {
		last main;
	    }
	    chop;
	} elsif ($item EQ $last) {
	    push(@stack, $_);
	    $_ = <>;
	    if (!$_) {
		last main;
	    }
	    chop;
	} else {
	    # End of this patch.

	    # Print this letter.
	    exprs: foreach $e (@order) {
		foreach $i (@stack) {
		    if ($i =~ /$e/) {
			@fields = split(/\s+/, $i);
			printf("[0 %s]\t/%s\t(%s)\t(%s)\tdo_show\n",
			       @fields[0], @fields[2], @fields[0],
			       @fields[2]);
			last exprs;
		    }
		}
	    }
	    last;
	}
    }
}

# Print trailer

print "showpage\n";
print "%%EOF\n";
