/*
 * dlsof.h - SGI IRIX header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: dlsof.h,v 1.17 96/05/20 07:49:43 abe Exp $
 */


#if	!defined(IRIX_LSOF_H)
#define	IRIX_LSOF_H	1

#if	defined(IRIX32BITS) || _IRIXV>=60200
/*
 * Defining _KERNEL and above while including <sys/types.h> sometimes
 * changes the size of some types, thus affecting the stat(2) buffer
 * structure.  Switching from [l]stat to [l]stat64 is the cure.
 */

#define	lstat	lstat64
#define	stat	stat64
#endif	/* defined(IRIX32BITS) || _IRIXV>=60200 */

#include <rpc/types.h>
#include <malloc.h>
#include <mntent.h>
#include <signal.h>
#include <string.h>
#include <nlist.h>
#include <unistd.h>

# if	_IRIXV>=50101
#define	L_SET	SEEK_SET
#include <stddef.h>
# endif	/* _IRIXV>=50101 */

#include <netinet/in.h>
#include <sys/conf.h>
#include <sys/dir.h>
#define	_KERNEL	1
#include <sys/file.h>
#undef	_KERNEL
#include <sys/fcntl.h>
#include <sys/flock.h>
#include <sys/immu.h>
#include <sys/sysmacros.h>

# if	_IRIXV<50101
#include <sys/inode.h>
# else	/* _IRIXV>=50101 */
/*
 * Some of the following header files are found in the private subdirectories
 * irix5hdr and irix6hdr.   The files were left out of IRIX distributions.
 * The Configure script enters an -I<sub_directory> C flags option in the
 * Makefile, appropriate to the IRIX version.
 */
#define	_KERNEL	1
#  if	_IRIXV<50200
#include <sys/fs/inode.h>
#  else	/* _IRIXV>=50200 */
#include <sys/fs/efs_inode.h>
#  endif	/* _IRIXV<50200 */
#undef	_KERNEL

# if	defined(HASCACHEFS)
/*
 * Temporarily redefine some function names whose conflicting prototypes appear
 * for applications in <unistd.h> and for the kernel, when _KERNEL is defined,
 * in <sys/systm.h>.  (<cachefs_fs.h> #includes <sys/systm.h>.)
 */
#define	atoi		LSOF_atoi
#define	exit		LSOF_exit
#define	fork		LSOF_fork
#define	printf		LSOF_printf
#define	sleep		LSOF_sleep
#define	sprintf		LSOF_sprintf
#define	vsprintf	LSOF_vsprintf
#define	_KERNEL	1
#include <cachefs/cachefs_fs.h>
#undef	_KERNEL
#undef	atoi
#undef	exit
#undef	fork
#undef	printf
#undef	sleep
#undef	sprintf
#undef	vsprintf
# endif	/* defined(HASCACHEFS) */

#include <fifofs/fifonode.h>
#include <specfs/snode.h>

#include <pipefs/pipenode.h>
#include <sys/fstyp.h>
#include <sys/fsid.h>
#include <sys/major.h>
#include <sys/sat.h>
#include <sys/strsubr.h>
#include <sys/vfs.h>
#include <sys/vnode.h>
# endif	/* _IRIXV<50101 */

#include <sys/major.h>

# if	defined(MFREE)
#undef	MFREE
# endif	/* defined(MFREE) */

#include <sys/mbuf.h>

# if	defined(MFREE)
#undef	MFREE
# endif	/* defined(MFREE) */

#include <sys/mount.h>
#include <sys/proc.h>
#include <sys/stream.h>
#include <sys/syssgi.h>
#include <sys/sysmp.h>
#include <sys/un.h>
#include <sys/unpcb.h>

# if	_IRIXV<60000 || defined(IRIX32BITS)
#include <sys/user.h>
# else	/* _IRIXV>=60000  && !defined(IRIX32BITS) */
#include <sys/sbd.h>
#undef	NWIREDENTRIES
# endif	/* _IRIXV<60000 || defined(IRIX32BITS) */

#include <sys/region.h>
#include <sys/var.h>
#include <sys/fs/nfs.h>
#include <sys/fs/rnode.h>
#define	r_snfsattr	r_nfsattr
#include <sys/domain.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <netinet/in.h>
#include <net/route.h>
#include <net/raw_cb.h>

# if	_IRIXV>=60200
#include <netinet/in_systm.h>
#include <netinet/ip.h>
# endif	/* _IRIXV>=60200 */

#include <netinet/in_pcb.h>

# if	defined(HASPROCFS)
#undef	VTOP
#undef	PTOV
#include <procfs/prdata.h>
#define	PR_ROOTINO	2
# endif	/* defined(HASPROCFS) */

# if	_IRIXV>=60200
#include <sys/uuid.h>
#include <sys/fs/xfs_types.h>
#include <sys/fs/xfs_inum.h>
#include <sys/fs/xfs_bmap_btree.h>
#include <sys/fs/xfs_attr_sf.h>
#include <sys/fs/xfs_dir_sf.h>
#include <sys/fs/xfs_dinode.h>
#include <sys/fs/xfs_inode.h>
# endif	/* _IRIXV>=60200 */

#define	COMP_P		const void
#define DEVINCR		1024	/* device table malloc() increment */
#define	FSNAMEL		4
#define	KA_T		long
#define	KMEM		"/dev/kmem"
#define N_UNIX		"/unix"
#define MALLOC_P	void

# if	defined(MNTTAB)
#undef	MNTTAB
# endif	/* defined(MNTTAB) */

#define	MNTTAB		MOUNTED
#define FREE_P		MALLOC_P
#define MALLOC_S	size_t
#define	PROCSIZE	sizeof(struct proc)
#define QSORT_P		void
#define	READLEN_T	unsigned
#define STRNCPY_L	size_t
#define	STRNML		32
#define U_SIZE		sizeof(struct user)


/*
 * Global storage definitions (including their structure definitions)
 */

struct clone {
	int dx;			/* index of device entry in Devtp[] */
	struct clone *next;	/* forward link */
};
extern struct clone *Clone;


# if	_IRIXV>=50101 && _IRIXV<60200
extern char *Cwd;
# endif	/* _IRIXV>=50101 && _IRIXV<60200 */

# if	_IRIXV>=50101
extern char **Fsinfo;
extern int Fsinfomax;
# else	/* _IRIXV<50101 */
extern struct fsinfo *Fsinfo;
# endif	/* _IRIXV>=50101 */

extern int Kmem;

struct l_vfs {
	struct vfs *addr;		/* kernel address */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */

# if	defined(HASFSINO)
	ino_t fs_ino;			/* file system inode number */
# endif	/* defined(HASFSINO) */

	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;

struct mounts {
        dev_t dev;              	/* st_dev */
        char *dir;              	/* directory */
        char *fsname;           	/* file system */
	ino_t inode;			/* st_ino */
	mode_t mode;			/* st_mode */
        struct mounts *next;    	/* forward link */
	dev_t rdev;			/* st_rdev */

# if	defined(HASFSTYPE)
	char *fstype;			/* st_fstype */
# endif	/* defined(HASFSTYPE) */

};

extern short Nfstyp;

# if	_IRIXV<50101
#define	X_FILE		0
#define	X_FSINFO	1
#define	X_NFSTYP	2
#define	X_PROC		3
#define X_VAR		4
# else	/* _IRIXV>=50101 */
#define	X_NCACHE	0
#define	X_NCSIZE	1
#define	X_PROC		2
#define X_VAR		3
# endif	/* _IRIXV<50101 */

# if	_IRIXV>=50101 && _IRIXV<60200
extern char *Rtd;
# endif	/*_IRIXV>=50101 && _IRIXV<60200 */

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	u_short mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};

# if	_IRIXV>=50101
/*
 * This #include and accompanying #undef's is placed last, lest the
 * #undef's disturb something else.  The #undef's prevent symbol
 * conflicts between <setjmp.h> and <sys/pcb.h>.
 */

#undef	JB_S0
#undef	JB_S1
#undef	JB_S2
#undef	JB_S3
#undef	JB_S4
#undef	JB_S5
#undef	JB_S6
#undef	JB_S7
#undef	JB_SP
#undef	JB_FP
#undef	JB_PC
#undef	NJBREGS
#endif	/* _IRIXV>=50101 */

#include <setjmp.h>

#endif	/* IRIX_LSOF_H	*/
